/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response to the request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAnalyzedResourcesResponse extends AccessAnalyzerResponse implements
        ToCopyableBuilder<ListAnalyzedResourcesResponse.Builder, ListAnalyzedResourcesResponse> {
    private static final SdkField<List<AnalyzedResourceSummary>> ANALYZED_RESOURCES_FIELD = SdkField
            .<List<AnalyzedResourceSummary>> builder(MarshallingType.LIST)
            .getter(getter(ListAnalyzedResourcesResponse::analyzedResources))
            .setter(setter(Builder::analyzedResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analyzedResources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AnalyzedResourceSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(AnalyzedResourceSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListAnalyzedResourcesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYZED_RESOURCES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<AnalyzedResourceSummary> analyzedResources;

    private final String nextToken;

    private ListAnalyzedResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.analyzedResources = builder.analyzedResources;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the AnalyzedResources property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasAnalyzedResources() {
        return analyzedResources != null && !(analyzedResources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of resources that were analyzed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAnalyzedResources()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of resources that were analyzed.
     */
    public List<AnalyzedResourceSummary> analyzedResources() {
        return analyzedResources;
    }

    /**
     * <p>
     * A token used for pagination of results returned.
     * </p>
     * 
     * @return A token used for pagination of results returned.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(analyzedResources());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAnalyzedResourcesResponse)) {
            return false;
        }
        ListAnalyzedResourcesResponse other = (ListAnalyzedResourcesResponse) obj;
        return Objects.equals(analyzedResources(), other.analyzedResources()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListAnalyzedResourcesResponse").add("AnalyzedResources", analyzedResources())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "analyzedResources":
            return Optional.ofNullable(clazz.cast(analyzedResources()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAnalyzedResourcesResponse, T> g) {
        return obj -> g.apply((ListAnalyzedResourcesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AccessAnalyzerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAnalyzedResourcesResponse> {
        /**
         * <p>
         * A list of resources that were analyzed.
         * </p>
         * 
         * @param analyzedResources
         *        A list of resources that were analyzed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analyzedResources(Collection<AnalyzedResourceSummary> analyzedResources);

        /**
         * <p>
         * A list of resources that were analyzed.
         * </p>
         * 
         * @param analyzedResources
         *        A list of resources that were analyzed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analyzedResources(AnalyzedResourceSummary... analyzedResources);

        /**
         * <p>
         * A list of resources that were analyzed.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AnalyzedResourceSummary>.Builder} avoiding
         * the need to create one manually via {@link List<AnalyzedResourceSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AnalyzedResourceSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #analyzedResources(List<AnalyzedResourceSummary>)}.
         * 
         * @param analyzedResources
         *        a consumer that will call methods on {@link List<AnalyzedResourceSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #analyzedResources(List<AnalyzedResourceSummary>)
         */
        Builder analyzedResources(Consumer<AnalyzedResourceSummary.Builder>... analyzedResources);

        /**
         * <p>
         * A token used for pagination of results returned.
         * </p>
         * 
         * @param nextToken
         *        A token used for pagination of results returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AccessAnalyzerResponse.BuilderImpl implements Builder {
        private List<AnalyzedResourceSummary> analyzedResources = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAnalyzedResourcesResponse model) {
            super(model);
            analyzedResources(model.analyzedResources);
            nextToken(model.nextToken);
        }

        public final Collection<AnalyzedResourceSummary.Builder> getAnalyzedResources() {
            return analyzedResources != null ? analyzedResources.stream().map(AnalyzedResourceSummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder analyzedResources(Collection<AnalyzedResourceSummary> analyzedResources) {
            this.analyzedResources = AnalyzedResourcesListCopier.copy(analyzedResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analyzedResources(AnalyzedResourceSummary... analyzedResources) {
            analyzedResources(Arrays.asList(analyzedResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analyzedResources(Consumer<AnalyzedResourceSummary.Builder>... analyzedResources) {
            analyzedResources(Stream.of(analyzedResources).map(c -> AnalyzedResourceSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAnalyzedResources(Collection<AnalyzedResourceSummary.BuilderImpl> analyzedResources) {
            this.analyzedResources = AnalyzedResourcesListCopier.copyFromBuilder(analyzedResources);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListAnalyzedResourcesResponse build() {
            return new ListAnalyzedResourcesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
