/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The criteria to use in the filter that defines the archive rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Criterion implements SdkPojo, Serializable, ToCopyableBuilder<Criterion.Builder, Criterion> {
    private static final SdkField<List<String>> CONTAINS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(Criterion::contains))
            .setter(setter(Builder::contains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contains").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> EQ_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(Criterion::eq))
            .setter(setter(Builder::eq))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eq").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> EXISTS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(Criterion::exists)).setter(setter(Builder::exists))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exists").build()).build();

    private static final SdkField<List<String>> NEQ_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(Criterion::neq))
            .setter(setter(Builder::neq))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("neq").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINS_FIELD, EQ_FIELD,
            EXISTS_FIELD, NEQ_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> contains;

    private final List<String> eq;

    private final Boolean exists;

    private final List<String> neq;

    private Criterion(BuilderImpl builder) {
        this.contains = builder.contains;
        this.eq = builder.eq;
        this.exists = builder.exists;
        this.neq = builder.neq;
    }

    /**
     * Returns true if the Contains property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasContains() {
        return contains != null && !(contains instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A "contains" operator to match for the filter used to create the rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasContains()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A "contains" operator to match for the filter used to create the rule.
     */
    public List<String> contains() {
        return contains;
    }

    /**
     * Returns true if the Eq property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasEq() {
        return eq != null && !(eq instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An "equals" operator to match for the filter used to create the rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEq()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An "equals" operator to match for the filter used to create the rule.
     */
    public List<String> eq() {
        return eq;
    }

    /**
     * <p>
     * An "exists" operator to match for the filter used to create the rule.
     * </p>
     * 
     * @return An "exists" operator to match for the filter used to create the rule.
     */
    public Boolean exists() {
        return exists;
    }

    /**
     * Returns true if the Neq property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasNeq() {
        return neq != null && !(neq instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A "not equals" operator to match for the filter used to create the rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasNeq()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A "not equals" operator to match for the filter used to create the rule.
     */
    public List<String> neq() {
        return neq;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(contains());
        hashCode = 31 * hashCode + Objects.hashCode(eq());
        hashCode = 31 * hashCode + Objects.hashCode(exists());
        hashCode = 31 * hashCode + Objects.hashCode(neq());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Criterion)) {
            return false;
        }
        Criterion other = (Criterion) obj;
        return Objects.equals(contains(), other.contains()) && Objects.equals(eq(), other.eq())
                && Objects.equals(exists(), other.exists()) && Objects.equals(neq(), other.neq());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Criterion").add("Contains", contains()).add("Eq", eq()).add("Exists", exists())
                .add("Neq", neq()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "contains":
            return Optional.ofNullable(clazz.cast(contains()));
        case "eq":
            return Optional.ofNullable(clazz.cast(eq()));
        case "exists":
            return Optional.ofNullable(clazz.cast(exists()));
        case "neq":
            return Optional.ofNullable(clazz.cast(neq()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Criterion, T> g) {
        return obj -> g.apply((Criterion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Criterion> {
        /**
         * <p>
         * A "contains" operator to match for the filter used to create the rule.
         * </p>
         * 
         * @param contains
         *        A "contains" operator to match for the filter used to create the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contains(Collection<String> contains);

        /**
         * <p>
         * A "contains" operator to match for the filter used to create the rule.
         * </p>
         * 
         * @param contains
         *        A "contains" operator to match for the filter used to create the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contains(String... contains);

        /**
         * <p>
         * An "equals" operator to match for the filter used to create the rule.
         * </p>
         * 
         * @param eq
         *        An "equals" operator to match for the filter used to create the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eq(Collection<String> eq);

        /**
         * <p>
         * An "equals" operator to match for the filter used to create the rule.
         * </p>
         * 
         * @param eq
         *        An "equals" operator to match for the filter used to create the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eq(String... eq);

        /**
         * <p>
         * An "exists" operator to match for the filter used to create the rule.
         * </p>
         * 
         * @param exists
         *        An "exists" operator to match for the filter used to create the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exists(Boolean exists);

        /**
         * <p>
         * A "not equals" operator to match for the filter used to create the rule.
         * </p>
         * 
         * @param neq
         *        A "not equals" operator to match for the filter used to create the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder neq(Collection<String> neq);

        /**
         * <p>
         * A "not equals" operator to match for the filter used to create the rule.
         * </p>
         * 
         * @param neq
         *        A "not equals" operator to match for the filter used to create the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder neq(String... neq);
    }

    static final class BuilderImpl implements Builder {
        private List<String> contains = DefaultSdkAutoConstructList.getInstance();

        private List<String> eq = DefaultSdkAutoConstructList.getInstance();

        private Boolean exists;

        private List<String> neq = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Criterion model) {
            contains(model.contains);
            eq(model.eq);
            exists(model.exists);
            neq(model.neq);
        }

        public final Collection<String> getContains() {
            return contains;
        }

        @Override
        public final Builder contains(Collection<String> contains) {
            this.contains = ValueListCopier.copy(contains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contains(String... contains) {
            contains(Arrays.asList(contains));
            return this;
        }

        public final void setContains(Collection<String> contains) {
            this.contains = ValueListCopier.copy(contains);
        }

        public final Collection<String> getEq() {
            return eq;
        }

        @Override
        public final Builder eq(Collection<String> eq) {
            this.eq = ValueListCopier.copy(eq);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eq(String... eq) {
            eq(Arrays.asList(eq));
            return this;
        }

        public final void setEq(Collection<String> eq) {
            this.eq = ValueListCopier.copy(eq);
        }

        public final Boolean getExists() {
            return exists;
        }

        @Override
        public final Builder exists(Boolean exists) {
            this.exists = exists;
            return this;
        }

        public final void setExists(Boolean exists) {
            this.exists = exists;
        }

        public final Collection<String> getNeq() {
            return neq;
        }

        @Override
        public final Builder neq(Collection<String> neq) {
            this.neq = ValueListCopier.copy(neq);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder neq(String... neq) {
            neq(Arrays.asList(neq));
            return this;
        }

        public final void setNeq(Collection<String> neq) {
            this.neq = ValueListCopier.copy(neq);
        }

        @Override
        public Criterion build() {
            return new Criterion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
