/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Creates an analyzer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAnalyzerRequest extends AccessAnalyzerRequest implements
        ToCopyableBuilder<CreateAnalyzerRequest.Builder, CreateAnalyzerRequest> {
    private static final SdkField<String> ANALYZER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateAnalyzerRequest::analyzerName)).setter(setter(Builder::analyzerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analyzerName").build()).build();

    private static final SdkField<List<InlineArchiveRule>> ARCHIVE_RULES_FIELD = SdkField
            .<List<InlineArchiveRule>> builder(MarshallingType.LIST)
            .getter(getter(CreateAnalyzerRequest::archiveRules))
            .setter(setter(Builder::archiveRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("archiveRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InlineArchiveRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(InlineArchiveRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateAnalyzerRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(CreateAnalyzerRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateAnalyzerRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYZER_NAME_FIELD,
            ARCHIVE_RULES_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD, TYPE_FIELD));

    private final String analyzerName;

    private final List<InlineArchiveRule> archiveRules;

    private final String clientToken;

    private final Map<String, String> tags;

    private final String type;

    private CreateAnalyzerRequest(BuilderImpl builder) {
        super(builder);
        this.analyzerName = builder.analyzerName;
        this.archiveRules = builder.archiveRules;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
        this.type = builder.type;
    }

    /**
     * <p>
     * The name of the analyzer to create.
     * </p>
     * 
     * @return The name of the analyzer to create.
     */
    public String analyzerName() {
        return analyzerName;
    }

    /**
     * Returns true if the ArchiveRules property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasArchiveRules() {
        return archiveRules != null && !(archiveRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the archive rules to add for the analyzer. Archive rules automatically archive findings that meet the
     * criteria you define for the rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasArchiveRules()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specifies the archive rules to add for the analyzer. Archive rules automatically archive findings that
     *         meet the criteria you define for the rule.
     */
    public List<InlineArchiveRule> archiveRules() {
        return archiveRules;
    }

    /**
     * <p>
     * A client token.
     * </p>
     * 
     * @return A client token.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags to apply to the analyzer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags to apply to the analyzer.
     */
    public Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The type of analyzer to create. Only ACCOUNT analyzers are supported. You can create only one analyzer per
     * account per Region.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link Type#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of analyzer to create. Only ACCOUNT analyzers are supported. You can create only one analyzer
     *         per account per Region.
     * @see Type
     */
    public Type type() {
        return Type.fromValue(type);
    }

    /**
     * <p>
     * The type of analyzer to create. Only ACCOUNT analyzers are supported. You can create only one analyzer per
     * account per Region.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link Type#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of analyzer to create. Only ACCOUNT analyzers are supported. You can create only one analyzer
     *         per account per Region.
     * @see Type
     */
    public String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(analyzerName());
        hashCode = 31 * hashCode + Objects.hashCode(archiveRules());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAnalyzerRequest)) {
            return false;
        }
        CreateAnalyzerRequest other = (CreateAnalyzerRequest) obj;
        return Objects.equals(analyzerName(), other.analyzerName()) && Objects.equals(archiveRules(), other.archiveRules())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(tags(), other.tags())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateAnalyzerRequest").add("AnalyzerName", analyzerName()).add("ArchiveRules", archiveRules())
                .add("ClientToken", clientToken()).add("Tags", tags()).add("Type", typeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "analyzerName":
            return Optional.ofNullable(clazz.cast(analyzerName()));
        case "archiveRules":
            return Optional.ofNullable(clazz.cast(archiveRules()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAnalyzerRequest, T> g) {
        return obj -> g.apply((CreateAnalyzerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AccessAnalyzerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateAnalyzerRequest> {
        /**
         * <p>
         * The name of the analyzer to create.
         * </p>
         * 
         * @param analyzerName
         *        The name of the analyzer to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analyzerName(String analyzerName);

        /**
         * <p>
         * Specifies the archive rules to add for the analyzer. Archive rules automatically archive findings that meet
         * the criteria you define for the rule.
         * </p>
         * 
         * @param archiveRules
         *        Specifies the archive rules to add for the analyzer. Archive rules automatically archive findings that
         *        meet the criteria you define for the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder archiveRules(Collection<InlineArchiveRule> archiveRules);

        /**
         * <p>
         * Specifies the archive rules to add for the analyzer. Archive rules automatically archive findings that meet
         * the criteria you define for the rule.
         * </p>
         * 
         * @param archiveRules
         *        Specifies the archive rules to add for the analyzer. Archive rules automatically archive findings that
         *        meet the criteria you define for the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder archiveRules(InlineArchiveRule... archiveRules);

        /**
         * <p>
         * Specifies the archive rules to add for the analyzer. Archive rules automatically archive findings that meet
         * the criteria you define for the rule.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InlineArchiveRule>.Builder} avoiding the
         * need to create one manually via {@link List<InlineArchiveRule>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InlineArchiveRule>.Builder#build()} is called immediately
         * and its result is passed to {@link #archiveRules(List<InlineArchiveRule>)}.
         * 
         * @param archiveRules
         *        a consumer that will call methods on {@link List<InlineArchiveRule>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #archiveRules(List<InlineArchiveRule>)
         */
        Builder archiveRules(Consumer<InlineArchiveRule.Builder>... archiveRules);

        /**
         * <p>
         * A client token.
         * </p>
         * 
         * @param clientToken
         *        A client token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The tags to apply to the analyzer.
         * </p>
         * 
         * @param tags
         *        The tags to apply to the analyzer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The type of analyzer to create. Only ACCOUNT analyzers are supported. You can create only one analyzer per
         * account per Region.
         * </p>
         * 
         * @param type
         *        The type of analyzer to create. Only ACCOUNT analyzers are supported. You can create only one analyzer
         *        per account per Region.
         * @see Type
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Type
         */
        Builder type(String type);

        /**
         * <p>
         * The type of analyzer to create. Only ACCOUNT analyzers are supported. You can create only one analyzer per
         * account per Region.
         * </p>
         * 
         * @param type
         *        The type of analyzer to create. Only ACCOUNT analyzers are supported. You can create only one analyzer
         *        per account per Region.
         * @see Type
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Type
         */
        Builder type(Type type);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AccessAnalyzerRequest.BuilderImpl implements Builder {
        private String analyzerName;

        private List<InlineArchiveRule> archiveRules = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAnalyzerRequest model) {
            super(model);
            analyzerName(model.analyzerName);
            archiveRules(model.archiveRules);
            clientToken(model.clientToken);
            tags(model.tags);
            type(model.type);
        }

        public final String getAnalyzerName() {
            return analyzerName;
        }

        @Override
        public final Builder analyzerName(String analyzerName) {
            this.analyzerName = analyzerName;
            return this;
        }

        public final void setAnalyzerName(String analyzerName) {
            this.analyzerName = analyzerName;
        }

        public final Collection<InlineArchiveRule.Builder> getArchiveRules() {
            return archiveRules != null ? archiveRules.stream().map(InlineArchiveRule::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder archiveRules(Collection<InlineArchiveRule> archiveRules) {
            this.archiveRules = InlineArchiveRulesListCopier.copy(archiveRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder archiveRules(InlineArchiveRule... archiveRules) {
            archiveRules(Arrays.asList(archiveRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder archiveRules(Consumer<InlineArchiveRule.Builder>... archiveRules) {
            archiveRules(Stream.of(archiveRules).map(c -> InlineArchiveRule.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setArchiveRules(Collection<InlineArchiveRule.BuilderImpl> archiveRules) {
            this.archiveRules = InlineArchiveRulesListCopier.copyFromBuilder(archiveRules);
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        public final String getTypeAsString() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(Type type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAnalyzerRequest build() {
            return new CreateAnalyzerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
