/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.accessanalyzer.model.AccessAnalyzerRequest;
import software.amazon.awssdk.services.accessanalyzer.model.Criterion;
import software.amazon.awssdk.services.accessanalyzer.model.FilterCriteriaMapCopier;
import software.amazon.awssdk.services.accessanalyzer.model.SortCriteria;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFindingsRequest
extends AccessAnalyzerRequest
implements ToCopyableBuilder<Builder, ListFindingsRequest> {
    private static final SdkField<String> ANALYZER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListFindingsRequest.getter(ListFindingsRequest::analyzerArn)).setter(ListFindingsRequest.setter(Builder::analyzerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analyzerArn").build()}).build();
    private static final SdkField<Map<String, Criterion>> FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(ListFindingsRequest.getter(ListFindingsRequest::filter)).setter(ListFindingsRequest.setter(Builder::filter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Criterion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ListFindingsRequest.getter(ListFindingsRequest::maxResults)).setter(ListFindingsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListFindingsRequest.getter(ListFindingsRequest::nextToken)).setter(ListFindingsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<SortCriteria> SORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ListFindingsRequest.getter(ListFindingsRequest::sort)).setter(ListFindingsRequest.setter(Builder::sort)).constructor(SortCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sort").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYZER_ARN_FIELD, FILTER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SORT_FIELD));
    private final String analyzerArn;
    private final Map<String, Criterion> filter;
    private final Integer maxResults;
    private final String nextToken;
    private final SortCriteria sort;

    private ListFindingsRequest(BuilderImpl builder) {
        super(builder);
        this.analyzerArn = builder.analyzerArn;
        this.filter = builder.filter;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.sort = builder.sort;
    }

    public String analyzerArn() {
        return this.analyzerArn;
    }

    public Map<String, Criterion> filter() {
        return this.filter;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public SortCriteria sort() {
        return this.sort;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.analyzerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.filter());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.sort());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFindingsRequest)) {
            return false;
        }
        ListFindingsRequest other = (ListFindingsRequest)((Object)obj);
        return Objects.equals(this.analyzerArn(), other.analyzerArn()) && Objects.equals(this.filter(), other.filter()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.sort(), other.sort());
    }

    public String toString() {
        return ToString.builder((String)"ListFindingsRequest").add("AnalyzerArn", (Object)this.analyzerArn()).add("Filter", this.filter()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("Sort", (Object)this.sort()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "analyzerArn": {
                return Optional.ofNullable(clazz.cast(this.analyzerArn()));
            }
            case "filter": {
                return Optional.ofNullable(clazz.cast(this.filter()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "sort": {
                return Optional.ofNullable(clazz.cast(this.sort()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFindingsRequest, T> g) {
        return obj -> g.apply((ListFindingsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AccessAnalyzerRequest.BuilderImpl
    implements Builder {
        private String analyzerArn;
        private Map<String, Criterion> filter = DefaultSdkAutoConstructMap.getInstance();
        private Integer maxResults;
        private String nextToken;
        private SortCriteria sort;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFindingsRequest model) {
            super(model);
            this.analyzerArn(model.analyzerArn);
            this.filter(model.filter);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.sort(model.sort);
        }

        public final String getAnalyzerArn() {
            return this.analyzerArn;
        }

        @Override
        public final Builder analyzerArn(String analyzerArn) {
            this.analyzerArn = analyzerArn;
            return this;
        }

        public final void setAnalyzerArn(String analyzerArn) {
            this.analyzerArn = analyzerArn;
        }

        public final Map<String, Criterion.Builder> getFilter() {
            return this.filter != null ? CollectionUtils.mapValues(this.filter, Criterion::toBuilder) : null;
        }

        @Override
        public final Builder filter(Map<String, Criterion> filter) {
            this.filter = FilterCriteriaMapCopier.copy(filter);
            return this;
        }

        public final void setFilter(Map<String, Criterion.BuilderImpl> filter) {
            this.filter = FilterCriteriaMapCopier.copyFromBuilder(filter);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final SortCriteria.Builder getSort() {
            return this.sort != null ? this.sort.toBuilder() : null;
        }

        @Override
        public final Builder sort(SortCriteria sort) {
            this.sort = sort;
            return this;
        }

        public final void setSort(SortCriteria.BuilderImpl sort) {
            this.sort = sort != null ? sort.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListFindingsRequest build() {
            return new ListFindingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AccessAnalyzerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFindingsRequest> {
        public Builder analyzerArn(String var1);

        public Builder filter(Map<String, Criterion> var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder sort(SortCriteria var1);

        default public Builder sort(Consumer<SortCriteria.Builder> sort) {
            return this.sort((SortCriteria)((SortCriteria.Builder)SortCriteria.builder().applyMutation(sort)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

