/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awsconstructs.services.lambdastepfunctions;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.services.cloudwatch.Alarm;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.VpcProps;
import software.amazon.awscdk.services.lambda.Function;
import software.amazon.awscdk.services.lambda.FunctionProps;
import software.amazon.awscdk.services.logs.ILogGroup;
import software.amazon.awscdk.services.logs.LogGroupProps;
import software.amazon.awscdk.services.stepfunctions.StateMachine;
import software.amazon.awscdk.services.stepfunctions.StateMachineProps;
import software.amazon.awsconstructs.services.lambdastepfunctions.;
import software.amazon.awsconstructs.services.lambdastepfunctions.LambdaToStepfunctionsProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="@aws-solutions-constructs/aws-lambda-stepfunctions.LambdaToStepfunctions")
public class LambdaToStepfunctions
extends Construct {
    protected LambdaToStepfunctions(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LambdaToStepfunctions(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public LambdaToStepfunctions(@NotNull Construct scope, @NotNull String id, @NotNull LambdaToStepfunctionsProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public Function getLambdaFunction() {
        return (Function)Kernel.get((Object)((Object)this), (String)"lambdaFunction", (NativeType)NativeType.forClass(Function.class));
    }

    @NotNull
    public StateMachine getStateMachine() {
        return (StateMachine)Kernel.get((Object)((Object)this), (String)"stateMachine", (NativeType)NativeType.forClass(StateMachine.class));
    }

    @NotNull
    public ILogGroup getStateMachineLogGroup() {
        return (ILogGroup)Kernel.get((Object)((Object)this), (String)"stateMachineLogGroup", (NativeType)NativeType.forClass(ILogGroup.class));
    }

    @Nullable
    public List<Alarm> getCloudwatchAlarms() {
        return Optional.ofNullable((List)Kernel.get((Object)((Object)this), (String)"cloudwatchAlarms", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Alarm.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    @Nullable
    public IVpc getVpc() {
        return (IVpc)Kernel.get((Object)((Object)this), (String)"vpc", (NativeType)NativeType.forClass(IVpc.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<LambdaToStepfunctions> {
        private final Construct scope;
        private final String id;
        private final LambdaToStepfunctionsProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new LambdaToStepfunctionsProps.Builder();
        }

        public Builder stateMachineProps(StateMachineProps stateMachineProps) {
            this.props.stateMachineProps(stateMachineProps);
            return this;
        }

        public Builder createCloudWatchAlarms(Boolean createCloudWatchAlarms) {
            this.props.createCloudWatchAlarms(createCloudWatchAlarms);
            return this;
        }

        public Builder deployVpc(Boolean deployVpc) {
            this.props.deployVpc(deployVpc);
            return this;
        }

        public Builder existingLambdaObj(Function existingLambdaObj) {
            this.props.existingLambdaObj(existingLambdaObj);
            return this;
        }

        public Builder existingVpc(IVpc existingVpc) {
            this.props.existingVpc(existingVpc);
            return this;
        }

        public Builder lambdaFunctionProps(FunctionProps lambdaFunctionProps) {
            this.props.lambdaFunctionProps(lambdaFunctionProps);
            return this;
        }

        public Builder logGroupProps(LogGroupProps logGroupProps) {
            this.props.logGroupProps(logGroupProps);
            return this;
        }

        public Builder stateMachineEnvironmentVariableName(String stateMachineEnvironmentVariableName) {
            this.props.stateMachineEnvironmentVariableName(stateMachineEnvironmentVariableName);
            return this;
        }

        public Builder vpcProps(VpcProps vpcProps) {
            this.props.vpcProps(vpcProps);
            return this;
        }

        public LambdaToStepfunctions build() {
            return new LambdaToStepfunctions(this.scope, this.id, this.props.build());
        }
    }
}

