/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awsconstructs.services.lambdasqs;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.VpcProps;
import software.amazon.awscdk.services.kms.Key;
import software.amazon.awscdk.services.kms.KeyProps;
import software.amazon.awscdk.services.lambda.Function;
import software.amazon.awscdk.services.lambda.FunctionProps;
import software.amazon.awscdk.services.sqs.DeadLetterQueue;
import software.amazon.awscdk.services.sqs.Queue;
import software.amazon.awscdk.services.sqs.QueueProps;
import software.amazon.awsconstructs.services.lambdasqs.;
import software.amazon.awsconstructs.services.lambdasqs.LambdaToSqsProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="@aws-solutions-constructs/aws-lambda-sqs.LambdaToSqs")
public class LambdaToSqs
extends Construct {
    protected LambdaToSqs(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LambdaToSqs(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public LambdaToSqs(@NotNull Construct scope, @NotNull String id, @NotNull LambdaToSqsProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public Function getLambdaFunction() {
        return (Function)Kernel.get((Object)((Object)this), (String)"lambdaFunction", (NativeType)NativeType.forClass(Function.class));
    }

    @NotNull
    public Queue getSqsQueue() {
        return (Queue)Kernel.get((Object)((Object)this), (String)"sqsQueue", (NativeType)NativeType.forClass(Queue.class));
    }

    @Nullable
    public DeadLetterQueue getDeadLetterQueue() {
        return (DeadLetterQueue)Kernel.get((Object)((Object)this), (String)"deadLetterQueue", (NativeType)NativeType.forClass(DeadLetterQueue.class));
    }

    @Nullable
    public IVpc getVpc() {
        return (IVpc)Kernel.get((Object)((Object)this), (String)"vpc", (NativeType)NativeType.forClass(IVpc.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<LambdaToSqs> {
        private final Construct scope;
        private final String id;
        private final LambdaToSqsProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new LambdaToSqsProps.Builder();
        }

        public Builder deadLetterQueueProps(QueueProps deadLetterQueueProps) {
            this.props.deadLetterQueueProps(deadLetterQueueProps);
            return this;
        }

        public Builder deployDeadLetterQueue(Boolean deployDeadLetterQueue) {
            this.props.deployDeadLetterQueue(deployDeadLetterQueue);
            return this;
        }

        public Builder deployVpc(Boolean deployVpc) {
            this.props.deployVpc(deployVpc);
            return this;
        }

        public Builder enableEncryptionWithCustomerManagedKey(Boolean enableEncryptionWithCustomerManagedKey) {
            this.props.enableEncryptionWithCustomerManagedKey(enableEncryptionWithCustomerManagedKey);
            return this;
        }

        public Builder enableQueuePurging(Boolean enableQueuePurging) {
            this.props.enableQueuePurging(enableQueuePurging);
            return this;
        }

        public Builder encryptionKey(Key encryptionKey) {
            this.props.encryptionKey(encryptionKey);
            return this;
        }

        public Builder encryptionKeyProps(KeyProps encryptionKeyProps) {
            this.props.encryptionKeyProps(encryptionKeyProps);
            return this;
        }

        public Builder existingLambdaObj(Function existingLambdaObj) {
            this.props.existingLambdaObj(existingLambdaObj);
            return this;
        }

        public Builder existingQueueObj(Queue existingQueueObj) {
            this.props.existingQueueObj(existingQueueObj);
            return this;
        }

        public Builder existingVpc(IVpc existingVpc) {
            this.props.existingVpc(existingVpc);
            return this;
        }

        public Builder lambdaFunctionProps(FunctionProps lambdaFunctionProps) {
            this.props.lambdaFunctionProps(lambdaFunctionProps);
            return this;
        }

        public Builder maxReceiveCount(Number maxReceiveCount) {
            this.props.maxReceiveCount(maxReceiveCount);
            return this;
        }

        public Builder queueEnvironmentVariableName(String queueEnvironmentVariableName) {
            this.props.queueEnvironmentVariableName(queueEnvironmentVariableName);
            return this;
        }

        public Builder queueProps(QueueProps queueProps) {
            this.props.queueProps(queueProps);
            return this;
        }

        public Builder vpcProps(VpcProps vpcProps) {
            this.props.vpcProps(vpcProps);
            return this;
        }

        public LambdaToSqs build() {
            return new LambdaToSqs(this.scope, this.id, this.props.build());
        }
    }
}

