/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.workspaces;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.workspaces.$Module;
import software.amazon.awscdk.services.workspaces.CfnWorkspace;
import software.amazon.awscdk.services.workspaces.CfnWorkspaceProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-workspaces.CfnWorkspace")
public class CfnWorkspace
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnWorkspace.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnWorkspace(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnWorkspace(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnWorkspace(@NotNull Construct scope, @NotNull String id, @NotNull CfnWorkspaceProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void inspect(@NotNull TreeInspector inspector) {
        this.jsiiCall("inspect", NativeType.VOID, new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)this.jsiiCall("renderProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("cfnProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)this.jsiiGet("tags", TagManager.class);
    }

    @NotNull
    public String getBundleId() {
        return (String)this.jsiiGet("bundleId", String.class);
    }

    public void setBundleId(@NotNull String value) {
        this.jsiiSet("bundleId", Objects.requireNonNull(value, "bundleId is required"));
    }

    @NotNull
    public String getDirectoryId() {
        return (String)this.jsiiGet("directoryId", String.class);
    }

    public void setDirectoryId(@NotNull String value) {
        this.jsiiSet("directoryId", Objects.requireNonNull(value, "directoryId is required"));
    }

    @NotNull
    public String getUserName() {
        return (String)this.jsiiGet("userName", String.class);
    }

    public void setUserName(@NotNull String value) {
        this.jsiiSet("userName", Objects.requireNonNull(value, "userName is required"));
    }

    @Nullable
    public Object getRootVolumeEncryptionEnabled() {
        return this.jsiiGet("rootVolumeEncryptionEnabled", Object.class);
    }

    public void setRootVolumeEncryptionEnabled(@Nullable Boolean value) {
        this.jsiiSet("rootVolumeEncryptionEnabled", value);
    }

    public void setRootVolumeEncryptionEnabled(@Nullable IResolvable value) {
        this.jsiiSet("rootVolumeEncryptionEnabled", value);
    }

    @Nullable
    public Object getUserVolumeEncryptionEnabled() {
        return this.jsiiGet("userVolumeEncryptionEnabled", Object.class);
    }

    public void setUserVolumeEncryptionEnabled(@Nullable Boolean value) {
        this.jsiiSet("userVolumeEncryptionEnabled", value);
    }

    public void setUserVolumeEncryptionEnabled(@Nullable IResolvable value) {
        this.jsiiSet("userVolumeEncryptionEnabled", value);
    }

    @Nullable
    public String getVolumeEncryptionKey() {
        return (String)this.jsiiGet("volumeEncryptionKey", String.class);
    }

    public void setVolumeEncryptionKey(@Nullable String value) {
        this.jsiiSet("volumeEncryptionKey", value);
    }

    @Nullable
    public Object getWorkspaceProperties() {
        return this.jsiiGet("workspaceProperties", Object.class);
    }

    public void setWorkspaceProperties(@Nullable IResolvable value) {
        this.jsiiSet("workspaceProperties", value);
    }

    public void setWorkspaceProperties(@Nullable WorkspacePropertiesProperty value) {
        this.jsiiSet("workspaceProperties", value);
    }

    public static final class Builder {
        private final Construct scope;
        private final String id;
        private final CfnWorkspaceProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnWorkspaceProps.Builder();
        }

        public Builder bundleId(String bundleId) {
            this.props.bundleId(bundleId);
            return this;
        }

        public Builder directoryId(String directoryId) {
            this.props.directoryId(directoryId);
            return this;
        }

        public Builder userName(String userName) {
            this.props.userName(userName);
            return this;
        }

        public Builder rootVolumeEncryptionEnabled(Boolean rootVolumeEncryptionEnabled) {
            this.props.rootVolumeEncryptionEnabled(rootVolumeEncryptionEnabled);
            return this;
        }

        public Builder rootVolumeEncryptionEnabled(IResolvable rootVolumeEncryptionEnabled) {
            this.props.rootVolumeEncryptionEnabled(rootVolumeEncryptionEnabled);
            return this;
        }

        public Builder tags(List<CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder userVolumeEncryptionEnabled(Boolean userVolumeEncryptionEnabled) {
            this.props.userVolumeEncryptionEnabled(userVolumeEncryptionEnabled);
            return this;
        }

        public Builder userVolumeEncryptionEnabled(IResolvable userVolumeEncryptionEnabled) {
            this.props.userVolumeEncryptionEnabled(userVolumeEncryptionEnabled);
            return this;
        }

        public Builder volumeEncryptionKey(String volumeEncryptionKey) {
            this.props.volumeEncryptionKey(volumeEncryptionKey);
            return this;
        }

        public Builder workspaceProperties(IResolvable workspaceProperties) {
            this.props.workspaceProperties(workspaceProperties);
            return this;
        }

        public Builder workspaceProperties(WorkspacePropertiesProperty workspaceProperties) {
            this.props.workspaceProperties(workspaceProperties);
            return this;
        }

        public CfnWorkspace build() {
            return new CfnWorkspace(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-workspaces.CfnWorkspace.WorkspacePropertiesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface WorkspacePropertiesProperty
    extends JsiiSerializable {
        @Nullable
        default public String getComputeTypeName() {
            return null;
        }

        @Nullable
        default public Number getRootVolumeSizeGib() {
            return null;
        }

        @Nullable
        default public String getRunningMode() {
            return null;
        }

        @Nullable
        default public Number getRunningModeAutoStopTimeoutInMinutes() {
            return null;
        }

        @Nullable
        default public Number getUserVolumeSizeGib() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String computeTypeName;
            private Number rootVolumeSizeGib;
            private String runningMode;
            private Number runningModeAutoStopTimeoutInMinutes;
            private Number userVolumeSizeGib;

            public Builder computeTypeName(String computeTypeName) {
                this.computeTypeName = computeTypeName;
                return this;
            }

            public Builder rootVolumeSizeGib(Number rootVolumeSizeGib) {
                this.rootVolumeSizeGib = rootVolumeSizeGib;
                return this;
            }

            public Builder runningMode(String runningMode) {
                this.runningMode = runningMode;
                return this;
            }

            public Builder runningModeAutoStopTimeoutInMinutes(Number runningModeAutoStopTimeoutInMinutes) {
                this.runningModeAutoStopTimeoutInMinutes = runningModeAutoStopTimeoutInMinutes;
                return this;
            }

            public Builder userVolumeSizeGib(Number userVolumeSizeGib) {
                this.userVolumeSizeGib = userVolumeSizeGib;
                return this;
            }

            public WorkspacePropertiesProperty build() {
                return new Jsii.Proxy(this.computeTypeName, this.rootVolumeSizeGib, this.runningMode, this.runningModeAutoStopTimeoutInMinutes, this.userVolumeSizeGib, null);
            }
        }
    }
}

