/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.workspaces;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.services.workspaces.CfnWorkspace;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface CfnWorkspaceProps
extends JsiiSerializable {
    public String getBundleId();

    public String getDirectoryId();

    public String getUserName();

    public Object getRootVolumeEncryptionEnabled();

    public List<CfnTag> getTags();

    public Object getUserVolumeEncryptionEnabled();

    public String getVolumeEncryptionKey();

    public Object getWorkspaceProperties();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _bundleId;
        private String _directoryId;
        private String _userName;
        @Nullable
        private Object _rootVolumeEncryptionEnabled;
        @Nullable
        private List<CfnTag> _tags;
        @Nullable
        private Object _userVolumeEncryptionEnabled;
        @Nullable
        private String _volumeEncryptionKey;
        @Nullable
        private Object _workspaceProperties;

        public Builder withBundleId(String value) {
            this._bundleId = Objects.requireNonNull(value, "bundleId is required");
            return this;
        }

        public Builder withDirectoryId(String value) {
            this._directoryId = Objects.requireNonNull(value, "directoryId is required");
            return this;
        }

        public Builder withUserName(String value) {
            this._userName = Objects.requireNonNull(value, "userName is required");
            return this;
        }

        public Builder withRootVolumeEncryptionEnabled(@Nullable Boolean value) {
            this._rootVolumeEncryptionEnabled = value;
            return this;
        }

        public Builder withRootVolumeEncryptionEnabled(@Nullable IResolvable value) {
            this._rootVolumeEncryptionEnabled = value;
            return this;
        }

        public Builder withTags(@Nullable List<CfnTag> value) {
            this._tags = value;
            return this;
        }

        public Builder withUserVolumeEncryptionEnabled(@Nullable Boolean value) {
            this._userVolumeEncryptionEnabled = value;
            return this;
        }

        public Builder withUserVolumeEncryptionEnabled(@Nullable IResolvable value) {
            this._userVolumeEncryptionEnabled = value;
            return this;
        }

        public Builder withVolumeEncryptionKey(@Nullable String value) {
            this._volumeEncryptionKey = value;
            return this;
        }

        public Builder withWorkspaceProperties(@Nullable IResolvable value) {
            this._workspaceProperties = value;
            return this;
        }

        public Builder withWorkspaceProperties(@Nullable CfnWorkspace.WorkspacePropertiesProperty value) {
            this._workspaceProperties = value;
            return this;
        }

        public CfnWorkspaceProps build() {
            return new CfnWorkspaceProps(){
                private final String $bundleId;
                private final String $directoryId;
                private final String $userName;
                @Nullable
                private final Object $rootVolumeEncryptionEnabled;
                @Nullable
                private final List<CfnTag> $tags;
                @Nullable
                private final Object $userVolumeEncryptionEnabled;
                @Nullable
                private final String $volumeEncryptionKey;
                @Nullable
                private final Object $workspaceProperties;
                {
                    this.$bundleId = Objects.requireNonNull(_bundleId, "bundleId is required");
                    this.$directoryId = Objects.requireNonNull(_directoryId, "directoryId is required");
                    this.$userName = Objects.requireNonNull(_userName, "userName is required");
                    this.$rootVolumeEncryptionEnabled = _rootVolumeEncryptionEnabled;
                    this.$tags = _tags;
                    this.$userVolumeEncryptionEnabled = _userVolumeEncryptionEnabled;
                    this.$volumeEncryptionKey = _volumeEncryptionKey;
                    this.$workspaceProperties = _workspaceProperties;
                }

                @Override
                public String getBundleId() {
                    return this.$bundleId;
                }

                @Override
                public String getDirectoryId() {
                    return this.$directoryId;
                }

                @Override
                public String getUserName() {
                    return this.$userName;
                }

                @Override
                public Object getRootVolumeEncryptionEnabled() {
                    return this.$rootVolumeEncryptionEnabled;
                }

                @Override
                public List<CfnTag> getTags() {
                    return this.$tags;
                }

                @Override
                public Object getUserVolumeEncryptionEnabled() {
                    return this.$userVolumeEncryptionEnabled;
                }

                @Override
                public String getVolumeEncryptionKey() {
                    return this.$volumeEncryptionKey;
                }

                @Override
                public Object getWorkspaceProperties() {
                    return this.$workspaceProperties;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("bundleId", om.valueToTree((Object)this.getBundleId()));
                    obj.set("directoryId", om.valueToTree((Object)this.getDirectoryId()));
                    obj.set("userName", om.valueToTree((Object)this.getUserName()));
                    if (this.getRootVolumeEncryptionEnabled() != null) {
                        obj.set("rootVolumeEncryptionEnabled", om.valueToTree(this.getRootVolumeEncryptionEnabled()));
                    }
                    if (this.getTags() != null) {
                        obj.set("tags", om.valueToTree(this.getTags()));
                    }
                    if (this.getUserVolumeEncryptionEnabled() != null) {
                        obj.set("userVolumeEncryptionEnabled", om.valueToTree(this.getUserVolumeEncryptionEnabled()));
                    }
                    if (this.getVolumeEncryptionKey() != null) {
                        obj.set("volumeEncryptionKey", om.valueToTree((Object)this.getVolumeEncryptionKey()));
                    }
                    if (this.getWorkspaceProperties() != null) {
                        obj.set("workspaceProperties", om.valueToTree(this.getWorkspaceProperties()));
                    }
                    return obj;
                }
            };
        }
    }
}

