/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.wafv2;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.FromCloudFormationOptions;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.wafv2.;
import software.amazon.awscdk.services.wafv2.CfnRuleGroup;
import software.amazon.awscdk.services.wafv2.CfnRuleGroupProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-wafv2.CfnRuleGroup")
public class CfnRuleGroup
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnRuleGroup.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnRuleGroup(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnRuleGroup(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnRuleGroup(@NotNull Construct scope, @NotNull String id, @NotNull CfnRuleGroupProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static CfnRuleGroup fromCloudFormation(@NotNull Construct scope, @NotNull String id, @NotNull Object resourceAttributes, @NotNull FromCloudFormationOptions options) {
        return (CfnRuleGroup)((Object)JsiiObject.jsiiStaticCall(CfnRuleGroup.class, (String)"fromCloudFormation", CfnRuleGroup.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), resourceAttributes, Objects.requireNonNull(options, "options is required")}));
    }

    public void inspect(@NotNull TreeInspector inspector) {
        this.jsiiCall("inspect", NativeType.VOID, new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)this.jsiiCall("renderProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)this.jsiiGet("attrArn", String.class);
    }

    @NotNull
    public String getAttrId() {
        return (String)this.jsiiGet("attrId", String.class);
    }

    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("cfnProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)this.jsiiGet("tags", TagManager.class);
    }

    @NotNull
    public Number getCapacity() {
        return (Number)this.jsiiGet("capacity", Number.class);
    }

    public void setCapacity(@NotNull Number value) {
        this.jsiiSet("capacity", Objects.requireNonNull(value, "capacity is required"));
    }

    @NotNull
    public String getScope() {
        return (String)this.jsiiGet("scope", String.class);
    }

    public void setScope(@NotNull String value) {
        this.jsiiSet("scope", Objects.requireNonNull(value, "scope is required"));
    }

    @NotNull
    public Object getVisibilityConfig() {
        return this.jsiiGet("visibilityConfig", Object.class);
    }

    public void setVisibilityConfig(@NotNull IResolvable value) {
        this.jsiiSet("visibilityConfig", Objects.requireNonNull(value, "visibilityConfig is required"));
    }

    public void setVisibilityConfig(@NotNull VisibilityConfigProperty value) {
        this.jsiiSet("visibilityConfig", Objects.requireNonNull(value, "visibilityConfig is required"));
    }

    @Nullable
    public String getDescription() {
        return (String)this.jsiiGet("description", String.class);
    }

    public void setDescription(@Nullable String value) {
        this.jsiiSet("description", value);
    }

    @Nullable
    public String getName() {
        return (String)this.jsiiGet("name", String.class);
    }

    public void setName(@Nullable String value) {
        this.jsiiSet("name", value);
    }

    @Nullable
    public Object getRules() {
        return this.jsiiGet("rules", Object.class);
    }

    public void setRules(@Nullable IResolvable value) {
        this.jsiiSet("rules", value);
    }

    public void setRules(@Nullable List<Object> value) {
        this.jsiiSet("rules", value);
    }

    public static final class Builder {
        private final Construct scope;
        private final String id;
        private final CfnRuleGroupProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnRuleGroupProps.Builder();
        }

        public Builder capacity(Number capacity) {
            this.props.capacity(capacity);
            return this;
        }

        public Builder scope(String scope) {
            this.props.scope(scope);
            return this;
        }

        public Builder visibilityConfig(IResolvable visibilityConfig) {
            this.props.visibilityConfig(visibilityConfig);
            return this;
        }

        public Builder visibilityConfig(VisibilityConfigProperty visibilityConfig) {
            this.props.visibilityConfig(visibilityConfig);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder rules(IResolvable rules) {
            this.props.rules(rules);
            return this;
        }

        public Builder rules(List<Object> rules) {
            this.props.rules(rules);
            return this;
        }

        public Builder tags(List<CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnRuleGroup build() {
            return new CfnRuleGroup(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-wafv2.CfnRuleGroup.XssMatchStatementProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface XssMatchStatementProperty
    extends JsiiSerializable {
        @NotNull
        public Object getFieldToMatch();

        @NotNull
        public Object getTextTransformations();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object fieldToMatch;
            private Object textTransformations;

            public Builder fieldToMatch(IResolvable fieldToMatch) {
                this.fieldToMatch = fieldToMatch;
                return this;
            }

            public Builder fieldToMatch(FieldToMatchProperty fieldToMatch) {
                this.fieldToMatch = fieldToMatch;
                return this;
            }

            public Builder textTransformations(IResolvable textTransformations) {
                this.textTransformations = textTransformations;
                return this;
            }

            public Builder textTransformations(List<Object> textTransformations) {
                this.textTransformations = textTransformations;
                return this;
            }

            public XssMatchStatementProperty build() {
                return new Jsii.Proxy(this.fieldToMatch, this.textTransformations, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-wafv2.CfnRuleGroup.VisibilityConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VisibilityConfigProperty
    extends JsiiSerializable {
        @NotNull
        public Object getCloudWatchMetricsEnabled();

        @NotNull
        public String getMetricName();

        @NotNull
        public Object getSampledRequestsEnabled();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object cloudWatchMetricsEnabled;
            private String metricName;
            private Object sampledRequestsEnabled;

            public Builder cloudWatchMetricsEnabled(Boolean cloudWatchMetricsEnabled) {
                this.cloudWatchMetricsEnabled = cloudWatchMetricsEnabled;
                return this;
            }

            public Builder cloudWatchMetricsEnabled(IResolvable cloudWatchMetricsEnabled) {
                this.cloudWatchMetricsEnabled = cloudWatchMetricsEnabled;
                return this;
            }

            public Builder metricName(String metricName) {
                this.metricName = metricName;
                return this;
            }

            public Builder sampledRequestsEnabled(Boolean sampledRequestsEnabled) {
                this.sampledRequestsEnabled = sampledRequestsEnabled;
                return this;
            }

            public Builder sampledRequestsEnabled(IResolvable sampledRequestsEnabled) {
                this.sampledRequestsEnabled = sampledRequestsEnabled;
                return this;
            }

            public VisibilityConfigProperty build() {
                return new Jsii.Proxy(this.cloudWatchMetricsEnabled, this.metricName, this.sampledRequestsEnabled, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-wafv2.CfnRuleGroup.TextTransformationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TextTransformationProperty
    extends JsiiSerializable {
        @NotNull
        public Number getPriority();

        @NotNull
        public String getType();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Number priority;
            private String type;

            public Builder priority(Number priority) {
                this.priority = priority;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public TextTransformationProperty build() {
                return new Jsii.Proxy(this.priority, this.type, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-wafv2.CfnRuleGroup.StatementTwoProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface StatementTwoProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAndStatement() {
            return null;
        }

        @Nullable
        default public Object getByteMatchStatement() {
            return null;
        }

        @Nullable
        default public Object getGeoMatchStatement() {
            return null;
        }

        @Nullable
        default public Object getIpSetReferenceStatement() {
            return null;
        }

        @Nullable
        default public Object getNotStatement() {
            return null;
        }

        @Nullable
        default public Object getOrStatement() {
            return null;
        }

        @Nullable
        default public Object getRateBasedStatement() {
            return null;
        }

        @Nullable
        default public Object getRegexPatternSetReferenceStatement() {
            return null;
        }

        @Nullable
        default public Object getSizeConstraintStatement() {
            return null;
        }

        @Nullable
        default public Object getSqliMatchStatement() {
            return null;
        }

        @Nullable
        default public Object getXssMatchStatement() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object andStatement;
            private Object byteMatchStatement;
            private Object geoMatchStatement;
            private Object ipSetReferenceStatement;
            private Object notStatement;
            private Object orStatement;
            private Object rateBasedStatement;
            private Object regexPatternSetReferenceStatement;
            private Object sizeConstraintStatement;
            private Object sqliMatchStatement;
            private Object xssMatchStatement;

            public Builder andStatement(IResolvable andStatement) {
                this.andStatement = andStatement;
                return this;
            }

            public Builder andStatement(AndStatementTwoProperty andStatement) {
                this.andStatement = andStatement;
                return this;
            }

            public Builder byteMatchStatement(IResolvable byteMatchStatement) {
                this.byteMatchStatement = byteMatchStatement;
                return this;
            }

            public Builder byteMatchStatement(ByteMatchStatementProperty byteMatchStatement) {
                this.byteMatchStatement = byteMatchStatement;
                return this;
            }

            public Builder geoMatchStatement(IResolvable geoMatchStatement) {
                this.geoMatchStatement = geoMatchStatement;
                return this;
            }

            public Builder geoMatchStatement(GeoMatchStatementProperty geoMatchStatement) {
                this.geoMatchStatement = geoMatchStatement;
                return this;
            }

            public Builder ipSetReferenceStatement(IResolvable ipSetReferenceStatement) {
                this.ipSetReferenceStatement = ipSetReferenceStatement;
                return this;
            }

            public Builder ipSetReferenceStatement(IPSetReferenceStatementProperty ipSetReferenceStatement) {
                this.ipSetReferenceStatement = ipSetReferenceStatement;
                return this;
            }

            public Builder notStatement(IResolvable notStatement) {
                this.notStatement = notStatement;
                return this;
            }

            public Builder notStatement(NotStatementTwoProperty notStatement) {
                this.notStatement = notStatement;
                return this;
            }

            public Builder orStatement(IResolvable orStatement) {
                this.orStatement = orStatement;
                return this;
            }

            public Builder orStatement(OrStatementTwoProperty orStatement) {
                this.orStatement = orStatement;
                return this;
            }

            public Builder rateBasedStatement(IResolvable rateBasedStatement) {
                this.rateBasedStatement = rateBasedStatement;
                return this;
            }

            public Builder rateBasedStatement(RateBasedStatementTwoProperty rateBasedStatement) {
                this.rateBasedStatement = rateBasedStatement;
                return this;
            }

            public Builder regexPatternSetReferenceStatement(IResolvable regexPatternSetReferenceStatement) {
                this.regexPatternSetReferenceStatement = regexPatternSetReferenceStatement;
                return this;
            }

            public Builder regexPatternSetReferenceStatement(RegexPatternSetReferenceStatementProperty regexPatternSetReferenceStatement) {
                this.regexPatternSetReferenceStatement = regexPatternSetReferenceStatement;
                return this;
            }

            public Builder sizeConstraintStatement(IResolvable sizeConstraintStatement) {
                this.sizeConstraintStatement = sizeConstraintStatement;
                return this;
            }

            public Builder sizeConstraintStatement(SizeConstraintStatementProperty sizeConstraintStatement) {
                this.sizeConstraintStatement = sizeConstraintStatement;
                return this;
            }

            public Builder sqliMatchStatement(IResolvable sqliMatchStatement) {
                this.sqliMatchStatement = sqliMatchStatement;
                return this;
            }

            public Builder sqliMatchStatement(SqliMatchStatementProperty sqliMatchStatement) {
                this.sqliMatchStatement = sqliMatchStatement;
                return this;
            }

            public Builder xssMatchStatement(IResolvable xssMatchStatement) {
                this.xssMatchStatement = xssMatchStatement;
                return this;
            }

            public Builder xssMatchStatement(XssMatchStatementProperty xssMatchStatement) {
                this.xssMatchStatement = xssMatchStatement;
                return this;
            }

            public StatementTwoProperty build() {
                return new Jsii.Proxy(this.andStatement, this.byteMatchStatement, this.geoMatchStatement, this.ipSetReferenceStatement, this.notStatement, this.orStatement, this.rateBasedStatement, this.regexPatternSetReferenceStatement, this.sizeConstraintStatement, this.sqliMatchStatement, this.xssMatchStatement, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-wafv2.CfnRuleGroup.StatementThreeProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface StatementThreeProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getByteMatchStatement() {
            return null;
        }

        @Nullable
        default public Object getGeoMatchStatement() {
            return null;
        }

        @Nullable
        default public Object getIpSetReferenceStatement() {
            return null;
        }

        @Nullable
        default public Object getRegexPatternSetReferenceStatement() {
            return null;
        }

        @Nullable
        default public Object getSizeConstraintStatement() {
            return null;
        }

        @Nullable
        default public Object getSqliMatchStatement() {
            return null;
        }

        @Nullable
        default public Object getXssMatchStatement() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object byteMatchStatement;
            private Object geoMatchStatement;
            private Object ipSetReferenceStatement;
            private Object regexPatternSetReferenceStatement;
            private Object sizeConstraintStatement;
            private Object sqliMatchStatement;
            private Object xssMatchStatement;

            public Builder byteMatchStatement(IResolvable byteMatchStatement) {
                this.byteMatchStatement = byteMatchStatement;
                return this;
            }

            public Builder byteMatchStatement(ByteMatchStatementProperty byteMatchStatement) {
                this.byteMatchStatement = byteMatchStatement;
                return this;
            }

            public Builder geoMatchStatement(IResolvable geoMatchStatement) {
                this.geoMatchStatement = geoMatchStatement;
                return this;
            }

            public Builder geoMatchStatement(GeoMatchStatementProperty geoMatchStatement) {
                this.geoMatchStatement = geoMatchStatement;
                return this;
            }

            public Builder ipSetReferenceStatement(IResolvable ipSetReferenceStatement) {
                this.ipSetReferenceStatement = ipSetReferenceStatement;
                return this;
            }

            public Builder ipSetReferenceStatement(IPSetReferenceStatementProperty ipSetReferenceStatement) {
                this.ipSetReferenceStatement = ipSetReferenceStatement;
                return this;
            }

            public Builder regexPatternSetReferenceStatement(IResolvable regexPatternSetReferenceStatement) {
                this.regexPatternSetReferenceStatement = regexPatternSetReferenceStatement;
                return this;
            }

            public Builder regexPatternSetReferenceStatement(RegexPatternSetReferenceStatementProperty regexPatternSetReferenceStatement) {
                this.regexPatternSetReferenceStatement = regexPatternSetReferenceStatement;
                return this;
            }

            public Builder sizeConstraintStatement(IResolvable sizeConstraintStatement) {
                this.sizeConstraintStatement = sizeConstraintStatement;
                return this;
            }

            public Builder sizeConstraintStatement(SizeConstraintStatementProperty sizeConstraintStatement) {
                this.sizeConstraintStatement = sizeConstraintStatement;
                return this;
            }

            public Builder sqliMatchStatement(IResolvable sqliMatchStatement) {
                this.sqliMatchStatement = sqliMatchStatement;
                return this;
            }

            public Builder sqliMatchStatement(SqliMatchStatementProperty sqliMatchStatement) {
                this.sqliMatchStatement = sqliMatchStatement;
                return this;
            }

            public Builder xssMatchStatement(IResolvable xssMatchStatement) {
                this.xssMatchStatement = xssMatchStatement;
                return this;
            }

            public Builder xssMatchStatement(XssMatchStatementProperty xssMatchStatement) {
                this.xssMatchStatement = xssMatchStatement;
                return this;
            }

            public StatementThreeProperty build() {
                return new Jsii.Proxy(this.byteMatchStatement, this.geoMatchStatement, this.ipSetReferenceStatement, this.regexPatternSetReferenceStatement, this.sizeConstraintStatement, this.sqliMatchStatement, this.xssMatchStatement, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-wafv2.CfnRuleGroup.StatementOneProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface StatementOneProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAndStatement() {
            return null;
        }

        @Nullable
        default public Object getByteMatchStatement() {
            return null;
        }

        @Nullable
        default public Object getGeoMatchStatement() {
            return null;
        }

        @Nullable
        default public Object getIpSetReferenceStatement() {
            return null;
        }

        @Nullable
        default public Object getNotStatement() {
            return null;
        }

        @Nullable
        default public Object getOrStatement() {
            return null;
        }

        @Nullable
        default public Object getRateBasedStatement() {
            return null;
        }

        @Nullable
        default public Object getRegexPatternSetReferenceStatement() {
            return null;
        }

        @Nullable
        default public Object getSizeConstraintStatement() {
            return null;
        }

        @Nullable
        default public Object getSqliMatchStatement() {
            return null;
        }

        @Nullable
        default public Object getXssMatchStatement() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object andStatement;
            private Object byteMatchStatement;
            private Object geoMatchStatement;
            private Object ipSetReferenceStatement;
            private Object notStatement;
            private Object orStatement;
            private Object rateBasedStatement;
            private Object regexPatternSetReferenceStatement;
            private Object sizeConstraintStatement;
            private Object sqliMatchStatement;
            private Object xssMatchStatement;

            public Builder andStatement(IResolvable andStatement) {
                this.andStatement = andStatement;
                return this;
            }

            public Builder andStatement(AndStatementOneProperty andStatement) {
                this.andStatement = andStatement;
                return this;
            }

            public Builder byteMatchStatement(IResolvable byteMatchStatement) {
                this.byteMatchStatement = byteMatchStatement;
                return this;
            }

            public Builder byteMatchStatement(ByteMatchStatementProperty byteMatchStatement) {
                this.byteMatchStatement = byteMatchStatement;
                return this;
            }

            public Builder geoMatchStatement(IResolvable geoMatchStatement) {
                this.geoMatchStatement = geoMatchStatement;
                return this;
            }

            public Builder geoMatchStatement(GeoMatchStatementProperty geoMatchStatement) {
                this.geoMatchStatement = geoMatchStatement;
                return this;
            }

            public Builder ipSetReferenceStatement(IResolvable ipSetReferenceStatement) {
                this.ipSetReferenceStatement = ipSetReferenceStatement;
                return this;
            }

            public Builder ipSetReferenceStatement(IPSetReferenceStatementProperty ipSetReferenceStatement) {
                this.ipSetReferenceStatement = ipSetReferenceStatement;
                return this;
            }

            public Builder notStatement(IResolvable notStatement) {
                this.notStatement = notStatement;
                return this;
            }

            public Builder notStatement(NotStatementOneProperty notStatement) {
                this.notStatement = notStatement;
                return this;
            }

            public Builder orStatement(IResolvable orStatement) {
                this.orStatement = orStatement;
                return this;
            }

            public Builder orStatement(OrStatementOneProperty orStatement) {
                this.orStatement = orStatement;
                return this;
            }

            public Builder rateBasedStatement(IResolvable rateBasedStatement) {
                this.rateBasedStatement = rateBasedStatement;
                return this;
            }

            public Builder rateBasedStatement(RateBasedStatementOneProperty rateBasedStatement) {
                this.rateBasedStatement = rateBasedStatement;
                return this;
            }

            public Builder regexPatternSetReferenceStatement(IResolvable regexPatternSetReferenceStatement) {
                this.regexPatternSetReferenceStatement = regexPatternSetReferenceStatement;
                return this;
            }

            public Builder regexPatternSetReferenceStatement(RegexPatternSetReferenceStatementProperty regexPatternSetReferenceStatement) {
                this.regexPatternSetReferenceStatement = regexPatternSetReferenceStatement;
                return this;
            }

            public Builder sizeConstraintStatement(IResolvable sizeConstraintStatement) {
                this.sizeConstraintStatement = sizeConstraintStatement;
                return this;
            }

            public Builder sizeConstraintStatement(SizeConstraintStatementProperty sizeConstraintStatement) {
                this.sizeConstraintStatement = sizeConstraintStatement;
                return this;
            }

            public Builder sqliMatchStatement(IResolvable sqliMatchStatement) {
                this.sqliMatchStatement = sqliMatchStatement;
                return this;
            }

            public Builder sqliMatchStatement(SqliMatchStatementProperty sqliMatchStatement) {
                this.sqliMatchStatement = sqliMatchStatement;
                return this;
            }

            public Builder xssMatchStatement(IResolvable xssMatchStatement) {
                this.xssMatchStatement = xssMatchStatement;
                return this;
            }

            public Builder xssMatchStatement(XssMatchStatementProperty xssMatchStatement) {
                this.xssMatchStatement = xssMatchStatement;
                return this;
            }

            public StatementOneProperty build() {
                return new Jsii.Proxy(this.andStatement, this.byteMatchStatement, this.geoMatchStatement, this.ipSetReferenceStatement, this.notStatement, this.orStatement, this.rateBasedStatement, this.regexPatternSetReferenceStatement, this.sizeConstraintStatement, this.sqliMatchStatement, this.xssMatchStatement, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-wafv2.CfnRuleGroup.SqliMatchStatementProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SqliMatchStatementProperty
    extends JsiiSerializable {
        @NotNull
        public Object getFieldToMatch();

        @NotNull
        public Object getTextTransformations();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object fieldToMatch;
            private Object textTransformations;

            public Builder fieldToMatch(IResolvable fieldToMatch) {
                this.fieldToMatch = fieldToMatch;
                return this;
            }

            public Builder fieldToMatch(FieldToMatchProperty fieldToMatch) {
                this.fieldToMatch = fieldToMatch;
                return this;
            }

            public Builder textTransformations(IResolvable textTransformations) {
                this.textTransformations = textTransformations;
                return this;
            }

            public Builder textTransformations(List<Object> textTransformations) {
                this.textTransformations = textTransformations;
                return this;
            }

            public SqliMatchStatementProperty build() {
                return new Jsii.Proxy(this.fieldToMatch, this.textTransformations, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-wafv2.CfnRuleGroup.SizeConstraintStatementProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SizeConstraintStatementProperty
    extends JsiiSerializable {
        @NotNull
        public String getComparisonOperator();

        @NotNull
        public Object getFieldToMatch();

        @NotNull
        public Number getSize();

        @NotNull
        public Object getTextTransformations();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String comparisonOperator;
            private Object fieldToMatch;
            private Number size;
            private Object textTransformations;

            public Builder comparisonOperator(String comparisonOperator) {
                this.comparisonOperator = comparisonOperator;
                return this;
            }

            public Builder fieldToMatch(IResolvable fieldToMatch) {
                this.fieldToMatch = fieldToMatch;
                return this;
            }

            public Builder fieldToMatch(FieldToMatchProperty fieldToMatch) {
                this.fieldToMatch = fieldToMatch;
                return this;
            }

            public Builder size(Number size) {
                this.size = size;
                return this;
            }

            public Builder textTransformations(IResolvable textTransformations) {
                this.textTransformations = textTransformations;
                return this;
            }

            public Builder textTransformations(List<Object> textTransformations) {
                this.textTransformations = textTransformations;
                return this;
            }

            public SizeConstraintStatementProperty build() {
                return new Jsii.Proxy(this.comparisonOperator, this.fieldToMatch, this.size, this.textTransformations, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-wafv2.CfnRuleGroup.RuleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RuleProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @NotNull
        public Number getPriority();

        @NotNull
        public Object getStatement();

        @NotNull
        public Object getVisibilityConfig();

        @Nullable
        default public Object getAction() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String name;
            private Number priority;
            private Object statement;
            private Object visibilityConfig;
            private Object action;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder priority(Number priority) {
                this.priority = priority;
                return this;
            }

            public Builder statement(IResolvable statement) {
                this.statement = statement;
                return this;
            }

            public Builder statement(StatementOneProperty statement) {
                this.statement = statement;
                return this;
            }

            public Builder visibilityConfig(IResolvable visibilityConfig) {
                this.visibilityConfig = visibilityConfig;
                return this;
            }

            public Builder visibilityConfig(VisibilityConfigProperty visibilityConfig) {
                this.visibilityConfig = visibilityConfig;
                return this;
            }

            public Builder action(IResolvable action) {
                this.action = action;
                return this;
            }

            public Builder action(RuleActionProperty action) {
                this.action = action;
                return this;
            }

            public RuleProperty build() {
                return new Jsii.Proxy(this.name, this.priority, this.statement, this.visibilityConfig, this.action, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-wafv2.CfnRuleGroup.RuleActionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RuleActionProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAllow() {
            return null;
        }

        @Nullable
        default public Object getBlock() {
            return null;
        }

        @Nullable
        default public Object getCount() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object allow;
            private Object block;
            private Object count;

            public Builder allow(Object allow) {
                this.allow = allow;
                return this;
            }

            public Builder block(Object block) {
                this.block = block;
                return this;
            }

            public Builder count(Object count) {
                this.count = count;
                return this;
            }

            public RuleActionProperty build() {
                return new Jsii.Proxy(this.allow, this.block, this.count, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-wafv2.CfnRuleGroup.RegexPatternSetReferenceStatementProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RegexPatternSetReferenceStatementProperty
    extends JsiiSerializable {
        @NotNull
        public String getArn();

        @NotNull
        public Object getFieldToMatch();

        @NotNull
        public Object getTextTransformations();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String arn;
            private Object fieldToMatch;
            private Object textTransformations;

            public Builder arn(String arn) {
                this.arn = arn;
                return this;
            }

            public Builder fieldToMatch(IResolvable fieldToMatch) {
                this.fieldToMatch = fieldToMatch;
                return this;
            }

            public Builder fieldToMatch(FieldToMatchProperty fieldToMatch) {
                this.fieldToMatch = fieldToMatch;
                return this;
            }

            public Builder textTransformations(IResolvable textTransformations) {
                this.textTransformations = textTransformations;
                return this;
            }

            public Builder textTransformations(List<Object> textTransformations) {
                this.textTransformations = textTransformations;
                return this;
            }

            public RegexPatternSetReferenceStatementProperty build() {
                return new Jsii.Proxy(this.arn, this.fieldToMatch, this.textTransformations, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-wafv2.CfnRuleGroup.RateBasedStatementTwoProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RateBasedStatementTwoProperty
    extends JsiiSerializable {
        @NotNull
        public String getAggregateKeyType();

        @NotNull
        public Number getLimit();

        @Nullable
        default public Object getScopeDownStatement() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String aggregateKeyType;
            private Number limit;
            private Object scopeDownStatement;

            public Builder aggregateKeyType(String aggregateKeyType) {
                this.aggregateKeyType = aggregateKeyType;
                return this;
            }

            public Builder limit(Number limit) {
                this.limit = limit;
                return this;
            }

            public Builder scopeDownStatement(IResolvable scopeDownStatement) {
                this.scopeDownStatement = scopeDownStatement;
                return this;
            }

            public Builder scopeDownStatement(StatementThreeProperty scopeDownStatement) {
                this.scopeDownStatement = scopeDownStatement;
                return this;
            }

            public RateBasedStatementTwoProperty build() {
                return new Jsii.Proxy(this.aggregateKeyType, this.limit, this.scopeDownStatement, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-wafv2.CfnRuleGroup.RateBasedStatementOneProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RateBasedStatementOneProperty
    extends JsiiSerializable {
        @NotNull
        public String getAggregateKeyType();

        @NotNull
        public Number getLimit();

        @Nullable
        default public Object getScopeDownStatement() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String aggregateKeyType;
            private Number limit;
            private Object scopeDownStatement;

            public Builder aggregateKeyType(String aggregateKeyType) {
                this.aggregateKeyType = aggregateKeyType;
                return this;
            }

            public Builder limit(Number limit) {
                this.limit = limit;
                return this;
            }

            public Builder scopeDownStatement(IResolvable scopeDownStatement) {
                this.scopeDownStatement = scopeDownStatement;
                return this;
            }

            public Builder scopeDownStatement(StatementTwoProperty scopeDownStatement) {
                this.scopeDownStatement = scopeDownStatement;
                return this;
            }

            public RateBasedStatementOneProperty build() {
                return new Jsii.Proxy(this.aggregateKeyType, this.limit, this.scopeDownStatement, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-wafv2.CfnRuleGroup.OrStatementTwoProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OrStatementTwoProperty
    extends JsiiSerializable {
        @NotNull
        public Object getStatements();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object statements;

            public Builder statements(IResolvable statements) {
                this.statements = statements;
                return this;
            }

            public Builder statements(List<Object> statements) {
                this.statements = statements;
                return this;
            }

            public OrStatementTwoProperty build() {
                return new Jsii.Proxy(this.statements, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-wafv2.CfnRuleGroup.OrStatementOneProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OrStatementOneProperty
    extends JsiiSerializable {
        @NotNull
        public Object getStatements();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object statements;

            public Builder statements(IResolvable statements) {
                this.statements = statements;
                return this;
            }

            public Builder statements(List<Object> statements) {
                this.statements = statements;
                return this;
            }

            public OrStatementOneProperty build() {
                return new Jsii.Proxy(this.statements, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-wafv2.CfnRuleGroup.NotStatementTwoProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NotStatementTwoProperty
    extends JsiiSerializable {
        @NotNull
        public Object getStatement();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object statement;

            public Builder statement(IResolvable statement) {
                this.statement = statement;
                return this;
            }

            public Builder statement(StatementThreeProperty statement) {
                this.statement = statement;
                return this;
            }

            public NotStatementTwoProperty build() {
                return new Jsii.Proxy(this.statement, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-wafv2.CfnRuleGroup.NotStatementOneProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NotStatementOneProperty
    extends JsiiSerializable {
        @NotNull
        public Object getStatement();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object statement;

            public Builder statement(IResolvable statement) {
                this.statement = statement;
                return this;
            }

            public Builder statement(StatementTwoProperty statement) {
                this.statement = statement;
                return this;
            }

            public NotStatementOneProperty build() {
                return new Jsii.Proxy(this.statement, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-wafv2.CfnRuleGroup.IPSetReferenceStatementProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface IPSetReferenceStatementProperty
    extends JsiiSerializable {
        @NotNull
        public String getArn();
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-wafv2.CfnRuleGroup.GeoMatchStatementProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface GeoMatchStatementProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getCountryCodes() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private List<String> countryCodes;

            public Builder countryCodes(List<String> countryCodes) {
                this.countryCodes = countryCodes;
                return this;
            }

            public GeoMatchStatementProperty build() {
                return new Jsii.Proxy(this.countryCodes, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-wafv2.CfnRuleGroup.FieldToMatchProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FieldToMatchProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAllQueryArguments() {
            return null;
        }

        @Nullable
        default public Object getBody() {
            return null;
        }

        @Nullable
        default public Object getMethod() {
            return null;
        }

        @Nullable
        default public Object getQueryString() {
            return null;
        }

        @Nullable
        default public Object getSingleHeader() {
            return null;
        }

        @Nullable
        default public Object getSingleQueryArgument() {
            return null;
        }

        @Nullable
        default public Object getUriPath() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object allQueryArguments;
            private Object body;
            private Object method;
            private Object queryString;
            private Object singleHeader;
            private Object singleQueryArgument;
            private Object uriPath;

            public Builder allQueryArguments(Object allQueryArguments) {
                this.allQueryArguments = allQueryArguments;
                return this;
            }

            public Builder body(Object body) {
                this.body = body;
                return this;
            }

            public Builder method(Object method) {
                this.method = method;
                return this;
            }

            public Builder queryString(Object queryString) {
                this.queryString = queryString;
                return this;
            }

            public Builder singleHeader(Object singleHeader) {
                this.singleHeader = singleHeader;
                return this;
            }

            public Builder singleQueryArgument(Object singleQueryArgument) {
                this.singleQueryArgument = singleQueryArgument;
                return this;
            }

            public Builder uriPath(Object uriPath) {
                this.uriPath = uriPath;
                return this;
            }

            public FieldToMatchProperty build() {
                return new Jsii.Proxy(this.allQueryArguments, this.body, this.method, this.queryString, this.singleHeader, this.singleQueryArgument, this.uriPath, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-wafv2.CfnRuleGroup.ByteMatchStatementProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ByteMatchStatementProperty
    extends JsiiSerializable {
        @NotNull
        public Object getFieldToMatch();

        @NotNull
        public String getPositionalConstraint();

        @NotNull
        public Object getTextTransformations();

        @Nullable
        default public String getSearchString() {
            return null;
        }

        @Nullable
        default public String getSearchStringBase64() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object fieldToMatch;
            private String positionalConstraint;
            private Object textTransformations;
            private String searchString;
            private String searchStringBase64;

            public Builder fieldToMatch(IResolvable fieldToMatch) {
                this.fieldToMatch = fieldToMatch;
                return this;
            }

            public Builder fieldToMatch(FieldToMatchProperty fieldToMatch) {
                this.fieldToMatch = fieldToMatch;
                return this;
            }

            public Builder positionalConstraint(String positionalConstraint) {
                this.positionalConstraint = positionalConstraint;
                return this;
            }

            public Builder textTransformations(IResolvable textTransformations) {
                this.textTransformations = textTransformations;
                return this;
            }

            public Builder textTransformations(List<Object> textTransformations) {
                this.textTransformations = textTransformations;
                return this;
            }

            public Builder searchString(String searchString) {
                this.searchString = searchString;
                return this;
            }

            public Builder searchStringBase64(String searchStringBase64) {
                this.searchStringBase64 = searchStringBase64;
                return this;
            }

            public ByteMatchStatementProperty build() {
                return new Jsii.Proxy(this.fieldToMatch, this.positionalConstraint, this.textTransformations, this.searchString, this.searchStringBase64, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-wafv2.CfnRuleGroup.AndStatementTwoProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AndStatementTwoProperty
    extends JsiiSerializable {
        @NotNull
        public Object getStatements();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object statements;

            public Builder statements(IResolvable statements) {
                this.statements = statements;
                return this;
            }

            public Builder statements(List<Object> statements) {
                this.statements = statements;
                return this;
            }

            public AndStatementTwoProperty build() {
                return new Jsii.Proxy(this.statements, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-wafv2.CfnRuleGroup.AndStatementOneProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AndStatementOneProperty
    extends JsiiSerializable {
        @NotNull
        public Object getStatements();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object statements;

            public Builder statements(IResolvable statements) {
                this.statements = statements;
                return this;
            }

            public Builder statements(List<Object> statements) {
                this.statements = statements;
                return this;
            }

            public AndStatementOneProperty build() {
                return new Jsii.Proxy(this.statements, null);
            }
        }
    }
}

