/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.transfer;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.FromCloudFormationOptions;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.transfer.;
import software.amazon.awscdk.services.transfer.CfnUser;
import software.amazon.awscdk.services.transfer.CfnUserProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-transfer.CfnUser")
public class CfnUser
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnUser.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnUser(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnUser(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnUser(@NotNull Construct scope, @NotNull String id, @NotNull CfnUserProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static CfnUser fromCloudFormation(@NotNull Construct scope, @NotNull String id, @NotNull Object resourceAttributes, @NotNull FromCloudFormationOptions options) {
        return (CfnUser)((Object)JsiiObject.jsiiStaticCall(CfnUser.class, (String)"fromCloudFormation", CfnUser.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), resourceAttributes, Objects.requireNonNull(options, "options is required")}));
    }

    public void inspect(@NotNull TreeInspector inspector) {
        this.jsiiCall("inspect", NativeType.VOID, new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)this.jsiiCall("renderProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)this.jsiiGet("attrArn", String.class);
    }

    @NotNull
    public String getAttrServerId() {
        return (String)this.jsiiGet("attrServerId", String.class);
    }

    @NotNull
    public String getAttrUserName() {
        return (String)this.jsiiGet("attrUserName", String.class);
    }

    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("cfnProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)this.jsiiGet("tags", TagManager.class);
    }

    @NotNull
    public String getRole() {
        return (String)this.jsiiGet("role", String.class);
    }

    public void setRole(@NotNull String value) {
        this.jsiiSet("role", Objects.requireNonNull(value, "role is required"));
    }

    @NotNull
    public String getServerId() {
        return (String)this.jsiiGet("serverId", String.class);
    }

    public void setServerId(@NotNull String value) {
        this.jsiiSet("serverId", Objects.requireNonNull(value, "serverId is required"));
    }

    @NotNull
    public String getUserName() {
        return (String)this.jsiiGet("userName", String.class);
    }

    public void setUserName(@NotNull String value) {
        this.jsiiSet("userName", Objects.requireNonNull(value, "userName is required"));
    }

    @Nullable
    public String getHomeDirectory() {
        return (String)this.jsiiGet("homeDirectory", String.class);
    }

    public void setHomeDirectory(@Nullable String value) {
        this.jsiiSet("homeDirectory", value);
    }

    @Nullable
    public Object getHomeDirectoryMappings() {
        return this.jsiiGet("homeDirectoryMappings", Object.class);
    }

    public void setHomeDirectoryMappings(@Nullable IResolvable value) {
        this.jsiiSet("homeDirectoryMappings", value);
    }

    public void setHomeDirectoryMappings(@Nullable List<Object> value) {
        this.jsiiSet("homeDirectoryMappings", value);
    }

    @Nullable
    public String getHomeDirectoryType() {
        return (String)this.jsiiGet("homeDirectoryType", String.class);
    }

    public void setHomeDirectoryType(@Nullable String value) {
        this.jsiiSet("homeDirectoryType", value);
    }

    @Nullable
    public String getPolicy() {
        return (String)this.jsiiGet("policy", String.class);
    }

    public void setPolicy(@Nullable String value) {
        this.jsiiSet("policy", value);
    }

    @Nullable
    public List<String> getSshPublicKeys() {
        return Optional.ofNullable((List)this.jsiiGet("sshPublicKeys", NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setSshPublicKeys(@Nullable List<String> value) {
        this.jsiiSet("sshPublicKeys", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnUser> {
        private final Construct scope;
        private final String id;
        private final CfnUserProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnUserProps.Builder();
        }

        public Builder role(String role) {
            this.props.role(role);
            return this;
        }

        public Builder serverId(String serverId) {
            this.props.serverId(serverId);
            return this;
        }

        public Builder userName(String userName) {
            this.props.userName(userName);
            return this;
        }

        public Builder homeDirectory(String homeDirectory) {
            this.props.homeDirectory(homeDirectory);
            return this;
        }

        public Builder homeDirectoryMappings(IResolvable homeDirectoryMappings) {
            this.props.homeDirectoryMappings(homeDirectoryMappings);
            return this;
        }

        public Builder homeDirectoryMappings(List<Object> homeDirectoryMappings) {
            this.props.homeDirectoryMappings(homeDirectoryMappings);
            return this;
        }

        public Builder homeDirectoryType(String homeDirectoryType) {
            this.props.homeDirectoryType(homeDirectoryType);
            return this;
        }

        public Builder policy(String policy) {
            this.props.policy(policy);
            return this;
        }

        public Builder sshPublicKeys(List<String> sshPublicKeys) {
            this.props.sshPublicKeys(sshPublicKeys);
            return this;
        }

        public Builder tags(List<CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnUser build() {
            return new CfnUser(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-transfer.CfnUser.HomeDirectoryMapEntryProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HomeDirectoryMapEntryProperty
    extends JsiiSerializable {
        @NotNull
        public String getEntry();

        @NotNull
        public String getTarget();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HomeDirectoryMapEntryProperty> {
            private String entry;
            private String target;

            public Builder entry(String entry) {
                this.entry = entry;
                return this;
            }

            public Builder target(String target) {
                this.target = target;
                return this;
            }

            public HomeDirectoryMapEntryProperty build() {
                return new Jsii.Proxy(this.entry, this.target, null);
            }
        }
    }
}

