/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.transfer;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.FromCloudFormationOptions;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.transfer.;
import software.amazon.awscdk.services.transfer.CfnServer;
import software.amazon.awscdk.services.transfer.CfnServerProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-transfer.CfnServer")
public class CfnServer
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnServer.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnServer(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnServer(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnServer(@NotNull Construct scope, @NotNull String id, @Nullable CfnServerProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public CfnServer(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public static CfnServer fromCloudFormation(@NotNull Construct scope, @NotNull String id, @NotNull Object resourceAttributes, @NotNull FromCloudFormationOptions options) {
        return (CfnServer)((Object)JsiiObject.jsiiStaticCall(CfnServer.class, (String)"fromCloudFormation", CfnServer.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), resourceAttributes, Objects.requireNonNull(options, "options is required")}));
    }

    public void inspect(@NotNull TreeInspector inspector) {
        this.jsiiCall("inspect", NativeType.VOID, new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)this.jsiiCall("renderProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)this.jsiiGet("attrArn", String.class);
    }

    @NotNull
    public String getAttrServerId() {
        return (String)this.jsiiGet("attrServerId", String.class);
    }

    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("cfnProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)this.jsiiGet("tags", TagManager.class);
    }

    @Nullable
    public String getCertificate() {
        return (String)this.jsiiGet("certificate", String.class);
    }

    public void setCertificate(@Nullable String value) {
        this.jsiiSet("certificate", value);
    }

    @Nullable
    public Object getEndpointDetails() {
        return this.jsiiGet("endpointDetails", Object.class);
    }

    public void setEndpointDetails(@Nullable EndpointDetailsProperty value) {
        this.jsiiSet("endpointDetails", value);
    }

    public void setEndpointDetails(@Nullable IResolvable value) {
        this.jsiiSet("endpointDetails", value);
    }

    @Nullable
    public String getEndpointType() {
        return (String)this.jsiiGet("endpointType", String.class);
    }

    public void setEndpointType(@Nullable String value) {
        this.jsiiSet("endpointType", value);
    }

    @Nullable
    public Object getIdentityProviderDetails() {
        return this.jsiiGet("identityProviderDetails", Object.class);
    }

    public void setIdentityProviderDetails(@Nullable IResolvable value) {
        this.jsiiSet("identityProviderDetails", value);
    }

    public void setIdentityProviderDetails(@Nullable IdentityProviderDetailsProperty value) {
        this.jsiiSet("identityProviderDetails", value);
    }

    @Nullable
    public String getIdentityProviderType() {
        return (String)this.jsiiGet("identityProviderType", String.class);
    }

    public void setIdentityProviderType(@Nullable String value) {
        this.jsiiSet("identityProviderType", value);
    }

    @Nullable
    public String getLoggingRole() {
        return (String)this.jsiiGet("loggingRole", String.class);
    }

    public void setLoggingRole(@Nullable String value) {
        this.jsiiSet("loggingRole", value);
    }

    @Nullable
    public List<String> getProtocols() {
        return Optional.ofNullable((List)this.jsiiGet("protocols", NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setProtocols(@Nullable List<String> value) {
        this.jsiiSet("protocols", value);
    }

    public static final class Builder {
        private final Construct scope;
        private final String id;
        private CfnServerProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder certificate(String certificate) {
            this.props().certificate(certificate);
            return this;
        }

        public Builder endpointDetails(EndpointDetailsProperty endpointDetails) {
            this.props().endpointDetails(endpointDetails);
            return this;
        }

        public Builder endpointDetails(IResolvable endpointDetails) {
            this.props().endpointDetails(endpointDetails);
            return this;
        }

        public Builder endpointType(String endpointType) {
            this.props().endpointType(endpointType);
            return this;
        }

        public Builder identityProviderDetails(IResolvable identityProviderDetails) {
            this.props().identityProviderDetails(identityProviderDetails);
            return this;
        }

        public Builder identityProviderDetails(IdentityProviderDetailsProperty identityProviderDetails) {
            this.props().identityProviderDetails(identityProviderDetails);
            return this;
        }

        public Builder identityProviderType(String identityProviderType) {
            this.props().identityProviderType(identityProviderType);
            return this;
        }

        public Builder loggingRole(String loggingRole) {
            this.props().loggingRole(loggingRole);
            return this;
        }

        public Builder protocols(List<String> protocols) {
            this.props().protocols(protocols);
            return this;
        }

        public Builder tags(List<CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        public CfnServer build() {
            return new CfnServer(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private CfnServerProps.Builder props() {
            if (this.props == null) {
                this.props = new CfnServerProps.Builder();
            }
            return this.props;
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-transfer.CfnServer.IdentityProviderDetailsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface IdentityProviderDetailsProperty
    extends JsiiSerializable {
        @NotNull
        public String getInvocationRole();

        @NotNull
        public String getUrl();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String invocationRole;
            private String url;

            public Builder invocationRole(String invocationRole) {
                this.invocationRole = invocationRole;
                return this;
            }

            public Builder url(String url) {
                this.url = url;
                return this;
            }

            public IdentityProviderDetailsProperty build() {
                return new Jsii.Proxy(this.invocationRole, this.url, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-transfer.CfnServer.EndpointDetailsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EndpointDetailsProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getAddressAllocationIds() {
            return null;
        }

        @Nullable
        default public List<String> getSubnetIds() {
            return null;
        }

        @Nullable
        default public String getVpcEndpointId() {
            return null;
        }

        @Nullable
        default public String getVpcId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private List<String> addressAllocationIds;
            private List<String> subnetIds;
            private String vpcEndpointId;
            private String vpcId;

            public Builder addressAllocationIds(List<String> addressAllocationIds) {
                this.addressAllocationIds = addressAllocationIds;
                return this;
            }

            public Builder subnetIds(List<String> subnetIds) {
                this.subnetIds = subnetIds;
                return this;
            }

            public Builder vpcEndpointId(String vpcEndpointId) {
                this.vpcEndpointId = vpcEndpointId;
                return this;
            }

            public Builder vpcId(String vpcId) {
                this.vpcId = vpcId;
                return this;
            }

            public EndpointDetailsProperty build() {
                return new Jsii.Proxy(this.addressAllocationIds, this.subnetIds, this.vpcEndpointId, this.vpcId, null);
            }
        }
    }
}

