/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.transfer;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.CfnTag;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface CfnUserProps
extends JsiiSerializable {
    public String getRole();

    public String getServerId();

    public String getUserName();

    public String getHomeDirectory();

    public String getPolicy();

    public List<String> getSshPublicKeys();

    public List<CfnTag> getTags();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _role;
        private String _serverId;
        private String _userName;
        @Nullable
        private String _homeDirectory;
        @Nullable
        private String _policy;
        @Nullable
        private List<String> _sshPublicKeys;
        @Nullable
        private List<CfnTag> _tags;

        public Builder withRole(String value) {
            this._role = Objects.requireNonNull(value, "role is required");
            return this;
        }

        public Builder withServerId(String value) {
            this._serverId = Objects.requireNonNull(value, "serverId is required");
            return this;
        }

        public Builder withUserName(String value) {
            this._userName = Objects.requireNonNull(value, "userName is required");
            return this;
        }

        public Builder withHomeDirectory(@Nullable String value) {
            this._homeDirectory = value;
            return this;
        }

        public Builder withPolicy(@Nullable String value) {
            this._policy = value;
            return this;
        }

        public Builder withSshPublicKeys(@Nullable List<String> value) {
            this._sshPublicKeys = value;
            return this;
        }

        public Builder withTags(@Nullable List<CfnTag> value) {
            this._tags = value;
            return this;
        }

        public CfnUserProps build() {
            return new CfnUserProps(){
                private final String $role;
                private final String $serverId;
                private final String $userName;
                @Nullable
                private final String $homeDirectory;
                @Nullable
                private final String $policy;
                @Nullable
                private final List<String> $sshPublicKeys;
                @Nullable
                private final List<CfnTag> $tags;
                {
                    this.$role = Objects.requireNonNull(_role, "role is required");
                    this.$serverId = Objects.requireNonNull(_serverId, "serverId is required");
                    this.$userName = Objects.requireNonNull(_userName, "userName is required");
                    this.$homeDirectory = _homeDirectory;
                    this.$policy = _policy;
                    this.$sshPublicKeys = _sshPublicKeys;
                    this.$tags = _tags;
                }

                @Override
                public String getRole() {
                    return this.$role;
                }

                @Override
                public String getServerId() {
                    return this.$serverId;
                }

                @Override
                public String getUserName() {
                    return this.$userName;
                }

                @Override
                public String getHomeDirectory() {
                    return this.$homeDirectory;
                }

                @Override
                public String getPolicy() {
                    return this.$policy;
                }

                @Override
                public List<String> getSshPublicKeys() {
                    return this.$sshPublicKeys;
                }

                @Override
                public List<CfnTag> getTags() {
                    return this.$tags;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("role", om.valueToTree((Object)this.getRole()));
                    obj.set("serverId", om.valueToTree((Object)this.getServerId()));
                    obj.set("userName", om.valueToTree((Object)this.getUserName()));
                    if (this.getHomeDirectory() != null) {
                        obj.set("homeDirectory", om.valueToTree((Object)this.getHomeDirectory()));
                    }
                    if (this.getPolicy() != null) {
                        obj.set("policy", om.valueToTree((Object)this.getPolicy()));
                    }
                    if (this.getSshPublicKeys() != null) {
                        obj.set("sshPublicKeys", om.valueToTree(this.getSshPublicKeys()));
                    }
                    if (this.getTags() != null) {
                        obj.set("tags", om.valueToTree(this.getTags()));
                    }
                    return obj;
                }
            };
        }
    }
}

