package software.amazon.awscdk.services.stepfunctions;

/**
 * Define a Succeed state in the state machine.
 * <p>
 * Reaching a Succeed state terminates the state execution in success.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:13.493Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.$Module.class, fqn = "@aws-cdk/aws-stepfunctions.Succeed")
public class Succeed extends software.amazon.awscdk.services.stepfunctions.State {

    protected Succeed(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Succeed(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Succeed(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.SucceedProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Succeed(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Return the Amazon States Language object for this state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull com.fasterxml.jackson.databind.node.ObjectNode toStateJson() {
        return this.jsiiCall("toStateJson", com.fasterxml.jackson.databind.node.ObjectNode.class);
    }

    /**
     * Continuable states of this Chainable.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.stepfunctions.INextable> getEndStates() {
        return java.util.Collections.unmodifiableList(this.jsiiGet("endStates", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.INextable.class))));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.stepfunctions.Succeed}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.stepfunctions.Succeed> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.stepfunctions.SucceedProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * An optional description for this state.
         * <p>
         * Default: No comment
         * <p>
         * @return {@code this}
         * @param comment An optional description for this state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(final java.lang.String comment) {
            this.props().comment(comment);
            return this;
        }

        /**
         * JSONPath expression to select part of the state to be the input to this state.
         * <p>
         * May also be the special value JsonPath.DISCARD, which will cause the effective
         * input to be the empty object {}.
         * <p>
         * Default: $
         * <p>
         * @return {@code this}
         * @param inputPath JSONPath expression to select part of the state to be the input to this state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputPath(final java.lang.String inputPath) {
            this.props().inputPath(inputPath);
            return this;
        }

        /**
         * JSONPath expression to select part of the state to be the output to this state.
         * <p>
         * May also be the special value JsonPath.DISCARD, which will cause the effective
         * output to be the empty object {}.
         * <p>
         * Default: $
         * <p>
         * @return {@code this}
         * @param outputPath JSONPath expression to select part of the state to be the output to this state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputPath(final java.lang.String outputPath) {
            this.props().outputPath(outputPath);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.stepfunctions.Succeed}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.stepfunctions.Succeed build() {
            return new software.amazon.awscdk.services.stepfunctions.Succeed(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.stepfunctions.SucceedProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.stepfunctions.SucceedProps.Builder();
            }
            return this.props;
        }
    }
}
