package software.amazon.awscdk.services.stepfunctions;

/**
 * Properties for defining a State Machine.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:13.491Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.$Module.class, fqn = "@aws-cdk/aws-stepfunctions.StateMachineProps")
@software.amazon.jsii.Jsii.Proxy(StateMachineProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface StateMachineProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Definition for this state machine.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.IChainable getDefinition();

    /**
     * Defines what execution history events are logged and where they are logged.
     * <p>
     * Default: No logging
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.LogOptions getLogs() {
        return null;
    }

    /**
     * The execution role for the state machine service.
     * <p>
     * Default: A role is automatically created
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * A name for the state machine.
     * <p>
     * Default: A name is automatically generated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStateMachineName() {
        return null;
    }

    /**
     * Type of the state machine.
     * <p>
     * Default: StateMachineType.STANDARD
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.StateMachineType getStateMachineType() {
        return null;
    }

    /**
     * Maximum run time for this state machine.
     * <p>
     * Default: No timeout
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getTimeout() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link StateMachineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link StateMachineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<StateMachineProps> {
        private software.amazon.awscdk.services.stepfunctions.IChainable definition;
        private software.amazon.awscdk.services.stepfunctions.LogOptions logs;
        private software.amazon.awscdk.services.iam.IRole role;
        private java.lang.String stateMachineName;
        private software.amazon.awscdk.services.stepfunctions.StateMachineType stateMachineType;
        private software.amazon.awscdk.core.Duration timeout;

        /**
         * Sets the value of {@link StateMachineProps#getDefinition}
         * @param definition Definition for this state machine. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definition(software.amazon.awscdk.services.stepfunctions.IChainable definition) {
            this.definition = definition;
            return this;
        }

        /**
         * Sets the value of {@link StateMachineProps#getLogs}
         * @param logs Defines what execution history events are logged and where they are logged.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logs(software.amazon.awscdk.services.stepfunctions.LogOptions logs) {
            this.logs = logs;
            return this;
        }

        /**
         * Sets the value of {@link StateMachineProps#getRole}
         * @param role The execution role for the state machine service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link StateMachineProps#getStateMachineName}
         * @param stateMachineName A name for the state machine.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stateMachineName(java.lang.String stateMachineName) {
            this.stateMachineName = stateMachineName;
            return this;
        }

        /**
         * Sets the value of {@link StateMachineProps#getStateMachineType}
         * @param stateMachineType Type of the state machine.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stateMachineType(software.amazon.awscdk.services.stepfunctions.StateMachineType stateMachineType) {
            this.stateMachineType = stateMachineType;
            return this;
        }

        /**
         * Sets the value of {@link StateMachineProps#getTimeout}
         * @param timeout Maximum run time for this state machine.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(software.amazon.awscdk.core.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StateMachineProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public StateMachineProps build() {
            return new Jsii$Proxy(definition, logs, role, stateMachineName, stateMachineType, timeout);
        }
    }

    /**
     * An implementation for {@link StateMachineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StateMachineProps {
        private final software.amazon.awscdk.services.stepfunctions.IChainable definition;
        private final software.amazon.awscdk.services.stepfunctions.LogOptions logs;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final java.lang.String stateMachineName;
        private final software.amazon.awscdk.services.stepfunctions.StateMachineType stateMachineType;
        private final software.amazon.awscdk.core.Duration timeout;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.definition = this.jsiiGet("definition", software.amazon.awscdk.services.stepfunctions.IChainable.class);
            this.logs = this.jsiiGet("logs", software.amazon.awscdk.services.stepfunctions.LogOptions.class);
            this.role = this.jsiiGet("role", software.amazon.awscdk.services.iam.IRole.class);
            this.stateMachineName = this.jsiiGet("stateMachineName", java.lang.String.class);
            this.stateMachineType = this.jsiiGet("stateMachineType", software.amazon.awscdk.services.stepfunctions.StateMachineType.class);
            this.timeout = this.jsiiGet("timeout", software.amazon.awscdk.core.Duration.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.stepfunctions.IChainable definition, final software.amazon.awscdk.services.stepfunctions.LogOptions logs, final software.amazon.awscdk.services.iam.IRole role, final java.lang.String stateMachineName, final software.amazon.awscdk.services.stepfunctions.StateMachineType stateMachineType, final software.amazon.awscdk.core.Duration timeout) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.definition = java.util.Objects.requireNonNull(definition, "definition is required");
            this.logs = logs;
            this.role = role;
            this.stateMachineName = stateMachineName;
            this.stateMachineType = stateMachineType;
            this.timeout = timeout;
        }

        @Override
        public software.amazon.awscdk.services.stepfunctions.IChainable getDefinition() {
            return this.definition;
        }

        @Override
        public software.amazon.awscdk.services.stepfunctions.LogOptions getLogs() {
            return this.logs;
        }

        @Override
        public software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public java.lang.String getStateMachineName() {
            return this.stateMachineName;
        }

        @Override
        public software.amazon.awscdk.services.stepfunctions.StateMachineType getStateMachineType() {
            return this.stateMachineType;
        }

        @Override
        public software.amazon.awscdk.core.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("definition", om.valueToTree(this.getDefinition()));
            if (this.getLogs() != null) {
                data.set("logs", om.valueToTree(this.getLogs()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            if (this.getStateMachineName() != null) {
                data.set("stateMachineName", om.valueToTree(this.getStateMachineName()));
            }
            if (this.getStateMachineType() != null) {
                data.set("stateMachineType", om.valueToTree(this.getStateMachineType()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions.StateMachineProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            StateMachineProps.Jsii$Proxy that = (StateMachineProps.Jsii$Proxy) o;

            if (!definition.equals(that.definition)) return false;
            if (this.logs != null ? !this.logs.equals(that.logs) : that.logs != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            if (this.stateMachineName != null ? !this.stateMachineName.equals(that.stateMachineName) : that.stateMachineName != null) return false;
            if (this.stateMachineType != null ? !this.stateMachineType.equals(that.stateMachineType) : that.stateMachineType != null) return false;
            return this.timeout != null ? this.timeout.equals(that.timeout) : that.timeout == null;
        }

        @Override
        public int hashCode() {
            int result = this.definition.hashCode();
            result = 31 * result + (this.logs != null ? this.logs.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.stateMachineName != null ? this.stateMachineName.hashCode() : 0);
            result = 31 * result + (this.stateMachineType != null ? this.stateMachineType.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            return result;
        }
    }
}
