package software.amazon.awscdk.services.stepfunctions;

/**
 * Base class for all other state classes.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:13.489Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.$Module.class, fqn = "@aws-cdk/aws-stepfunctions.State")
public abstract class State extends software.amazon.awscdk.core.Construct implements software.amazon.awscdk.services.stepfunctions.IChainable {

    protected State(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected State(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected State(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.StateProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Return only the states that allow chaining from an array of states.
     * <p>
     * @param states This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.stepfunctions.INextable> filterNextables(final @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.stepfunctions.State> states) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.State.class, "filterNextables", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.INextable.class)), new Object[] { java.util.Objects.requireNonNull(states, "states is required") }));
    }

    /**
     * Find the set of end states states reachable through transitions from the given start state.
     * <p>
     * @param start This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.stepfunctions.State> findReachableEndStates(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.State start, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.FindStateOptions options) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.State.class, "findReachableEndStates", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.State.class)), new Object[] { java.util.Objects.requireNonNull(start, "start is required"), options }));
    }

    /**
     * Find the set of end states states reachable through transitions from the given start state.
     * <p>
     * @param start This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.stepfunctions.State> findReachableEndStates(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.State start) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.State.class, "findReachableEndStates", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.State.class)), new Object[] { java.util.Objects.requireNonNull(start, "start is required") }));
    }

    /**
     * Find the set of states reachable through transitions from the given start state.
     * <p>
     * This does not retrieve states from within sub-graphs, such as states within a Parallel state's branch.
     * <p>
     * @param start This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.stepfunctions.State> findReachableStates(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.State start, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.FindStateOptions options) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.State.class, "findReachableStates", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.State.class)), new Object[] { java.util.Objects.requireNonNull(start, "start is required"), options }));
    }

    /**
     * Find the set of states reachable through transitions from the given start state.
     * <p>
     * This does not retrieve states from within sub-graphs, such as states within a Parallel state's branch.
     * <p>
     * @param start This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.stepfunctions.State> findReachableStates(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.State start) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.State.class, "findReachableStates", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.State.class)), new Object[] { java.util.Objects.requireNonNull(start, "start is required") }));
    }

    /**
     * Add a prefix to the stateId of all States found in a construct tree.
     * <p>
     * @param root This parameter is required.
     * @param prefix This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static void prefixStates(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IConstruct root, final @org.jetbrains.annotations.NotNull java.lang.String prefix) {
        software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.State.class, "prefixStates", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(root, "root is required"), java.util.Objects.requireNonNull(prefix, "prefix is required") });
    }

    /**
     * Add a paralle branch to this state.
     * <p>
     * @param branch This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void addBranch(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.StateGraph branch) {
        this.jsiiCall("addBranch", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(branch, "branch is required") });
    }

    /**
     * Add a choice branch to this state.
     * <p>
     * @param condition This parameter is required.
     * @param next This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void addChoice(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition condition, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.State next) {
        this.jsiiCall("addChoice", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(condition, "condition is required"), java.util.Objects.requireNonNull(next, "next is required") });
    }

    /**
     * Add a map iterator to this state.
     * <p>
     * @param iteration This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void addIterator(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.StateGraph iteration) {
        this.jsiiCall("addIterator", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(iteration, "iteration is required") });
    }

    /**
     * Add a prefix to the stateId of this state.
     * <p>
     * @param x This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addPrefix(final @org.jetbrains.annotations.NotNull java.lang.String x) {
        this.jsiiCall("addPrefix", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(x, "x is required") });
    }

    /**
     * Register this state as part of the given graph.
     * <p>
     * Don't call this. It will be called automatically when you work
     * with states normally.
     * <p>
     * @param graph This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void bindToGraph(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.StateGraph graph) {
        this.jsiiCall("bindToGraph", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(graph, "graph is required") });
    }

    /**
     * Make the indicated state the default choice transition of this state.
     * <p>
     * @param def This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void makeDefault(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.State def) {
        this.jsiiCall("makeDefault", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(def, "def is required") });
    }

    /**
     * Make the indicated state the default transition of this state.
     * <p>
     * @param next This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void makeNext(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.State next) {
        this.jsiiCall("makeNext", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(next, "next is required") });
    }

    /**
     * Render parallel branches in ASL JSON format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.Object renderBranches() {
        return this.jsiiCall("renderBranches", java.lang.Object.class);
    }

    /**
     * Render the choices in ASL JSON format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.Object renderChoices() {
        return this.jsiiCall("renderChoices", java.lang.Object.class);
    }

    /**
     * Render InputPath/Parameters/OutputPath in ASL JSON format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.Object renderInputOutput() {
        return this.jsiiCall("renderInputOutput", java.lang.Object.class);
    }

    /**
     * Render map iterator in ASL JSON format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.Object renderIterator() {
        return this.jsiiCall("renderIterator", java.lang.Object.class);
    }

    /**
     * Render the default next state in ASL JSON format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.Object renderNextEnd() {
        return this.jsiiCall("renderNextEnd", java.lang.Object.class);
    }

    /**
     * Render error recovery options in ASL JSON format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.Object renderRetryCatch() {
        return this.jsiiCall("renderRetryCatch", java.lang.Object.class);
    }

    /**
     * Render the state as JSON.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull com.fasterxml.jackson.databind.node.ObjectNode toStateJson();

    /**
     * Called whenever this state is bound to a graph.
     * <p>
     * Can be overridden by subclasses.
     * <p>
     * @param graph This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void whenBoundToGraph(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.StateGraph graph) {
        this.jsiiCall("whenBoundToGraph", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(graph, "graph is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.stepfunctions.StateGraph> getBranches() {
        return java.util.Collections.unmodifiableList(this.jsiiGet("branches", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.StateGraph.class))));
    }

    /**
     * Continuable states of this Chainable.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.stepfunctions.INextable> getEndStates();

    /**
     * Descriptive identifier for this chainable.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getId() {
        return this.jsiiGet("id", java.lang.String.class);
    }

    /**
     * First state of this Chainable.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.State getStartState() {
        return this.jsiiGet("startState", software.amazon.awscdk.services.stepfunctions.State.class);
    }

    /**
     * Tokenized string that evaluates to the state's ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getStateId() {
        return this.jsiiGet("stateId", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable java.lang.String getComment() {
        return this.jsiiGet("comment", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable java.lang.String getInputPath() {
        return this.jsiiGet("inputPath", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable java.lang.String getOutputPath() {
        return this.jsiiGet("outputPath", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable com.fasterxml.jackson.databind.node.ObjectNode getParameters() {
        return this.jsiiGet("parameters", com.fasterxml.jackson.databind.node.ObjectNode.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable java.lang.String getResultPath() {
        return this.jsiiGet("resultPath", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.State getDefaultChoice() {
        return this.jsiiGet("defaultChoice", software.amazon.awscdk.services.stepfunctions.State.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void setDefaultChoice(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.State value) {
        this.jsiiSet("defaultChoice", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.StateGraph getIteration() {
        return this.jsiiGet("iteration", software.amazon.awscdk.services.stepfunctions.StateGraph.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void setIteration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.StateGraph value) {
        this.jsiiSet("iteration", value);
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.awscdk.services.stepfunctions.State {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The chainable end state(s) of this chainable.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.stepfunctions.INextable> getEndStates() {
            return java.util.Collections.unmodifiableList(this.jsiiGet("endStates", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.INextable.class))));
        }

        /**
         * Descriptive identifier for this chainable.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull java.lang.String getId() {
            return this.jsiiGet("id", java.lang.String.class);
        }

        /**
         * The start state of this chainable.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.State getStartState() {
            return this.jsiiGet("startState", software.amazon.awscdk.services.stepfunctions.State.class);
        }

        /**
         * The construct tree node for this construct.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ConstructNode getNode() {
            return this.jsiiGet("node", software.amazon.awscdk.core.ConstructNode.class);
        }

        /**
         * Render the state as JSON.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull com.fasterxml.jackson.databind.node.ObjectNode toStateJson() {
            return this.jsiiCall("toStateJson", com.fasterxml.jackson.databind.node.ObjectNode.class);
        }
    }
}
