package software.amazon.awscdk.services.stepfunctions;

/**
 * A Condition for use in a Choice state branch.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:13.482Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.$Module.class, fqn = "@aws-cdk/aws-stepfunctions.Condition")
public abstract class Condition extends software.amazon.jsii.JsiiObject {

    protected Condition(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Condition(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    protected Condition() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Combine two or more conditions with a logical AND.
     * <p>
     * @param conditions This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition and(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition... conditions) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "and", software.amazon.awscdk.services.stepfunctions.Condition.class, java.util.Arrays.<Object>stream(conditions).toArray(Object[]::new));
    }

    /**
     * Matches if a boolean field has the given value.
     * <p>
     * @param variable This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition booleanEquals(final @org.jetbrains.annotations.NotNull java.lang.String variable, final @org.jetbrains.annotations.NotNull java.lang.Boolean value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "booleanEquals", software.amazon.awscdk.services.stepfunctions.Condition.class, new Object[] { java.util.Objects.requireNonNull(variable, "variable is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Negate a condition.
     * <p>
     * @param condition This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition not(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition condition) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "not", software.amazon.awscdk.services.stepfunctions.Condition.class, new Object[] { java.util.Objects.requireNonNull(condition, "condition is required") });
    }

    /**
     * Matches if a numeric field has the given value.
     * <p>
     * @param variable This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition numberEquals(final @org.jetbrains.annotations.NotNull java.lang.String variable, final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "numberEquals", software.amazon.awscdk.services.stepfunctions.Condition.class, new Object[] { java.util.Objects.requireNonNull(variable, "variable is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Matches if a numeric field is greater than the given value.
     * <p>
     * @param variable This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition numberGreaterThan(final @org.jetbrains.annotations.NotNull java.lang.String variable, final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "numberGreaterThan", software.amazon.awscdk.services.stepfunctions.Condition.class, new Object[] { java.util.Objects.requireNonNull(variable, "variable is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Matches if a numeric field is greater than or equal to the given value.
     * <p>
     * @param variable This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition numberGreaterThanEquals(final @org.jetbrains.annotations.NotNull java.lang.String variable, final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "numberGreaterThanEquals", software.amazon.awscdk.services.stepfunctions.Condition.class, new Object[] { java.util.Objects.requireNonNull(variable, "variable is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Matches if a numeric field is less than the given value.
     * <p>
     * @param variable This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition numberLessThan(final @org.jetbrains.annotations.NotNull java.lang.String variable, final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "numberLessThan", software.amazon.awscdk.services.stepfunctions.Condition.class, new Object[] { java.util.Objects.requireNonNull(variable, "variable is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Matches if a numeric field is less than or equal to the given value.
     * <p>
     * @param variable This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition numberLessThanEquals(final @org.jetbrains.annotations.NotNull java.lang.String variable, final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "numberLessThanEquals", software.amazon.awscdk.services.stepfunctions.Condition.class, new Object[] { java.util.Objects.requireNonNull(variable, "variable is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Combine two or more conditions with a logical OR.
     * <p>
     * @param conditions This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition or(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition... conditions) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "or", software.amazon.awscdk.services.stepfunctions.Condition.class, java.util.Arrays.<Object>stream(conditions).toArray(Object[]::new));
    }

    /**
     * Matches if a string field has the given value.
     * <p>
     * @param variable This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition stringEquals(final @org.jetbrains.annotations.NotNull java.lang.String variable, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "stringEquals", software.amazon.awscdk.services.stepfunctions.Condition.class, new Object[] { java.util.Objects.requireNonNull(variable, "variable is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Matches if a string field sorts after a given value.
     * <p>
     * @param variable This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition stringGreaterThan(final @org.jetbrains.annotations.NotNull java.lang.String variable, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "stringGreaterThan", software.amazon.awscdk.services.stepfunctions.Condition.class, new Object[] { java.util.Objects.requireNonNull(variable, "variable is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Matches if a string field sorts after or equal to a given value.
     * <p>
     * @param variable This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition stringGreaterThanEquals(final @org.jetbrains.annotations.NotNull java.lang.String variable, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "stringGreaterThanEquals", software.amazon.awscdk.services.stepfunctions.Condition.class, new Object[] { java.util.Objects.requireNonNull(variable, "variable is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Matches if a string field sorts before a given value.
     * <p>
     * @param variable This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition stringLessThan(final @org.jetbrains.annotations.NotNull java.lang.String variable, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "stringLessThan", software.amazon.awscdk.services.stepfunctions.Condition.class, new Object[] { java.util.Objects.requireNonNull(variable, "variable is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Matches if a string field sorts equal to or before a given value.
     * <p>
     * @param variable This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition stringLessThanEquals(final @org.jetbrains.annotations.NotNull java.lang.String variable, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "stringLessThanEquals", software.amazon.awscdk.services.stepfunctions.Condition.class, new Object[] { java.util.Objects.requireNonNull(variable, "variable is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Matches if a timestamp field is the same time as the given timestamp.
     * <p>
     * @param variable This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition timestampEquals(final @org.jetbrains.annotations.NotNull java.lang.String variable, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "timestampEquals", software.amazon.awscdk.services.stepfunctions.Condition.class, new Object[] { java.util.Objects.requireNonNull(variable, "variable is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Matches if a timestamp field is after the given timestamp.
     * <p>
     * @param variable This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition timestampGreaterThan(final @org.jetbrains.annotations.NotNull java.lang.String variable, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "timestampGreaterThan", software.amazon.awscdk.services.stepfunctions.Condition.class, new Object[] { java.util.Objects.requireNonNull(variable, "variable is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Matches if a timestamp field is after or equal to the given timestamp.
     * <p>
     * @param variable This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition timestampGreaterThanEquals(final @org.jetbrains.annotations.NotNull java.lang.String variable, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "timestampGreaterThanEquals", software.amazon.awscdk.services.stepfunctions.Condition.class, new Object[] { java.util.Objects.requireNonNull(variable, "variable is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Matches if a timestamp field is before the given timestamp.
     * <p>
     * @param variable This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition timestampLessThan(final @org.jetbrains.annotations.NotNull java.lang.String variable, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "timestampLessThan", software.amazon.awscdk.services.stepfunctions.Condition.class, new Object[] { java.util.Objects.requireNonNull(variable, "variable is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Matches if a timestamp field is before or equal to the given timestamp.
     * <p>
     * @param variable This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Condition timestampLessThanEquals(final @org.jetbrains.annotations.NotNull java.lang.String variable, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Condition.class, "timestampLessThanEquals", software.amazon.awscdk.services.stepfunctions.Condition.class, new Object[] { java.util.Objects.requireNonNull(variable, "variable is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Render Amazon States Language JSON for the condition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull java.lang.Object renderCondition();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.awscdk.services.stepfunctions.Condition {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Render Amazon States Language JSON for the condition.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull java.lang.Object renderCondition() {
            return this.jsiiCall("renderCondition", java.lang.Object.class);
        }
    }
}
