/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import software.amazon.awscdk.Construct;
import software.amazon.awscdk.IConstruct;
import software.amazon.awscdk.services.stepfunctions.;
import software.amazon.awscdk.services.stepfunctions.Condition;
import software.amazon.awscdk.services.stepfunctions.FindStateOptions;
import software.amazon.awscdk.services.stepfunctions.IChainable;
import software.amazon.awscdk.services.stepfunctions.INextable;
import software.amazon.awscdk.services.stepfunctions.StateGraph;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiObject;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-stepfunctions.State")
public abstract class State
extends Construct
implements IChainable {
    protected State(JsiiObject.InitializationMode mode) {
        super(mode);
    }

    public static List<INextable> filterNextables(List<State> states) {
        return (List)JsiiObject.jsiiStaticCall(State.class, (String)"filterNextables", List.class, (Object[])Stream.of(Objects.requireNonNull(states, "states is required")).toArray());
    }

    public static List<State> findReachableEndStates(State start, @Nullable FindStateOptions options) {
        return (List)JsiiObject.jsiiStaticCall(State.class, (String)"findReachableEndStates", List.class, (Object[])Stream.concat(Stream.of(Objects.requireNonNull(start, "start is required")), Stream.of(options)).toArray());
    }

    public static List<State> findReachableEndStates(State start) {
        return (List)JsiiObject.jsiiStaticCall(State.class, (String)"findReachableEndStates", List.class, (Object[])Stream.of(Objects.requireNonNull(start, "start is required")).toArray());
    }

    public static void prefixStates(IConstruct root, String prefix) {
        JsiiObject.jsiiStaticCall(State.class, (String)"prefixStates", Void.class, (Object[])Stream.concat(Stream.of(Objects.requireNonNull(root, "root is required")), Stream.of(Objects.requireNonNull(prefix, "prefix is required"))).toArray());
    }

    protected void addBranch(StateGraph branch) {
        this.jsiiCall("addBranch", Void.class, Stream.of(Objects.requireNonNull(branch, "branch is required")).toArray());
    }

    protected void addChoice(Condition condition, State next) {
        this.jsiiCall("addChoice", Void.class, Stream.concat(Stream.of(Objects.requireNonNull(condition, "condition is required")), Stream.of(Objects.requireNonNull(next, "next is required"))).toArray());
    }

    public void addPrefix(String x) {
        this.jsiiCall("addPrefix", Void.class, Stream.of(Objects.requireNonNull(x, "x is required")).toArray());
    }

    public void bindToGraph(StateGraph graph) {
        this.jsiiCall("bindToGraph", Void.class, Stream.of(Objects.requireNonNull(graph, "graph is required")).toArray());
    }

    protected void makeDefault(State def) {
        this.jsiiCall("makeDefault", Void.class, Stream.of(Objects.requireNonNull(def, "def is required")).toArray());
    }

    protected void makeNext(State next) {
        this.jsiiCall("makeNext", Void.class, Stream.of(Objects.requireNonNull(next, "next is required")).toArray());
    }

    protected void onBindToGraph(StateGraph graph) {
        this.jsiiCall("onBindToGraph", Void.class, Stream.of(Objects.requireNonNull(graph, "graph is required")).toArray());
    }

    protected Object renderBranches() {
        return this.jsiiCall("renderBranches", Object.class, new Object[0]);
    }

    protected Object renderChoices() {
        return this.jsiiCall("renderChoices", Object.class, new Object[0]);
    }

    protected Object renderInputOutput() {
        return this.jsiiCall("renderInputOutput", Object.class, new Object[0]);
    }

    protected Object renderNextEnd() {
        return this.jsiiCall("renderNextEnd", Object.class, new Object[0]);
    }

    protected Object renderRetryCatch() {
        return this.jsiiCall("renderRetryCatch", Object.class, new Object[0]);
    }

    public abstract ObjectNode toStateJson();

    protected List<StateGraph> getBranches() {
        return (List)this.jsiiGet("branches", List.class);
    }

    @Override
    public List<INextable> getEndStates() {
        return (List)this.jsiiGet("endStates", List.class);
    }

    @Override
    public String getId() {
        return (String)this.jsiiGet("id", String.class);
    }

    @Override
    public State getStartState() {
        return (State)this.jsiiGet("startState", State.class);
    }

    public String getStateId() {
        return (String)this.jsiiGet("stateId", String.class);
    }

    @Nullable
    protected String getComment() {
        return (String)this.jsiiGet("comment", String.class);
    }

    @Nullable
    protected String getInputPath() {
        return (String)this.jsiiGet("inputPath", String.class);
    }

    @Nullable
    protected String getOutputPath() {
        return (String)this.jsiiGet("outputPath", String.class);
    }

    @Nullable
    protected ObjectNode getParameters() {
        return (ObjectNode)this.jsiiGet("parameters", ObjectNode.class);
    }

    @Nullable
    protected String getResultPath() {
        return (String)this.jsiiGet("resultPath", String.class);
    }

    @Nullable
    protected State getDefaultChoice() {
        return (State)this.jsiiGet("defaultChoice", State.class);
    }

    protected void setDefaultChoice(@Nullable State value) {
        this.jsiiSet("defaultChoice", value);
    }
}

