/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions.tasks;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.stepfunctions.ServiceIntegrationPattern;
import software.amazon.awscdk.services.stepfunctions.tasks.BatchStrategy;
import software.amazon.awscdk.services.stepfunctions.tasks.TransformInput;
import software.amazon.awscdk.services.stepfunctions.tasks.TransformOutput;
import software.amazon.awscdk.services.stepfunctions.tasks.TransformResources;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface SagemakerTransformProps
extends JsiiSerializable {
    public String getModelName();

    public TransformInput getTransformInput();

    public String getTransformJobName();

    public TransformOutput getTransformOutput();

    public BatchStrategy getBatchStrategy();

    public Map<String, Object> getEnvironment();

    public ServiceIntegrationPattern getIntegrationPattern();

    public Number getMaxConcurrentTransforms();

    public Number getMaxPayloadInMb();

    public IRole getRole();

    public Map<String, Object> getTags();

    public TransformResources getTransformResources();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _modelName;
        private TransformInput _transformInput;
        private String _transformJobName;
        private TransformOutput _transformOutput;
        @Nullable
        private BatchStrategy _batchStrategy;
        @Nullable
        private Map<String, Object> _environment;
        @Nullable
        private ServiceIntegrationPattern _integrationPattern;
        @Nullable
        private Number _maxConcurrentTransforms;
        @Nullable
        private Number _maxPayloadInMb;
        @Nullable
        private IRole _role;
        @Nullable
        private Map<String, Object> _tags;
        @Nullable
        private TransformResources _transformResources;

        public Builder withModelName(String value) {
            this._modelName = Objects.requireNonNull(value, "modelName is required");
            return this;
        }

        public Builder withTransformInput(TransformInput value) {
            this._transformInput = Objects.requireNonNull(value, "transformInput is required");
            return this;
        }

        public Builder withTransformJobName(String value) {
            this._transformJobName = Objects.requireNonNull(value, "transformJobName is required");
            return this;
        }

        public Builder withTransformOutput(TransformOutput value) {
            this._transformOutput = Objects.requireNonNull(value, "transformOutput is required");
            return this;
        }

        public Builder withBatchStrategy(@Nullable BatchStrategy value) {
            this._batchStrategy = value;
            return this;
        }

        public Builder withEnvironment(@Nullable Map<String, Object> value) {
            this._environment = value;
            return this;
        }

        public Builder withIntegrationPattern(@Nullable ServiceIntegrationPattern value) {
            this._integrationPattern = value;
            return this;
        }

        public Builder withMaxConcurrentTransforms(@Nullable Number value) {
            this._maxConcurrentTransforms = value;
            return this;
        }

        public Builder withMaxPayloadInMb(@Nullable Number value) {
            this._maxPayloadInMb = value;
            return this;
        }

        public Builder withRole(@Nullable IRole value) {
            this._role = value;
            return this;
        }

        public Builder withTags(@Nullable Map<String, Object> value) {
            this._tags = value;
            return this;
        }

        public Builder withTransformResources(@Nullable TransformResources value) {
            this._transformResources = value;
            return this;
        }

        public SagemakerTransformProps build() {
            return new SagemakerTransformProps(){
                private final String $modelName;
                private final TransformInput $transformInput;
                private final String $transformJobName;
                private final TransformOutput $transformOutput;
                @Nullable
                private final BatchStrategy $batchStrategy;
                @Nullable
                private final Map<String, Object> $environment;
                @Nullable
                private final ServiceIntegrationPattern $integrationPattern;
                @Nullable
                private final Number $maxConcurrentTransforms;
                @Nullable
                private final Number $maxPayloadInMb;
                @Nullable
                private final IRole $role;
                @Nullable
                private final Map<String, Object> $tags;
                @Nullable
                private final TransformResources $transformResources;
                {
                    this.$modelName = Objects.requireNonNull(_modelName, "modelName is required");
                    this.$transformInput = Objects.requireNonNull(_transformInput, "transformInput is required");
                    this.$transformJobName = Objects.requireNonNull(_transformJobName, "transformJobName is required");
                    this.$transformOutput = Objects.requireNonNull(_transformOutput, "transformOutput is required");
                    this.$batchStrategy = _batchStrategy;
                    this.$environment = _environment;
                    this.$integrationPattern = _integrationPattern;
                    this.$maxConcurrentTransforms = _maxConcurrentTransforms;
                    this.$maxPayloadInMb = _maxPayloadInMb;
                    this.$role = _role;
                    this.$tags = _tags;
                    this.$transformResources = _transformResources;
                }

                @Override
                public String getModelName() {
                    return this.$modelName;
                }

                @Override
                public TransformInput getTransformInput() {
                    return this.$transformInput;
                }

                @Override
                public String getTransformJobName() {
                    return this.$transformJobName;
                }

                @Override
                public TransformOutput getTransformOutput() {
                    return this.$transformOutput;
                }

                @Override
                public BatchStrategy getBatchStrategy() {
                    return this.$batchStrategy;
                }

                @Override
                public Map<String, Object> getEnvironment() {
                    return this.$environment;
                }

                @Override
                public ServiceIntegrationPattern getIntegrationPattern() {
                    return this.$integrationPattern;
                }

                @Override
                public Number getMaxConcurrentTransforms() {
                    return this.$maxConcurrentTransforms;
                }

                @Override
                public Number getMaxPayloadInMb() {
                    return this.$maxPayloadInMb;
                }

                @Override
                public IRole getRole() {
                    return this.$role;
                }

                @Override
                public Map<String, Object> getTags() {
                    return this.$tags;
                }

                @Override
                public TransformResources getTransformResources() {
                    return this.$transformResources;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("modelName", om.valueToTree((Object)this.getModelName()));
                    obj.set("transformInput", om.valueToTree((Object)this.getTransformInput()));
                    obj.set("transformJobName", om.valueToTree((Object)this.getTransformJobName()));
                    obj.set("transformOutput", om.valueToTree((Object)this.getTransformOutput()));
                    if (this.getBatchStrategy() != null) {
                        obj.set("batchStrategy", om.valueToTree((Object)this.getBatchStrategy()));
                    }
                    if (this.getEnvironment() != null) {
                        obj.set("environment", om.valueToTree(this.getEnvironment()));
                    }
                    if (this.getIntegrationPattern() != null) {
                        obj.set("integrationPattern", om.valueToTree((Object)this.getIntegrationPattern()));
                    }
                    if (this.getMaxConcurrentTransforms() != null) {
                        obj.set("maxConcurrentTransforms", om.valueToTree((Object)this.getMaxConcurrentTransforms()));
                    }
                    if (this.getMaxPayloadInMb() != null) {
                        obj.set("maxPayloadInMB", om.valueToTree((Object)this.getMaxPayloadInMb()));
                    }
                    if (this.getRole() != null) {
                        obj.set("role", om.valueToTree((Object)this.getRole()));
                    }
                    if (this.getTags() != null) {
                        obj.set("tags", om.valueToTree(this.getTags()));
                    }
                    if (this.getTransformResources() != null) {
                        obj.set("transformResources", om.valueToTree((Object)this.getTransformResources()));
                    }
                    return obj;
                }
            };
        }
    }
}

