/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions.tasks;

import software.amazon.awscdk.services.kms.Key;
import software.amazon.awscdk.services.stepfunctions.tasks.AssembleWith;
import software.amazon.awscdk.services.stepfunctions.tasks.TransformOutput;
import software.amazon.jsii.JsiiSerializable;

public interface TransformOutput
extends JsiiSerializable {
    public String getS3OutputPath();

    public String getAccept();

    public AssembleWith getAssembleWith();

    public Key getEncryptionKey();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String s3OutputPath;
        private String accept;
        private AssembleWith assembleWith;
        private Key encryptionKey;

        public Builder s3OutputPath(String s3OutputPath) {
            this.s3OutputPath = s3OutputPath;
            return this;
        }

        public Builder accept(String accept) {
            this.accept = accept;
            return this;
        }

        public Builder assembleWith(AssembleWith assembleWith) {
            this.assembleWith = assembleWith;
            return this;
        }

        public Builder encryptionKey(Key encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public TransformOutput build() {
            return new Jsii.Proxy(this.s3OutputPath, this.accept, this.assembleWith, this.encryptionKey, null);
        }
    }
}

