/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions.tasks;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.stepfunctions.tasks.S3DataDistributionType;
import software.amazon.awscdk.services.stepfunctions.tasks.S3DataType;
import software.amazon.awscdk.services.stepfunctions.tasks.S3Location;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface S3DataSource
extends JsiiSerializable {
    public S3Location getS3Location();

    public List<String> getAttributeNames();

    public S3DataDistributionType getS3DataDistributionType();

    public S3DataType getS3DataType();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private S3Location _s3Location;
        @Nullable
        private List<String> _attributeNames;
        @Nullable
        private S3DataDistributionType _s3DataDistributionType;
        @Nullable
        private S3DataType _s3DataType;

        public Builder withS3Location(S3Location value) {
            this._s3Location = Objects.requireNonNull(value, "s3Location is required");
            return this;
        }

        public Builder withAttributeNames(@Nullable List<String> value) {
            this._attributeNames = value;
            return this;
        }

        public Builder withS3DataDistributionType(@Nullable S3DataDistributionType value) {
            this._s3DataDistributionType = value;
            return this;
        }

        public Builder withS3DataType(@Nullable S3DataType value) {
            this._s3DataType = value;
            return this;
        }

        public S3DataSource build() {
            return new S3DataSource(){
                private final S3Location $s3Location;
                @Nullable
                private final List<String> $attributeNames;
                @Nullable
                private final S3DataDistributionType $s3DataDistributionType;
                @Nullable
                private final S3DataType $s3DataType;
                {
                    this.$s3Location = Objects.requireNonNull(_s3Location, "s3Location is required");
                    this.$attributeNames = _attributeNames;
                    this.$s3DataDistributionType = _s3DataDistributionType;
                    this.$s3DataType = _s3DataType;
                }

                @Override
                public S3Location getS3Location() {
                    return this.$s3Location;
                }

                @Override
                public List<String> getAttributeNames() {
                    return this.$attributeNames;
                }

                @Override
                public S3DataDistributionType getS3DataDistributionType() {
                    return this.$s3DataDistributionType;
                }

                @Override
                public S3DataType getS3DataType() {
                    return this.$s3DataType;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("s3Location", om.valueToTree((Object)this.getS3Location()));
                    if (this.getAttributeNames() != null) {
                        obj.set("attributeNames", om.valueToTree(this.getAttributeNames()));
                    }
                    if (this.getS3DataDistributionType() != null) {
                        obj.set("s3DataDistributionType", om.valueToTree((Object)this.getS3DataDistributionType()));
                    }
                    if (this.getS3DataType() != null) {
                        obj.set("s3DataType", om.valueToTree((Object)this.getS3DataType()));
                    }
                    return obj;
                }
            };
        }
    }
}

