/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ssm;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.ssm.;
import software.amazon.awscdk.services.ssm.CfnResourceDataSync;
import software.amazon.awscdk.services.ssm.CfnResourceDataSyncProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-ssm.CfnResourceDataSync")
public class CfnResourceDataSync
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnResourceDataSync.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnResourceDataSync(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnResourceDataSync(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnResourceDataSync(@NotNull Construct scope, @NotNull String id, @NotNull CfnResourceDataSyncProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void inspect(@NotNull TreeInspector inspector) {
        this.jsiiCall("inspect", NativeType.VOID, new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)this.jsiiCall("renderProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("cfnProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public String getSyncName() {
        return (String)this.jsiiGet("syncName", String.class);
    }

    public void setSyncName(@NotNull String value) {
        this.jsiiSet("syncName", Objects.requireNonNull(value, "syncName is required"));
    }

    @Nullable
    public String getBucketName() {
        return (String)this.jsiiGet("bucketName", String.class);
    }

    public void setBucketName(@Nullable String value) {
        this.jsiiSet("bucketName", value);
    }

    @Nullable
    public String getBucketPrefix() {
        return (String)this.jsiiGet("bucketPrefix", String.class);
    }

    public void setBucketPrefix(@Nullable String value) {
        this.jsiiSet("bucketPrefix", value);
    }

    @Nullable
    public String getBucketRegion() {
        return (String)this.jsiiGet("bucketRegion", String.class);
    }

    public void setBucketRegion(@Nullable String value) {
        this.jsiiSet("bucketRegion", value);
    }

    @Nullable
    public String getKmsKeyArn() {
        return (String)this.jsiiGet("kmsKeyArn", String.class);
    }

    public void setKmsKeyArn(@Nullable String value) {
        this.jsiiSet("kmsKeyArn", value);
    }

    @Nullable
    public Object getS3Destination() {
        return this.jsiiGet("s3Destination", Object.class);
    }

    public void setS3Destination(@Nullable IResolvable value) {
        this.jsiiSet("s3Destination", value);
    }

    public void setS3Destination(@Nullable S3DestinationProperty value) {
        this.jsiiSet("s3Destination", value);
    }

    @Nullable
    public String getSyncFormat() {
        return (String)this.jsiiGet("syncFormat", String.class);
    }

    public void setSyncFormat(@Nullable String value) {
        this.jsiiSet("syncFormat", value);
    }

    @Nullable
    public Object getSyncSource() {
        return this.jsiiGet("syncSource", Object.class);
    }

    public void setSyncSource(@Nullable IResolvable value) {
        this.jsiiSet("syncSource", value);
    }

    public void setSyncSource(@Nullable SyncSourceProperty value) {
        this.jsiiSet("syncSource", value);
    }

    @Nullable
    public String getSyncType() {
        return (String)this.jsiiGet("syncType", String.class);
    }

    public void setSyncType(@Nullable String value) {
        this.jsiiSet("syncType", value);
    }

    public static final class Builder {
        private final Construct scope;
        private final String id;
        private final CfnResourceDataSyncProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnResourceDataSyncProps.Builder();
        }

        public Builder syncName(String syncName) {
            this.props.syncName(syncName);
            return this;
        }

        public Builder bucketName(String bucketName) {
            this.props.bucketName(bucketName);
            return this;
        }

        public Builder bucketPrefix(String bucketPrefix) {
            this.props.bucketPrefix(bucketPrefix);
            return this;
        }

        public Builder bucketRegion(String bucketRegion) {
            this.props.bucketRegion(bucketRegion);
            return this;
        }

        public Builder kmsKeyArn(String kmsKeyArn) {
            this.props.kmsKeyArn(kmsKeyArn);
            return this;
        }

        public Builder s3Destination(IResolvable s3Destination) {
            this.props.s3Destination(s3Destination);
            return this;
        }

        public Builder s3Destination(S3DestinationProperty s3Destination) {
            this.props.s3Destination(s3Destination);
            return this;
        }

        public Builder syncFormat(String syncFormat) {
            this.props.syncFormat(syncFormat);
            return this;
        }

        public Builder syncSource(IResolvable syncSource) {
            this.props.syncSource(syncSource);
            return this;
        }

        public Builder syncSource(SyncSourceProperty syncSource) {
            this.props.syncSource(syncSource);
            return this;
        }

        public Builder syncType(String syncType) {
            this.props.syncType(syncType);
            return this;
        }

        public CfnResourceDataSync build() {
            return new CfnResourceDataSync(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ssm.CfnResourceDataSync.SyncSourceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SyncSourceProperty
    extends JsiiSerializable {
        @NotNull
        public List<String> getSourceRegions();

        @NotNull
        public String getSourceType();

        @Nullable
        default public Object getAwsOrganizationsSource() {
            return null;
        }

        @Nullable
        default public Object getIncludeFutureRegions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private List<String> sourceRegions;
            private String sourceType;
            private Object awsOrganizationsSource;
            private Object includeFutureRegions;

            public Builder sourceRegions(List<String> sourceRegions) {
                this.sourceRegions = sourceRegions;
                return this;
            }

            public Builder sourceType(String sourceType) {
                this.sourceType = sourceType;
                return this;
            }

            public Builder awsOrganizationsSource(IResolvable awsOrganizationsSource) {
                this.awsOrganizationsSource = awsOrganizationsSource;
                return this;
            }

            public Builder awsOrganizationsSource(AwsOrganizationsSourceProperty awsOrganizationsSource) {
                this.awsOrganizationsSource = awsOrganizationsSource;
                return this;
            }

            public Builder includeFutureRegions(Boolean includeFutureRegions) {
                this.includeFutureRegions = includeFutureRegions;
                return this;
            }

            public Builder includeFutureRegions(IResolvable includeFutureRegions) {
                this.includeFutureRegions = includeFutureRegions;
                return this;
            }

            public SyncSourceProperty build() {
                return new Jsii.Proxy(this.sourceRegions, this.sourceType, this.awsOrganizationsSource, this.includeFutureRegions, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ssm.CfnResourceDataSync.S3DestinationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3DestinationProperty
    extends JsiiSerializable {
        @NotNull
        public String getBucketName();

        @NotNull
        public String getBucketRegion();

        @NotNull
        public String getSyncFormat();

        @Nullable
        default public String getBucketPrefix() {
            return null;
        }

        @Nullable
        default public String getKmsKeyArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String bucketName;
            private String bucketRegion;
            private String syncFormat;
            private String bucketPrefix;
            private String kmsKeyArn;

            public Builder bucketName(String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            public Builder bucketRegion(String bucketRegion) {
                this.bucketRegion = bucketRegion;
                return this;
            }

            public Builder syncFormat(String syncFormat) {
                this.syncFormat = syncFormat;
                return this;
            }

            public Builder bucketPrefix(String bucketPrefix) {
                this.bucketPrefix = bucketPrefix;
                return this;
            }

            public Builder kmsKeyArn(String kmsKeyArn) {
                this.kmsKeyArn = kmsKeyArn;
                return this;
            }

            public S3DestinationProperty build() {
                return new Jsii.Proxy(this.bucketName, this.bucketRegion, this.syncFormat, this.bucketPrefix, this.kmsKeyArn, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ssm.CfnResourceDataSync.AwsOrganizationsSourceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AwsOrganizationsSourceProperty
    extends JsiiSerializable {
        @NotNull
        public String getOrganizationSourceType();

        @Nullable
        default public List<String> getOrganizationalUnits() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String organizationSourceType;
            private List<String> organizationalUnits;

            public Builder organizationSourceType(String organizationSourceType) {
                this.organizationSourceType = organizationSourceType;
                return this;
            }

            public Builder organizationalUnits(List<String> organizationalUnits) {
                this.organizationalUnits = organizationalUnits;
                return this;
            }

            public AwsOrganizationsSourceProperty build() {
                return new Jsii.Proxy(this.organizationSourceType, this.organizationalUnits, null);
            }
        }
    }
}

