/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ssm.cloudformation;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import software.amazon.awscdk.Token;
import software.amazon.awscdk.services.ssm.cloudformation.MaintenanceWindowTaskResource;
import software.amazon.awscdk.services.ssm.cloudformation.MaintenanceWindowTaskResourceProps;
import software.amazon.jsii.JsiiSerializable;

public interface MaintenanceWindowTaskResourceProps
extends JsiiSerializable {
    public Object getMaxConcurrency();

    public void setMaxConcurrency(String var1);

    public void setMaxConcurrency(Token var1);

    public Object getMaxErrors();

    public void setMaxErrors(String var1);

    public void setMaxErrors(Token var1);

    public Object getPriority();

    public void setPriority(Number var1);

    public void setPriority(Token var1);

    public Object getServiceRoleArn();

    public void setServiceRoleArn(String var1);

    public void setServiceRoleArn(Token var1);

    public Object getTargets();

    public void setTargets(Token var1);

    public void setTargets(List<Object> var1);

    public Object getTaskArn();

    public void setTaskArn(String var1);

    public void setTaskArn(Token var1);

    public Object getTaskType();

    public void setTaskType(String var1);

    public void setTaskType(Token var1);

    public Object getDescription();

    public void setDescription(String var1);

    public void setDescription(Token var1);

    public Object getLoggingInfo();

    public void setLoggingInfo(Token var1);

    public void setLoggingInfo(MaintenanceWindowTaskResource.LoggingInfoProperty var1);

    public Object getMaintenanceWindowTaskName();

    public void setMaintenanceWindowTaskName(String var1);

    public void setMaintenanceWindowTaskName(Token var1);

    public Object getTaskInvocationParameters();

    public void setTaskInvocationParameters(Token var1);

    public void setTaskInvocationParameters(MaintenanceWindowTaskResource.TaskInvocationParametersProperty var1);

    public Object getTaskParameters();

    public void setTaskParameters(ObjectNode var1);

    public void setTaskParameters(Token var1);

    public Object getWindowId();

    public void setWindowId(String var1);

    public void setWindowId(Token var1);

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        public MaxErrorsStep withMaxConcurrency(String value) {
            return new FullBuilder().withMaxConcurrency(value);
        }

        public MaxErrorsStep withMaxConcurrency(Token value) {
            return new FullBuilder().withMaxConcurrency(value);
        }

        final class FullBuilder
        implements MaxErrorsStep,
        PriorityStep,
        ServiceRoleArnStep,
        TargetsStep,
        TaskArnStep,
        TaskTypeStep,
        Build {
            private Jsii.Pojo instance = new Jsii.Pojo();

            FullBuilder() {
            }

            public MaxErrorsStep withMaxConcurrency(String value) {
                Objects.requireNonNull(value, "MaintenanceWindowTaskResourceProps#maxConcurrency is required");
                this.instance._maxConcurrency = value;
                return this;
            }

            public MaxErrorsStep withMaxConcurrency(Token value) {
                Objects.requireNonNull(value, "MaintenanceWindowTaskResourceProps#maxConcurrency is required");
                this.instance._maxConcurrency = value;
                return this;
            }

            @Override
            public PriorityStep withMaxErrors(String value) {
                Objects.requireNonNull(value, "MaintenanceWindowTaskResourceProps#maxErrors is required");
                this.instance._maxErrors = value;
                return this;
            }

            @Override
            public PriorityStep withMaxErrors(Token value) {
                Objects.requireNonNull(value, "MaintenanceWindowTaskResourceProps#maxErrors is required");
                this.instance._maxErrors = value;
                return this;
            }

            @Override
            public ServiceRoleArnStep withPriority(Number value) {
                Objects.requireNonNull(value, "MaintenanceWindowTaskResourceProps#priority is required");
                this.instance._priority = value;
                return this;
            }

            @Override
            public ServiceRoleArnStep withPriority(Token value) {
                Objects.requireNonNull(value, "MaintenanceWindowTaskResourceProps#priority is required");
                this.instance._priority = value;
                return this;
            }

            @Override
            public TargetsStep withServiceRoleArn(String value) {
                Objects.requireNonNull(value, "MaintenanceWindowTaskResourceProps#serviceRoleArn is required");
                this.instance._serviceRoleArn = value;
                return this;
            }

            @Override
            public TargetsStep withServiceRoleArn(Token value) {
                Objects.requireNonNull(value, "MaintenanceWindowTaskResourceProps#serviceRoleArn is required");
                this.instance._serviceRoleArn = value;
                return this;
            }

            @Override
            public TaskArnStep withTargets(Token value) {
                Objects.requireNonNull(value, "MaintenanceWindowTaskResourceProps#targets is required");
                this.instance._targets = value;
                return this;
            }

            @Override
            public TaskArnStep withTargets(List<Object> value) {
                Objects.requireNonNull(value, "MaintenanceWindowTaskResourceProps#targets is required");
                this.instance._targets = value;
                return this;
            }

            @Override
            public TaskTypeStep withTaskArn(String value) {
                Objects.requireNonNull(value, "MaintenanceWindowTaskResourceProps#taskArn is required");
                this.instance._taskArn = value;
                return this;
            }

            @Override
            public TaskTypeStep withTaskArn(Token value) {
                Objects.requireNonNull(value, "MaintenanceWindowTaskResourceProps#taskArn is required");
                this.instance._taskArn = value;
                return this;
            }

            @Override
            public Build withTaskType(String value) {
                Objects.requireNonNull(value, "MaintenanceWindowTaskResourceProps#taskType is required");
                this.instance._taskType = value;
                return this;
            }

            @Override
            public Build withTaskType(Token value) {
                Objects.requireNonNull(value, "MaintenanceWindowTaskResourceProps#taskType is required");
                this.instance._taskType = value;
                return this;
            }

            @Override
            public Build withDescription(String value) {
                this.instance._description = value;
                return this;
            }

            @Override
            public Build withDescription(Token value) {
                this.instance._description = value;
                return this;
            }

            @Override
            public Build withLoggingInfo(Token value) {
                this.instance._loggingInfo = value;
                return this;
            }

            @Override
            public Build withLoggingInfo(MaintenanceWindowTaskResource.LoggingInfoProperty value) {
                this.instance._loggingInfo = value;
                return this;
            }

            @Override
            public Build withMaintenanceWindowTaskName(String value) {
                this.instance._maintenanceWindowTaskName = value;
                return this;
            }

            @Override
            public Build withMaintenanceWindowTaskName(Token value) {
                this.instance._maintenanceWindowTaskName = value;
                return this;
            }

            @Override
            public Build withTaskInvocationParameters(Token value) {
                this.instance._taskInvocationParameters = value;
                return this;
            }

            @Override
            public Build withTaskInvocationParameters(MaintenanceWindowTaskResource.TaskInvocationParametersProperty value) {
                this.instance._taskInvocationParameters = value;
                return this;
            }

            @Override
            public Build withTaskParameters(ObjectNode value) {
                this.instance._taskParameters = value;
                return this;
            }

            @Override
            public Build withTaskParameters(Token value) {
                this.instance._taskParameters = value;
                return this;
            }

            @Override
            public Build withWindowId(String value) {
                this.instance._windowId = value;
                return this;
            }

            @Override
            public Build withWindowId(Token value) {
                this.instance._windowId = value;
                return this;
            }

            @Override
            public MaintenanceWindowTaskResourceProps build() {
                Jsii.Pojo result = this.instance;
                this.instance = new Jsii.Pojo();
                return result;
            }
        }

        public static interface Build {
            public MaintenanceWindowTaskResourceProps build();

            public Build withDescription(String var1);

            public Build withDescription(Token var1);

            public Build withLoggingInfo(Token var1);

            public Build withLoggingInfo(MaintenanceWindowTaskResource.LoggingInfoProperty var1);

            public Build withMaintenanceWindowTaskName(String var1);

            public Build withMaintenanceWindowTaskName(Token var1);

            public Build withTaskInvocationParameters(Token var1);

            public Build withTaskInvocationParameters(MaintenanceWindowTaskResource.TaskInvocationParametersProperty var1);

            public Build withTaskParameters(ObjectNode var1);

            public Build withTaskParameters(Token var1);

            public Build withWindowId(String var1);

            public Build withWindowId(Token var1);
        }

        public static interface TaskTypeStep {
            public Build withTaskType(String var1);

            public Build withTaskType(Token var1);
        }

        public static interface TaskArnStep {
            public TaskTypeStep withTaskArn(String var1);

            public TaskTypeStep withTaskArn(Token var1);
        }

        public static interface TargetsStep {
            public TaskArnStep withTargets(Token var1);

            public TaskArnStep withTargets(List<Object> var1);
        }

        public static interface ServiceRoleArnStep {
            public TargetsStep withServiceRoleArn(String var1);

            public TargetsStep withServiceRoleArn(Token var1);
        }

        public static interface PriorityStep {
            public ServiceRoleArnStep withPriority(Number var1);

            public ServiceRoleArnStep withPriority(Token var1);
        }

        public static interface MaxErrorsStep {
            public PriorityStep withMaxErrors(String var1);

            public PriorityStep withMaxErrors(Token var1);
        }
    }
}

