/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ssm;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.ssm.ParameterOptions;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface StringListParameterProps
extends JsiiSerializable,
ParameterOptions {
    public List<String> getStringListValue();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> _stringListValue;
        @Nullable
        private String _allowedPattern;
        @Nullable
        private String _description;
        @Nullable
        private String _parameterName;

        public Builder withStringListValue(List<String> value) {
            this._stringListValue = Objects.requireNonNull(value, "stringListValue is required");
            return this;
        }

        public Builder withAllowedPattern(@Nullable String value) {
            this._allowedPattern = value;
            return this;
        }

        public Builder withDescription(@Nullable String value) {
            this._description = value;
            return this;
        }

        public Builder withParameterName(@Nullable String value) {
            this._parameterName = value;
            return this;
        }

        public StringListParameterProps build() {
            return new StringListParameterProps(){
                private final List<String> $stringListValue;
                @Nullable
                private final String $allowedPattern;
                @Nullable
                private final String $description;
                @Nullable
                private final String $parameterName;
                {
                    this.$stringListValue = Objects.requireNonNull(_stringListValue, "stringListValue is required");
                    this.$allowedPattern = _allowedPattern;
                    this.$description = _description;
                    this.$parameterName = _parameterName;
                }

                @Override
                public List<String> getStringListValue() {
                    return this.$stringListValue;
                }

                @Override
                public String getAllowedPattern() {
                    return this.$allowedPattern;
                }

                @Override
                public String getDescription() {
                    return this.$description;
                }

                @Override
                public String getParameterName() {
                    return this.$parameterName;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("stringListValue", om.valueToTree(this.getStringListValue()));
                    if (this.getAllowedPattern() != null) {
                        obj.set("allowedPattern", om.valueToTree((Object)this.getAllowedPattern()));
                    }
                    if (this.getDescription() != null) {
                        obj.set("description", om.valueToTree((Object)this.getDescription()));
                    }
                    if (this.getParameterName() != null) {
                        obj.set("parameterName", om.valueToTree((Object)this.getParameterName()));
                    }
                    return obj;
                }
            };
        }
    }
}

