/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ssm;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface CfnResourceDataSyncProps
extends JsiiSerializable {
    public String getBucketName();

    public String getBucketRegion();

    public String getSyncFormat();

    public String getSyncName();

    public String getBucketPrefix();

    public String getKmsKeyArn();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _bucketName;
        private String _bucketRegion;
        private String _syncFormat;
        private String _syncName;
        @Nullable
        private String _bucketPrefix;
        @Nullable
        private String _kmsKeyArn;

        public Builder withBucketName(String value) {
            this._bucketName = Objects.requireNonNull(value, "bucketName is required");
            return this;
        }

        public Builder withBucketRegion(String value) {
            this._bucketRegion = Objects.requireNonNull(value, "bucketRegion is required");
            return this;
        }

        public Builder withSyncFormat(String value) {
            this._syncFormat = Objects.requireNonNull(value, "syncFormat is required");
            return this;
        }

        public Builder withSyncName(String value) {
            this._syncName = Objects.requireNonNull(value, "syncName is required");
            return this;
        }

        public Builder withBucketPrefix(@Nullable String value) {
            this._bucketPrefix = value;
            return this;
        }

        public Builder withKmsKeyArn(@Nullable String value) {
            this._kmsKeyArn = value;
            return this;
        }

        public CfnResourceDataSyncProps build() {
            return new CfnResourceDataSyncProps(){
                private final String $bucketName;
                private final String $bucketRegion;
                private final String $syncFormat;
                private final String $syncName;
                @Nullable
                private final String $bucketPrefix;
                @Nullable
                private final String $kmsKeyArn;
                {
                    this.$bucketName = Objects.requireNonNull(_bucketName, "bucketName is required");
                    this.$bucketRegion = Objects.requireNonNull(_bucketRegion, "bucketRegion is required");
                    this.$syncFormat = Objects.requireNonNull(_syncFormat, "syncFormat is required");
                    this.$syncName = Objects.requireNonNull(_syncName, "syncName is required");
                    this.$bucketPrefix = _bucketPrefix;
                    this.$kmsKeyArn = _kmsKeyArn;
                }

                @Override
                public String getBucketName() {
                    return this.$bucketName;
                }

                @Override
                public String getBucketRegion() {
                    return this.$bucketRegion;
                }

                @Override
                public String getSyncFormat() {
                    return this.$syncFormat;
                }

                @Override
                public String getSyncName() {
                    return this.$syncName;
                }

                @Override
                public String getBucketPrefix() {
                    return this.$bucketPrefix;
                }

                @Override
                public String getKmsKeyArn() {
                    return this.$kmsKeyArn;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("bucketName", om.valueToTree((Object)this.getBucketName()));
                    obj.set("bucketRegion", om.valueToTree((Object)this.getBucketRegion()));
                    obj.set("syncFormat", om.valueToTree((Object)this.getSyncFormat()));
                    obj.set("syncName", om.valueToTree((Object)this.getSyncName()));
                    if (this.getBucketPrefix() != null) {
                        obj.set("bucketPrefix", om.valueToTree((Object)this.getBucketPrefix()));
                    }
                    if (this.getKmsKeyArn() != null) {
                        obj.set("kmsKeyArn", om.valueToTree((Object)this.getKmsKeyArn()));
                    }
                    return obj;
                }
            };
        }
    }
}

