/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ssm;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface CfnParameterProps
extends JsiiSerializable {
    public String getType();

    public String getValue();

    public String getAllowedPattern();

    public String getDescription();

    public String getName();

    public String getPolicies();

    public Object getTags();

    public String getTier();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _type;
        private String _value;
        @Nullable
        private String _allowedPattern;
        @Nullable
        private String _description;
        @Nullable
        private String _name;
        @Nullable
        private String _policies;
        @Nullable
        private Object _tags;
        @Nullable
        private String _tier;

        public Builder withType(String value) {
            this._type = Objects.requireNonNull(value, "type is required");
            return this;
        }

        public Builder withValue(String value) {
            this._value = Objects.requireNonNull(value, "value is required");
            return this;
        }

        public Builder withAllowedPattern(@Nullable String value) {
            this._allowedPattern = value;
            return this;
        }

        public Builder withDescription(@Nullable String value) {
            this._description = value;
            return this;
        }

        public Builder withName(@Nullable String value) {
            this._name = value;
            return this;
        }

        public Builder withPolicies(@Nullable String value) {
            this._policies = value;
            return this;
        }

        public Builder withTags(@Nullable Object value) {
            this._tags = value;
            return this;
        }

        public Builder withTier(@Nullable String value) {
            this._tier = value;
            return this;
        }

        public CfnParameterProps build() {
            return new CfnParameterProps(){
                private final String $type;
                private final String $value;
                @Nullable
                private final String $allowedPattern;
                @Nullable
                private final String $description;
                @Nullable
                private final String $name;
                @Nullable
                private final String $policies;
                @Nullable
                private final Object $tags;
                @Nullable
                private final String $tier;
                {
                    this.$type = Objects.requireNonNull(_type, "type is required");
                    this.$value = Objects.requireNonNull(_value, "value is required");
                    this.$allowedPattern = _allowedPattern;
                    this.$description = _description;
                    this.$name = _name;
                    this.$policies = _policies;
                    this.$tags = _tags;
                    this.$tier = _tier;
                }

                @Override
                public String getType() {
                    return this.$type;
                }

                @Override
                public String getValue() {
                    return this.$value;
                }

                @Override
                public String getAllowedPattern() {
                    return this.$allowedPattern;
                }

                @Override
                public String getDescription() {
                    return this.$description;
                }

                @Override
                public String getName() {
                    return this.$name;
                }

                @Override
                public String getPolicies() {
                    return this.$policies;
                }

                @Override
                public Object getTags() {
                    return this.$tags;
                }

                @Override
                public String getTier() {
                    return this.$tier;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("type", om.valueToTree((Object)this.getType()));
                    obj.set("value", om.valueToTree((Object)this.getValue()));
                    if (this.getAllowedPattern() != null) {
                        obj.set("allowedPattern", om.valueToTree((Object)this.getAllowedPattern()));
                    }
                    if (this.getDescription() != null) {
                        obj.set("description", om.valueToTree((Object)this.getDescription()));
                    }
                    if (this.getName() != null) {
                        obj.set("name", om.valueToTree((Object)this.getName()));
                    }
                    if (this.getPolicies() != null) {
                        obj.set("policies", om.valueToTree((Object)this.getPolicies()));
                    }
                    if (this.getTags() != null) {
                        obj.set("tags", om.valueToTree(this.getTags()));
                    }
                    if (this.getTier() != null) {
                        obj.set("tier", om.valueToTree((Object)this.getTier()));
                    }
                    return obj;
                }
            };
        }
    }
}

