/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ssm;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.ssm.ParameterOptions;
import software.amazon.awscdk.services.ssm.ParameterType;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface ParameterProps
extends JsiiSerializable,
ParameterOptions {
    public ParameterType getType();

    public String getValue();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ParameterType _type;
        private String _value;
        @Nullable
        private String _allowedPattern;
        @Nullable
        private String _description;
        @Nullable
        private String _name;

        public Builder withType(ParameterType value) {
            this._type = Objects.requireNonNull(value, "type is required");
            return this;
        }

        public Builder withValue(String value) {
            this._value = Objects.requireNonNull(value, "value is required");
            return this;
        }

        public Builder withAllowedPattern(@Nullable String value) {
            this._allowedPattern = value;
            return this;
        }

        public Builder withDescription(@Nullable String value) {
            this._description = value;
            return this;
        }

        public Builder withName(@Nullable String value) {
            this._name = value;
            return this;
        }

        public ParameterProps build() {
            return new ParameterProps(){
                private final ParameterType $type;
                private final String $value;
                @Nullable
                private final String $allowedPattern;
                @Nullable
                private final String $description;
                @Nullable
                private final String $name;
                {
                    this.$type = Objects.requireNonNull(_type, "type is required");
                    this.$value = Objects.requireNonNull(_value, "value is required");
                    this.$allowedPattern = _allowedPattern;
                    this.$description = _description;
                    this.$name = _name;
                }

                @Override
                public ParameterType getType() {
                    return this.$type;
                }

                @Override
                public String getValue() {
                    return this.$value;
                }

                @Override
                public String getAllowedPattern() {
                    return this.$allowedPattern;
                }

                @Override
                public String getDescription() {
                    return this.$description;
                }

                @Override
                public String getName() {
                    return this.$name;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("type", om.valueToTree((Object)this.getType()));
                    obj.set("value", om.valueToTree((Object)this.getValue()));
                    obj.set("allowedPattern", om.valueToTree((Object)this.getAllowedPattern()));
                    obj.set("description", om.valueToTree((Object)this.getDescription()));
                    obj.set("name", om.valueToTree((Object)this.getName()));
                    return obj;
                }
            };
        }
    }
}

