/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ssm;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.Construct;
import software.amazon.awscdk.Token;
import software.amazon.awscdk.services.ssm.$Module;
import software.amazon.awscdk.services.ssm.CfnAssociationProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-ssm.CfnAssociation")
public class CfnAssociation
extends CfnResource {
    public static final String RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnAssociation.class, (String)"resourceTypeName", String.class);

    protected CfnAssociation(JsiiObject.InitializationMode mode) {
        super(mode);
    }

    public CfnAssociation(Construct scope, String id, CfnAssociationProps props) {
        super(JsiiObject.InitializationMode.Jsii);
        JsiiEngine.getInstance().createNewObject((Object)this, Stream.concat(Stream.concat(Stream.of(Objects.requireNonNull(scope, "scope is required")), Stream.of(Objects.requireNonNull(id, "id is required"))), Stream.of(Objects.requireNonNull(props, "props is required"))).toArray());
    }

    protected Map<String, Object> renderProperties(Object properties) {
        return (Map)this.jsiiCall("renderProperties", Map.class, Stream.of(Objects.requireNonNull(properties, "properties is required")).toArray());
    }

    public CfnAssociationProps getPropertyOverrides() {
        return (CfnAssociationProps)this.jsiiGet("propertyOverrides", CfnAssociationProps.class);
    }

    public static interface TargetProperty
    extends JsiiSerializable {
        public String getKey();

        public List<String> getValues();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _key;
            private List<String> _values;

            public Builder withKey(String value) {
                this._key = Objects.requireNonNull(value, "key is required");
                return this;
            }

            public Builder withValues(List<String> value) {
                this._values = Objects.requireNonNull(value, "values is required");
                return this;
            }

            public TargetProperty build() {
                return new TargetProperty(){
                    private final String $key;
                    private final List<String> $values;
                    {
                        this.$key = Objects.requireNonNull(_key, "key is required");
                        this.$values = Objects.requireNonNull(_values, "values is required");
                    }

                    @Override
                    public String getKey() {
                        return this.$key;
                    }

                    @Override
                    public List<String> getValues() {
                        return this.$values;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("key", om.valueToTree((Object)this.getKey()));
                        obj.set("values", om.valueToTree(this.getValues()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface S3OutputLocationProperty
    extends JsiiSerializable {
        public String getOutputS3BucketName();

        public String getOutputS3KeyPrefix();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private String _outputS3BucketName;
            @Nullable
            private String _outputS3KeyPrefix;

            public Builder withOutputS3BucketName(@Nullable String value) {
                this._outputS3BucketName = value;
                return this;
            }

            public Builder withOutputS3KeyPrefix(@Nullable String value) {
                this._outputS3KeyPrefix = value;
                return this;
            }

            public S3OutputLocationProperty build() {
                return new S3OutputLocationProperty(){
                    @Nullable
                    private final String $outputS3BucketName;
                    @Nullable
                    private final String $outputS3KeyPrefix;
                    {
                        this.$outputS3BucketName = _outputS3BucketName;
                        this.$outputS3KeyPrefix = _outputS3KeyPrefix;
                    }

                    @Override
                    public String getOutputS3BucketName() {
                        return this.$outputS3BucketName;
                    }

                    @Override
                    public String getOutputS3KeyPrefix() {
                        return this.$outputS3KeyPrefix;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("outputS3BucketName", om.valueToTree((Object)this.getOutputS3BucketName()));
                        obj.set("outputS3KeyPrefix", om.valueToTree((Object)this.getOutputS3KeyPrefix()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface ParameterValuesProperty
    extends JsiiSerializable {
        public List<String> getParameterValues();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private List<String> _parameterValues;

            public Builder withParameterValues(List<String> value) {
                this._parameterValues = Objects.requireNonNull(value, "parameterValues is required");
                return this;
            }

            public ParameterValuesProperty build() {
                return new ParameterValuesProperty(){
                    private final List<String> $parameterValues;
                    {
                        this.$parameterValues = Objects.requireNonNull(_parameterValues, "parameterValues is required");
                    }

                    @Override
                    public List<String> getParameterValues() {
                        return this.$parameterValues;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("parameterValues", om.valueToTree(this.getParameterValues()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface InstanceAssociationOutputLocationProperty
    extends JsiiSerializable {
        public Object getS3Location();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _s3Location;

            public Builder withS3Location(@Nullable Token value) {
                this._s3Location = value;
                return this;
            }

            public Builder withS3Location(@Nullable S3OutputLocationProperty value) {
                this._s3Location = value;
                return this;
            }

            public InstanceAssociationOutputLocationProperty build() {
                return new InstanceAssociationOutputLocationProperty(){
                    @Nullable
                    private final Object $s3Location;
                    {
                        this.$s3Location = _s3Location;
                    }

                    @Override
                    public Object getS3Location() {
                        return this.$s3Location;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("s3Location", om.valueToTree(this.getS3Location()));
                        return obj;
                    }
                };
            }
        }
    }
}

