/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ssm;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.Token;
import software.amazon.awscdk.services.ssm.CfnAssociation;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface CfnAssociationProps
extends JsiiSerializable {
    public String getName();

    public String getAssociationName();

    public String getDocumentVersion();

    public String getInstanceId();

    public Object getOutputLocation();

    public Object getParameters();

    public String getScheduleExpression();

    public Object getTargets();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _name;
        @Nullable
        private String _associationName;
        @Nullable
        private String _documentVersion;
        @Nullable
        private String _instanceId;
        @Nullable
        private Object _outputLocation;
        @Nullable
        private Object _parameters;
        @Nullable
        private String _scheduleExpression;
        @Nullable
        private Object _targets;

        public Builder withName(String value) {
            this._name = Objects.requireNonNull(value, "name is required");
            return this;
        }

        public Builder withAssociationName(@Nullable String value) {
            this._associationName = value;
            return this;
        }

        public Builder withDocumentVersion(@Nullable String value) {
            this._documentVersion = value;
            return this;
        }

        public Builder withInstanceId(@Nullable String value) {
            this._instanceId = value;
            return this;
        }

        public Builder withOutputLocation(@Nullable CfnAssociation.InstanceAssociationOutputLocationProperty value) {
            this._outputLocation = value;
            return this;
        }

        public Builder withOutputLocation(@Nullable Token value) {
            this._outputLocation = value;
            return this;
        }

        public Builder withParameters(@Nullable Token value) {
            this._parameters = value;
            return this;
        }

        public Builder withParameters(@Nullable Map<String, Object> value) {
            this._parameters = value;
            return this;
        }

        public Builder withScheduleExpression(@Nullable String value) {
            this._scheduleExpression = value;
            return this;
        }

        public Builder withTargets(@Nullable Token value) {
            this._targets = value;
            return this;
        }

        public Builder withTargets(@Nullable List<Object> value) {
            this._targets = value;
            return this;
        }

        public CfnAssociationProps build() {
            return new CfnAssociationProps(){
                private final String $name;
                @Nullable
                private final String $associationName;
                @Nullable
                private final String $documentVersion;
                @Nullable
                private final String $instanceId;
                @Nullable
                private final Object $outputLocation;
                @Nullable
                private final Object $parameters;
                @Nullable
                private final String $scheduleExpression;
                @Nullable
                private final Object $targets;
                {
                    this.$name = Objects.requireNonNull(_name, "name is required");
                    this.$associationName = _associationName;
                    this.$documentVersion = _documentVersion;
                    this.$instanceId = _instanceId;
                    this.$outputLocation = _outputLocation;
                    this.$parameters = _parameters;
                    this.$scheduleExpression = _scheduleExpression;
                    this.$targets = _targets;
                }

                @Override
                public String getName() {
                    return this.$name;
                }

                @Override
                public String getAssociationName() {
                    return this.$associationName;
                }

                @Override
                public String getDocumentVersion() {
                    return this.$documentVersion;
                }

                @Override
                public String getInstanceId() {
                    return this.$instanceId;
                }

                @Override
                public Object getOutputLocation() {
                    return this.$outputLocation;
                }

                @Override
                public Object getParameters() {
                    return this.$parameters;
                }

                @Override
                public String getScheduleExpression() {
                    return this.$scheduleExpression;
                }

                @Override
                public Object getTargets() {
                    return this.$targets;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("name", om.valueToTree((Object)this.getName()));
                    obj.set("associationName", om.valueToTree((Object)this.getAssociationName()));
                    obj.set("documentVersion", om.valueToTree((Object)this.getDocumentVersion()));
                    obj.set("instanceId", om.valueToTree((Object)this.getInstanceId()));
                    obj.set("outputLocation", om.valueToTree(this.getOutputLocation()));
                    obj.set("parameters", om.valueToTree(this.getParameters()));
                    obj.set("scheduleExpression", om.valueToTree((Object)this.getScheduleExpression()));
                    obj.set("targets", om.valueToTree(this.getTargets()));
                    return obj;
                }
            };
        }
    }
}

