/**
 * <h2>Amazon Simple Queue Service Construct Library</h2>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cfn-resources: Stable" src="https://img.shields.io/badge/cfn--resources-stable-success.svg?style=for-the-badge">
 * <p>
 * <img alt="cdk-constructs: Stable" src="https://img.shields.io/badge/cdk--constructs-stable-success.svg?style=for-the-badge">
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * Amazon Simple Queue Service (SQS) is a fully managed message queuing service that
 * enables you to decouple and scale microservices, distributed systems, and serverless
 * applications. SQS eliminates the complexity and overhead associated with managing and
 * operating message oriented middleware, and empowers developers to focus on differentiating work.
 * Using SQS, you can send, store, and receive messages between software components at any volume,
 * without losing messages or requiring other services to be available.
 * <p>
 * <h3>Installation</h3>
 * <p>
 * Import to your project:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.sqs.*;
 * </pre></blockquote>
 * <p>
 * <h3>Basic usage</h3>
 * <p>
 * Here's how to add a basic queue to your application:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * new Queue(this, "Queue");
 * </pre></blockquote>
 * <p>
 * <h3>Encryption</h3>
 * <p>
 * If you want to encrypt the queue contents, set the <code>encryption</code> property. You can have
 * the messages encrypted with a key that SQS manages for you, or a key that you
 * can manage yourself.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * // Use managed key
 * // Use managed key
 * Queue.Builder.create(this, "Queue")
 *         .encryption(QueueEncryption.getKMS_MANAGED())
 *         .build();
 * 
 * // Use custom key
 * var myKey = new Key(this, "Key");
 * 
 * Queue.Builder.create(this, "Queue")
 *         .encryption(QueueEncryption.getKMS())
 *         .encryptionMasterKey(myKey)
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h3>First-In-First-Out (FIFO) queues</h3>
 * <p>
 * FIFO queues give guarantees on the order in which messages are dequeued, and have additional
 * features in order to help guarantee exactly-once processing. For more information, see
 * the SQS manual. Note that FIFO queues are not available in all AWS regions.
 * <p>
 * A queue can be made a FIFO queue by either setting <code>fifo: true</code>, giving it a name which ends
 * in <code>".fifo"</code>, or enabling content-based deduplication (which requires FIFO queues).
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
package software.amazon.awscdk.services.sqs;
