package software.amazon.awscdk.services.sqs;

/**
 * Properties for creating a new Queue.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:12.352Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sqs.$Module.class, fqn = "@aws-cdk/aws-sqs.QueueProps")
@software.amazon.jsii.Jsii.Proxy(QueueProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface QueueProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies whether to enable content-based deduplication.
     * <p>
     * During the deduplication interval (5 minutes), Amazon SQS treats
     * messages that are sent with identical content (excluding attributes) as
     * duplicates and delivers only one copy of the message.
     * <p>
     * If you don't enable content-based deduplication and you want to deduplicate
     * messages, provide an explicit deduplication ID in your SendMessage() call.
     * <p>
     * (Only applies to FIFO queues.)
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getContentBasedDeduplication() {
        return null;
    }

    /**
     * The length of time that Amazon SQS reuses a data key before calling KMS again.
     * <p>
     * The value must be an integer between 60 (1 minute) and 86,400 (24
     * hours). The default is 300 (5 minutes).
     * <p>
     * Default: Duration.minutes(5)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getDataKeyReuse() {
        return null;
    }

    /**
     * Send messages to this queue if they were unsuccessfully dequeued a number of times.
     * <p>
     * Default: no dead-letter queue
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sqs.DeadLetterQueue getDeadLetterQueue() {
        return null;
    }

    /**
     * The time in seconds that the delivery of all messages in the queue is delayed.
     * <p>
     * You can specify an integer value of 0 to 900 (15 minutes). The default
     * value is 0.
     * <p>
     * Default: 0
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getDeliveryDelay() {
        return null;
    }

    /**
     * Whether the contents of the queue are encrypted, and by what type of key.
     * <p>
     * Be aware that encryption is not available in all regions, please see the docs
     * for current availability details.
     * <p>
     * Default: Unencrypted
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sqs.QueueEncryption getEncryption() {
        return null;
    }

    /**
     * External KMS master key to use for queue encryption.
     * <p>
     * Individual messages will be encrypted using data keys. The data keys in
     * turn will be encrypted using this key, and reused for a maximum of
     * <code>dataKeyReuseSecs</code> seconds.
     * <p>
     * If the 'encryptionMasterKey' property is set, 'encryption' type will be
     * implicitly set to "KMS".
     * <p>
     * Default: If encryption is set to KMS and not specified, a key will be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionMasterKey() {
        return null;
    }

    /**
     * Whether this a first-in-first-out (FIFO) queue.
     * <p>
     * Default: false, unless queueName ends in '.fifo' or 'contentBasedDeduplication' is true.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getFifo() {
        return null;
    }

    /**
     * The limit of how many bytes that a message can contain before Amazon SQS rejects it.
     * <p>
     * You can specify an integer value from 1024 bytes (1 KiB) to 262144 bytes
     * (256 KiB). The default value is 262144 (256 KiB).
     * <p>
     * Default: 256KiB
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxMessageSizeBytes() {
        return null;
    }

    /**
     * A name for the queue.
     * <p>
     * If specified and this is a FIFO queue, must end in the string '.fifo'.
     * <p>
     * Default: CloudFormation-generated name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getQueueName() {
        return null;
    }

    /**
     * Default wait time for ReceiveMessage calls.
     * <p>
     * Does not wait if set to 0, otherwise waits this amount of seconds
     * by default for messages to arrive.
     * <p>
     * For more information, see Amazon SQS Long Poll.
     * <p>
     * Default: 0
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getReceiveMessageWaitTime() {
        return null;
    }

    /**
     * The number of seconds that Amazon SQS retains a message.
     * <p>
     * You can specify an integer value from 60 seconds (1 minute) to 1209600
     * seconds (14 days). The default value is 345600 seconds (4 days).
     * <p>
     * Default: Duration.days(4)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getRetentionPeriod() {
        return null;
    }

    /**
     * Timeout of processing a single message.
     * <p>
     * After dequeuing, the processor has this much time to handle the message
     * and delete it from the queue before it becomes visible again for dequeueing
     * by another processor.
     * <p>
     * Values must be from 0 to 43200 seconds (12 hours). If you don't specify
     * a value, AWS CloudFormation uses the default value of 30 seconds.
     * <p>
     * Default: Duration.seconds(30)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getVisibilityTimeout() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link QueueProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link QueueProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<QueueProps> {
        private java.lang.Boolean contentBasedDeduplication;
        private software.amazon.awscdk.core.Duration dataKeyReuse;
        private software.amazon.awscdk.services.sqs.DeadLetterQueue deadLetterQueue;
        private software.amazon.awscdk.core.Duration deliveryDelay;
        private software.amazon.awscdk.services.sqs.QueueEncryption encryption;
        private software.amazon.awscdk.services.kms.IKey encryptionMasterKey;
        private java.lang.Boolean fifo;
        private java.lang.Number maxMessageSizeBytes;
        private java.lang.String queueName;
        private software.amazon.awscdk.core.Duration receiveMessageWaitTime;
        private software.amazon.awscdk.core.Duration retentionPeriod;
        private software.amazon.awscdk.core.Duration visibilityTimeout;

        /**
         * Sets the value of {@link QueueProps#getContentBasedDeduplication}
         * @param contentBasedDeduplication Specifies whether to enable content-based deduplication.
         *                                  During the deduplication interval (5 minutes), Amazon SQS treats
         *                                  messages that are sent with identical content (excluding attributes) as
         *                                  duplicates and delivers only one copy of the message.
         *                                  <p>
         *                                  If you don't enable content-based deduplication and you want to deduplicate
         *                                  messages, provide an explicit deduplication ID in your SendMessage() call.
         *                                  <p>
         *                                  (Only applies to FIFO queues.)
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentBasedDeduplication(java.lang.Boolean contentBasedDeduplication) {
            this.contentBasedDeduplication = contentBasedDeduplication;
            return this;
        }

        /**
         * Sets the value of {@link QueueProps#getDataKeyReuse}
         * @param dataKeyReuse The length of time that Amazon SQS reuses a data key before calling KMS again.
         *                     The value must be an integer between 60 (1 minute) and 86,400 (24
         *                     hours). The default is 300 (5 minutes).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataKeyReuse(software.amazon.awscdk.core.Duration dataKeyReuse) {
            this.dataKeyReuse = dataKeyReuse;
            return this;
        }

        /**
         * Sets the value of {@link QueueProps#getDeadLetterQueue}
         * @param deadLetterQueue Send messages to this queue if they were unsuccessfully dequeued a number of times.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterQueue(software.amazon.awscdk.services.sqs.DeadLetterQueue deadLetterQueue) {
            this.deadLetterQueue = deadLetterQueue;
            return this;
        }

        /**
         * Sets the value of {@link QueueProps#getDeliveryDelay}
         * @param deliveryDelay The time in seconds that the delivery of all messages in the queue is delayed.
         *                      You can specify an integer value of 0 to 900 (15 minutes). The default
         *                      value is 0.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deliveryDelay(software.amazon.awscdk.core.Duration deliveryDelay) {
            this.deliveryDelay = deliveryDelay;
            return this;
        }

        /**
         * Sets the value of {@link QueueProps#getEncryption}
         * @param encryption Whether the contents of the queue are encrypted, and by what type of key.
         *                   Be aware that encryption is not available in all regions, please see the docs
         *                   for current availability details.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryption(software.amazon.awscdk.services.sqs.QueueEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        /**
         * Sets the value of {@link QueueProps#getEncryptionMasterKey}
         * @param encryptionMasterKey External KMS master key to use for queue encryption.
         *                            Individual messages will be encrypted using data keys. The data keys in
         *                            turn will be encrypted using this key, and reused for a maximum of
         *                            <code>dataKeyReuseSecs</code> seconds.
         *                            <p>
         *                            If the 'encryptionMasterKey' property is set, 'encryption' type will be
         *                            implicitly set to "KMS".
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionMasterKey(software.amazon.awscdk.services.kms.IKey encryptionMasterKey) {
            this.encryptionMasterKey = encryptionMasterKey;
            return this;
        }

        /**
         * Sets the value of {@link QueueProps#getFifo}
         * @param fifo Whether this a first-in-first-out (FIFO) queue.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fifo(java.lang.Boolean fifo) {
            this.fifo = fifo;
            return this;
        }

        /**
         * Sets the value of {@link QueueProps#getMaxMessageSizeBytes}
         * @param maxMessageSizeBytes The limit of how many bytes that a message can contain before Amazon SQS rejects it.
         *                            You can specify an integer value from 1024 bytes (1 KiB) to 262144 bytes
         *                            (256 KiB). The default value is 262144 (256 KiB).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxMessageSizeBytes(java.lang.Number maxMessageSizeBytes) {
            this.maxMessageSizeBytes = maxMessageSizeBytes;
            return this;
        }

        /**
         * Sets the value of {@link QueueProps#getQueueName}
         * @param queueName A name for the queue.
         *                  If specified and this is a FIFO queue, must end in the string '.fifo'.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queueName(java.lang.String queueName) {
            this.queueName = queueName;
            return this;
        }

        /**
         * Sets the value of {@link QueueProps#getReceiveMessageWaitTime}
         * @param receiveMessageWaitTime Default wait time for ReceiveMessage calls.
         *                               Does not wait if set to 0, otherwise waits this amount of seconds
         *                               by default for messages to arrive.
         *                               <p>
         *                               For more information, see Amazon SQS Long Poll.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder receiveMessageWaitTime(software.amazon.awscdk.core.Duration receiveMessageWaitTime) {
            this.receiveMessageWaitTime = receiveMessageWaitTime;
            return this;
        }

        /**
         * Sets the value of {@link QueueProps#getRetentionPeriod}
         * @param retentionPeriod The number of seconds that Amazon SQS retains a message.
         *                        You can specify an integer value from 60 seconds (1 minute) to 1209600
         *                        seconds (14 days). The default value is 345600 seconds (4 days).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retentionPeriod(software.amazon.awscdk.core.Duration retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        /**
         * Sets the value of {@link QueueProps#getVisibilityTimeout}
         * @param visibilityTimeout Timeout of processing a single message.
         *                          After dequeuing, the processor has this much time to handle the message
         *                          and delete it from the queue before it becomes visible again for dequeueing
         *                          by another processor.
         *                          <p>
         *                          Values must be from 0 to 43200 seconds (12 hours). If you don't specify
         *                          a value, AWS CloudFormation uses the default value of 30 seconds.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder visibilityTimeout(software.amazon.awscdk.core.Duration visibilityTimeout) {
            this.visibilityTimeout = visibilityTimeout;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link QueueProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public QueueProps build() {
            return new Jsii$Proxy(contentBasedDeduplication, dataKeyReuse, deadLetterQueue, deliveryDelay, encryption, encryptionMasterKey, fifo, maxMessageSizeBytes, queueName, receiveMessageWaitTime, retentionPeriod, visibilityTimeout);
        }
    }

    /**
     * An implementation for {@link QueueProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements QueueProps {
        private final java.lang.Boolean contentBasedDeduplication;
        private final software.amazon.awscdk.core.Duration dataKeyReuse;
        private final software.amazon.awscdk.services.sqs.DeadLetterQueue deadLetterQueue;
        private final software.amazon.awscdk.core.Duration deliveryDelay;
        private final software.amazon.awscdk.services.sqs.QueueEncryption encryption;
        private final software.amazon.awscdk.services.kms.IKey encryptionMasterKey;
        private final java.lang.Boolean fifo;
        private final java.lang.Number maxMessageSizeBytes;
        private final java.lang.String queueName;
        private final software.amazon.awscdk.core.Duration receiveMessageWaitTime;
        private final software.amazon.awscdk.core.Duration retentionPeriod;
        private final software.amazon.awscdk.core.Duration visibilityTimeout;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.contentBasedDeduplication = this.jsiiGet("contentBasedDeduplication", java.lang.Boolean.class);
            this.dataKeyReuse = this.jsiiGet("dataKeyReuse", software.amazon.awscdk.core.Duration.class);
            this.deadLetterQueue = this.jsiiGet("deadLetterQueue", software.amazon.awscdk.services.sqs.DeadLetterQueue.class);
            this.deliveryDelay = this.jsiiGet("deliveryDelay", software.amazon.awscdk.core.Duration.class);
            this.encryption = this.jsiiGet("encryption", software.amazon.awscdk.services.sqs.QueueEncryption.class);
            this.encryptionMasterKey = this.jsiiGet("encryptionMasterKey", software.amazon.awscdk.services.kms.IKey.class);
            this.fifo = this.jsiiGet("fifo", java.lang.Boolean.class);
            this.maxMessageSizeBytes = this.jsiiGet("maxMessageSizeBytes", java.lang.Number.class);
            this.queueName = this.jsiiGet("queueName", java.lang.String.class);
            this.receiveMessageWaitTime = this.jsiiGet("receiveMessageWaitTime", software.amazon.awscdk.core.Duration.class);
            this.retentionPeriod = this.jsiiGet("retentionPeriod", software.amazon.awscdk.core.Duration.class);
            this.visibilityTimeout = this.jsiiGet("visibilityTimeout", software.amazon.awscdk.core.Duration.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.Boolean contentBasedDeduplication, final software.amazon.awscdk.core.Duration dataKeyReuse, final software.amazon.awscdk.services.sqs.DeadLetterQueue deadLetterQueue, final software.amazon.awscdk.core.Duration deliveryDelay, final software.amazon.awscdk.services.sqs.QueueEncryption encryption, final software.amazon.awscdk.services.kms.IKey encryptionMasterKey, final java.lang.Boolean fifo, final java.lang.Number maxMessageSizeBytes, final java.lang.String queueName, final software.amazon.awscdk.core.Duration receiveMessageWaitTime, final software.amazon.awscdk.core.Duration retentionPeriod, final software.amazon.awscdk.core.Duration visibilityTimeout) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.contentBasedDeduplication = contentBasedDeduplication;
            this.dataKeyReuse = dataKeyReuse;
            this.deadLetterQueue = deadLetterQueue;
            this.deliveryDelay = deliveryDelay;
            this.encryption = encryption;
            this.encryptionMasterKey = encryptionMasterKey;
            this.fifo = fifo;
            this.maxMessageSizeBytes = maxMessageSizeBytes;
            this.queueName = queueName;
            this.receiveMessageWaitTime = receiveMessageWaitTime;
            this.retentionPeriod = retentionPeriod;
            this.visibilityTimeout = visibilityTimeout;
        }

        @Override
        public java.lang.Boolean getContentBasedDeduplication() {
            return this.contentBasedDeduplication;
        }

        @Override
        public software.amazon.awscdk.core.Duration getDataKeyReuse() {
            return this.dataKeyReuse;
        }

        @Override
        public software.amazon.awscdk.services.sqs.DeadLetterQueue getDeadLetterQueue() {
            return this.deadLetterQueue;
        }

        @Override
        public software.amazon.awscdk.core.Duration getDeliveryDelay() {
            return this.deliveryDelay;
        }

        @Override
        public software.amazon.awscdk.services.sqs.QueueEncryption getEncryption() {
            return this.encryption;
        }

        @Override
        public software.amazon.awscdk.services.kms.IKey getEncryptionMasterKey() {
            return this.encryptionMasterKey;
        }

        @Override
        public java.lang.Boolean getFifo() {
            return this.fifo;
        }

        @Override
        public java.lang.Number getMaxMessageSizeBytes() {
            return this.maxMessageSizeBytes;
        }

        @Override
        public java.lang.String getQueueName() {
            return this.queueName;
        }

        @Override
        public software.amazon.awscdk.core.Duration getReceiveMessageWaitTime() {
            return this.receiveMessageWaitTime;
        }

        @Override
        public software.amazon.awscdk.core.Duration getRetentionPeriod() {
            return this.retentionPeriod;
        }

        @Override
        public software.amazon.awscdk.core.Duration getVisibilityTimeout() {
            return this.visibilityTimeout;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getContentBasedDeduplication() != null) {
                data.set("contentBasedDeduplication", om.valueToTree(this.getContentBasedDeduplication()));
            }
            if (this.getDataKeyReuse() != null) {
                data.set("dataKeyReuse", om.valueToTree(this.getDataKeyReuse()));
            }
            if (this.getDeadLetterQueue() != null) {
                data.set("deadLetterQueue", om.valueToTree(this.getDeadLetterQueue()));
            }
            if (this.getDeliveryDelay() != null) {
                data.set("deliveryDelay", om.valueToTree(this.getDeliveryDelay()));
            }
            if (this.getEncryption() != null) {
                data.set("encryption", om.valueToTree(this.getEncryption()));
            }
            if (this.getEncryptionMasterKey() != null) {
                data.set("encryptionMasterKey", om.valueToTree(this.getEncryptionMasterKey()));
            }
            if (this.getFifo() != null) {
                data.set("fifo", om.valueToTree(this.getFifo()));
            }
            if (this.getMaxMessageSizeBytes() != null) {
                data.set("maxMessageSizeBytes", om.valueToTree(this.getMaxMessageSizeBytes()));
            }
            if (this.getQueueName() != null) {
                data.set("queueName", om.valueToTree(this.getQueueName()));
            }
            if (this.getReceiveMessageWaitTime() != null) {
                data.set("receiveMessageWaitTime", om.valueToTree(this.getReceiveMessageWaitTime()));
            }
            if (this.getRetentionPeriod() != null) {
                data.set("retentionPeriod", om.valueToTree(this.getRetentionPeriod()));
            }
            if (this.getVisibilityTimeout() != null) {
                data.set("visibilityTimeout", om.valueToTree(this.getVisibilityTimeout()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-sqs.QueueProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            QueueProps.Jsii$Proxy that = (QueueProps.Jsii$Proxy) o;

            if (this.contentBasedDeduplication != null ? !this.contentBasedDeduplication.equals(that.contentBasedDeduplication) : that.contentBasedDeduplication != null) return false;
            if (this.dataKeyReuse != null ? !this.dataKeyReuse.equals(that.dataKeyReuse) : that.dataKeyReuse != null) return false;
            if (this.deadLetterQueue != null ? !this.deadLetterQueue.equals(that.deadLetterQueue) : that.deadLetterQueue != null) return false;
            if (this.deliveryDelay != null ? !this.deliveryDelay.equals(that.deliveryDelay) : that.deliveryDelay != null) return false;
            if (this.encryption != null ? !this.encryption.equals(that.encryption) : that.encryption != null) return false;
            if (this.encryptionMasterKey != null ? !this.encryptionMasterKey.equals(that.encryptionMasterKey) : that.encryptionMasterKey != null) return false;
            if (this.fifo != null ? !this.fifo.equals(that.fifo) : that.fifo != null) return false;
            if (this.maxMessageSizeBytes != null ? !this.maxMessageSizeBytes.equals(that.maxMessageSizeBytes) : that.maxMessageSizeBytes != null) return false;
            if (this.queueName != null ? !this.queueName.equals(that.queueName) : that.queueName != null) return false;
            if (this.receiveMessageWaitTime != null ? !this.receiveMessageWaitTime.equals(that.receiveMessageWaitTime) : that.receiveMessageWaitTime != null) return false;
            if (this.retentionPeriod != null ? !this.retentionPeriod.equals(that.retentionPeriod) : that.retentionPeriod != null) return false;
            return this.visibilityTimeout != null ? this.visibilityTimeout.equals(that.visibilityTimeout) : that.visibilityTimeout == null;
        }

        @Override
        public int hashCode() {
            int result = this.contentBasedDeduplication != null ? this.contentBasedDeduplication.hashCode() : 0;
            result = 31 * result + (this.dataKeyReuse != null ? this.dataKeyReuse.hashCode() : 0);
            result = 31 * result + (this.deadLetterQueue != null ? this.deadLetterQueue.hashCode() : 0);
            result = 31 * result + (this.deliveryDelay != null ? this.deliveryDelay.hashCode() : 0);
            result = 31 * result + (this.encryption != null ? this.encryption.hashCode() : 0);
            result = 31 * result + (this.encryptionMasterKey != null ? this.encryptionMasterKey.hashCode() : 0);
            result = 31 * result + (this.fifo != null ? this.fifo.hashCode() : 0);
            result = 31 * result + (this.maxMessageSizeBytes != null ? this.maxMessageSizeBytes.hashCode() : 0);
            result = 31 * result + (this.queueName != null ? this.queueName.hashCode() : 0);
            result = 31 * result + (this.receiveMessageWaitTime != null ? this.receiveMessageWaitTime.hashCode() : 0);
            result = 31 * result + (this.retentionPeriod != null ? this.retentionPeriod.hashCode() : 0);
            result = 31 * result + (this.visibilityTimeout != null ? this.visibilityTimeout.hashCode() : 0);
            return result;
        }
    }
}
