package software.amazon.awscdk.services.sqs;

/**
 * Properties to associate SQS queues with a policy.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:12.352Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sqs.$Module.class, fqn = "@aws-cdk/aws-sqs.QueuePolicyProps")
@software.amazon.jsii.Jsii.Proxy(QueuePolicyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface QueuePolicyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The set of queues this policy applies to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.sqs.IQueue> getQueues();

    /**
     * @return a {@link Builder} of {@link QueuePolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link QueuePolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<QueuePolicyProps> {
        private java.util.List<software.amazon.awscdk.services.sqs.IQueue> queues;

        /**
         * Sets the value of {@link QueuePolicyProps#getQueues}
         * @param queues The set of queues this policy applies to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queues(java.util.List<software.amazon.awscdk.services.sqs.IQueue> queues) {
            this.queues = queues;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link QueuePolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public QueuePolicyProps build() {
            return new Jsii$Proxy(queues);
        }
    }

    /**
     * An implementation for {@link QueuePolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements QueuePolicyProps {
        private final java.util.List<software.amazon.awscdk.services.sqs.IQueue> queues;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.queues = this.jsiiGet("queues", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sqs.IQueue.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.util.List<software.amazon.awscdk.services.sqs.IQueue> queues) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.queues = java.util.Objects.requireNonNull(queues, "queues is required");
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.sqs.IQueue> getQueues() {
            return this.queues;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("queues", om.valueToTree(this.getQueues()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-sqs.QueuePolicyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            QueuePolicyProps.Jsii$Proxy that = (QueuePolicyProps.Jsii$Proxy) o;

            return this.queues.equals(that.queues);
        }

        @Override
        public int hashCode() {
            int result = this.queues.hashCode();
            return result;
        }
    }
}
