package software.amazon.awscdk.services.sqs;

/**
 * Reference to a new or existing Amazon SQS queue.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:12.349Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sqs.$Module.class, fqn = "@aws-cdk/aws-sqs.QueueBase")
public abstract class QueueBase extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.sqs.IQueue {

    protected QueueBase(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected QueueBase(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected QueueBase(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.ResourceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected QueueBase(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Adds a statement to the IAM resource policy associated with this queue.
     * <p>
     * If this queue was created in this stack (<code>new Queue</code>), a queue policy
     * will be automatically created upon the first call to <code>addToPolicy</code>. If
     * the queue is imported (<code>Queue.import</code>), then this is a no-op.
     * <p>
     * @param statement This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.AddToResourcePolicyResult addToResourcePolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement) {
        return this.jsiiCall("addToResourcePolicy", software.amazon.awscdk.services.iam.AddToResourcePolicyResult.class, new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
    }

    /**
     * Grant the actions defined in queueActions to the identity Principal given on this SQS queue resource.
     * <p>
     * @param grantee Principal to grant right to. This parameter is required.
     * @param actions The actions to grant. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grant(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.lang.String... actions) {
        return this.jsiiCall("grant", software.amazon.awscdk.services.iam.Grant.class, java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") }), java.util.Arrays.<Object>stream(actions)).toArray(Object[]::new));
    }

    /**
     * Grant permissions to consume messages from a queue.
     * <p>
     * This will grant the following permissions:
     * <p>
     * <ul>
     * <li>sqs:ChangeMessageVisibility</li>
     * <li>sqs:DeleteMessage</li>
     * <li>sqs:ReceiveMessage</li>
     * <li>sqs:GetQueueAttributes</li>
     * <li>sqs:GetQueueUrl</li>
     * </ul>
     * <p>
     * @param grantee Principal to grant consume rights to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantConsumeMessages(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return this.jsiiCall("grantConsumeMessages", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Grant an IAM principal permissions to purge all messages from the queue.
     * <p>
     * This will grant the following permissions:
     * <p>
     * <ul>
     * <li>sqs:PurgeQueue</li>
     * <li>sqs:GetQueueAttributes</li>
     * <li>sqs:GetQueueUrl</li>
     * </ul>
     * <p>
     * @param grantee Principal to grant send rights to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPurge(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return this.jsiiCall("grantPurge", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Grant access to send messages to a queue to the given identity.
     * <p>
     * This will grant the following permissions:
     * <p>
     * <ul>
     * <li>sqs:SendMessage</li>
     * <li>sqs:GetQueueAttributes</li>
     * <li>sqs:GetQueueUrl</li>
     * </ul>
     * <p>
     * @param grantee Principal to grant send rights to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantSendMessages(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return this.jsiiCall("grantSendMessages", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Return the given named metric for this Queue.
     * <p>
     * @param metricName This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metric", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required"), props });
    }

    /**
     * Return the given named metric for this Queue.
     * <p>
     * @param metricName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName) {
        return this.jsiiCall("metric", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required") });
    }

    /**
     * The approximate age of the oldest non-deleted message in the queue.
     * <p>
     * Maximum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricApproximateAgeOfOldestMessage(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricApproximateAgeOfOldestMessage", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * The approximate age of the oldest non-deleted message in the queue.
     * <p>
     * Maximum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricApproximateAgeOfOldestMessage() {
        return this.jsiiCall("metricApproximateAgeOfOldestMessage", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * The number of messages in the queue that are delayed and not available for reading immediately.
     * <p>
     * Maximum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricApproximateNumberOfMessagesDelayed(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricApproximateNumberOfMessagesDelayed", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * The number of messages in the queue that are delayed and not available for reading immediately.
     * <p>
     * Maximum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricApproximateNumberOfMessagesDelayed() {
        return this.jsiiCall("metricApproximateNumberOfMessagesDelayed", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * The number of messages that are in flight.
     * <p>
     * Maximum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricApproximateNumberOfMessagesNotVisible(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricApproximateNumberOfMessagesNotVisible", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * The number of messages that are in flight.
     * <p>
     * Maximum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricApproximateNumberOfMessagesNotVisible() {
        return this.jsiiCall("metricApproximateNumberOfMessagesNotVisible", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * The number of messages available for retrieval from the queue.
     * <p>
     * Maximum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricApproximateNumberOfMessagesVisible(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricApproximateNumberOfMessagesVisible", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * The number of messages available for retrieval from the queue.
     * <p>
     * Maximum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricApproximateNumberOfMessagesVisible() {
        return this.jsiiCall("metricApproximateNumberOfMessagesVisible", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * The number of ReceiveMessage API calls that did not return a message.
     * <p>
     * Sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumberOfEmptyReceives(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricNumberOfEmptyReceives", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * The number of ReceiveMessage API calls that did not return a message.
     * <p>
     * Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumberOfEmptyReceives() {
        return this.jsiiCall("metricNumberOfEmptyReceives", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * The number of messages deleted from the queue.
     * <p>
     * Sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumberOfMessagesDeleted(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricNumberOfMessagesDeleted", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * The number of messages deleted from the queue.
     * <p>
     * Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumberOfMessagesDeleted() {
        return this.jsiiCall("metricNumberOfMessagesDeleted", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * The number of messages returned by calls to the ReceiveMessage action.
     * <p>
     * Sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumberOfMessagesReceived(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricNumberOfMessagesReceived", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * The number of messages returned by calls to the ReceiveMessage action.
     * <p>
     * Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumberOfMessagesReceived() {
        return this.jsiiCall("metricNumberOfMessagesReceived", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * The number of messages added to a queue.
     * <p>
     * Sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumberOfMessagesSent(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricNumberOfMessagesSent", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * The number of messages added to a queue.
     * <p>
     * Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumberOfMessagesSent() {
        return this.jsiiCall("metricNumberOfMessagesSent", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * The size of messages added to a queue.
     * <p>
     * Average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricSentMessageSize(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricSentMessageSize", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * The size of messages added to a queue.
     * <p>
     * Average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricSentMessageSize() {
        return this.jsiiCall("metricSentMessageSize", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * Validate the current construct.
     * <p>
     * This method can be implemented by derived constructs in order to perform
     * validation logic. It is called on all constructs before synthesis.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> validate() {
        return java.util.Collections.unmodifiableList(this.jsiiCall("validate", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * Controls automatic creation of policy objects.
     * <p>
     * Set by subclasses.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected abstract @org.jetbrains.annotations.NotNull java.lang.Boolean getAutoCreatePolicy();

    /**
     * Whether this queue is an Amazon SQS FIFO queue.
     * <p>
     * If false, this is a standard queue.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull java.lang.Boolean getFifo();

    /**
     * The ARN of this queue.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull java.lang.String getQueueArn();

    /**
     * The name of this queue.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull java.lang.String getQueueName();

    /**
     * The URL of this queue.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull java.lang.String getQueueUrl();

    /**
     * If this queue is server-side encrypted, this is the KMS encryption key.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionMasterKey();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.awscdk.services.sqs.QueueBase {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Controls automatic creation of policy objects.
         * <p>
         * Set by subclasses.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        protected @org.jetbrains.annotations.NotNull java.lang.Boolean getAutoCreatePolicy() {
            return this.jsiiGet("autoCreatePolicy", java.lang.Boolean.class);
        }

        /**
         * Whether this queue is an Amazon SQS FIFO queue.
         * <p>
         * If false, this is a standard queue.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull java.lang.Boolean getFifo() {
            return this.jsiiGet("fifo", java.lang.Boolean.class);
        }

        /**
         * The ARN of this queue.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull java.lang.String getQueueArn() {
            return this.jsiiGet("queueArn", java.lang.String.class);
        }

        /**
         * The name of this queue.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull java.lang.String getQueueName() {
            return this.jsiiGet("queueName", java.lang.String.class);
        }

        /**
         * The URL of this queue.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull java.lang.String getQueueUrl() {
            return this.jsiiGet("queueUrl", java.lang.String.class);
        }

        /**
         * If this queue is server-side encrypted, this is the KMS encryption key.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionMasterKey() {
            return this.jsiiGet("encryptionMasterKey", software.amazon.awscdk.services.kms.IKey.class);
        }

        /**
         * The environment this resource belongs to.
         * <p>
         * For resources that are created and managed by the CDK
         * (generally, those created by creating new class instances like Role, Bucket, etc.),
         * this is always the same as the environment of the stack they belong to;
         * however, for imported resources
         * (those obtained from static methods like fromRoleArn, fromBucketName, etc.),
         * that might be different than the stack they were imported into.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ResourceEnvironment getEnv() {
            return this.jsiiGet("env", software.amazon.awscdk.core.ResourceEnvironment.class);
        }

        /**
         * The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Stack getStack() {
            return this.jsiiGet("stack", software.amazon.awscdk.core.Stack.class);
        }

        /**
         * The construct tree node for this construct.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ConstructNode getNode() {
            return this.jsiiGet("node", software.amazon.awscdk.core.ConstructNode.class);
        }

        /**
         * Adds a statement to the IAM resource policy associated with this queue.
         * <p>
         * If this queue was created in this stack (<code>new Queue</code>), a queue policy
         * will be automatically created upon the first call to <code>addToPolicy</code>. If
         * the queue is imported (<code>Queue.import</code>), then this is a no-op.
         * <p>
         * @param statement This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.AddToResourcePolicyResult addToResourcePolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement) {
            return this.jsiiCall("addToResourcePolicy", software.amazon.awscdk.services.iam.AddToResourcePolicyResult.class, new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
        }

        /**
         * Grant the actions defined in queueActions to the identity Principal given on this SQS queue resource.
         * <p>
         * @param grantee Principal to grant right to. This parameter is required.
         * @param queueActions The actions to grant. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grant(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.lang.String... queueActions) {
            return this.jsiiCall("grant", software.amazon.awscdk.services.iam.Grant.class, java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") }), java.util.Arrays.<Object>stream(queueActions)).toArray(Object[]::new));
        }

        /**
         * Grant permissions to consume messages from a queue.
         * <p>
         * This will grant the following permissions:
         * <p>
         * <ul>
         * <li>sqs:ChangeMessageVisibility</li>
         * <li>sqs:DeleteMessage</li>
         * <li>sqs:ReceiveMessage</li>
         * <li>sqs:GetQueueAttributes</li>
         * <li>sqs:GetQueueUrl</li>
         * </ul>
         * <p>
         * @param grantee Principal to grant consume rights to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantConsumeMessages(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
            return this.jsiiCall("grantConsumeMessages", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
        }

        /**
         * Grant an IAM principal permissions to purge all messages from the queue.
         * <p>
         * This will grant the following permissions:
         * <p>
         * <ul>
         * <li>sqs:PurgeQueue</li>
         * <li>sqs:GetQueueAttributes</li>
         * <li>sqs:GetQueueUrl</li>
         * </ul>
         * <p>
         * @param grantee Principal to grant send rights to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPurge(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
            return this.jsiiCall("grantPurge", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
        }

        /**
         * Grant access to send messages to a queue to the given identity.
         * <p>
         * This will grant the following permissions:
         * <p>
         * <ul>
         * <li>sqs:SendMessage</li>
         * <li>sqs:GetQueueAttributes</li>
         * <li>sqs:GetQueueUrl</li>
         * </ul>
         * <p>
         * @param grantee Principal to grant send rights to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantSendMessages(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
            return this.jsiiCall("grantSendMessages", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
        }

        /**
         * Return the given named metric for this Queue.
         * <p>
         * @param metricName This parameter is required.
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return this.jsiiCall("metric", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required"), props });
        }

        /**
         * Return the given named metric for this Queue.
         * <p>
         * @param metricName This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName) {
            return this.jsiiCall("metric", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required") });
        }

        /**
         * The approximate age of the oldest non-deleted message in the queue.
         * <p>
         * Maximum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricApproximateAgeOfOldestMessage(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return this.jsiiCall("metricApproximateAgeOfOldestMessage", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
        }

        /**
         * The approximate age of the oldest non-deleted message in the queue.
         * <p>
         * Maximum over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricApproximateAgeOfOldestMessage() {
            return this.jsiiCall("metricApproximateAgeOfOldestMessage", software.amazon.awscdk.services.cloudwatch.Metric.class);
        }

        /**
         * The number of messages in the queue that are delayed and not available for reading immediately.
         * <p>
         * Maximum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricApproximateNumberOfMessagesDelayed(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return this.jsiiCall("metricApproximateNumberOfMessagesDelayed", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
        }

        /**
         * The number of messages in the queue that are delayed and not available for reading immediately.
         * <p>
         * Maximum over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricApproximateNumberOfMessagesDelayed() {
            return this.jsiiCall("metricApproximateNumberOfMessagesDelayed", software.amazon.awscdk.services.cloudwatch.Metric.class);
        }

        /**
         * The number of messages that are in flight.
         * <p>
         * Maximum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricApproximateNumberOfMessagesNotVisible(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return this.jsiiCall("metricApproximateNumberOfMessagesNotVisible", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
        }

        /**
         * The number of messages that are in flight.
         * <p>
         * Maximum over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricApproximateNumberOfMessagesNotVisible() {
            return this.jsiiCall("metricApproximateNumberOfMessagesNotVisible", software.amazon.awscdk.services.cloudwatch.Metric.class);
        }

        /**
         * The number of messages available for retrieval from the queue.
         * <p>
         * Maximum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricApproximateNumberOfMessagesVisible(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return this.jsiiCall("metricApproximateNumberOfMessagesVisible", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
        }

        /**
         * The number of messages available for retrieval from the queue.
         * <p>
         * Maximum over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricApproximateNumberOfMessagesVisible() {
            return this.jsiiCall("metricApproximateNumberOfMessagesVisible", software.amazon.awscdk.services.cloudwatch.Metric.class);
        }

        /**
         * The number of ReceiveMessage API calls that did not return a message.
         * <p>
         * Sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumberOfEmptyReceives(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return this.jsiiCall("metricNumberOfEmptyReceives", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
        }

        /**
         * The number of ReceiveMessage API calls that did not return a message.
         * <p>
         * Sum over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumberOfEmptyReceives() {
            return this.jsiiCall("metricNumberOfEmptyReceives", software.amazon.awscdk.services.cloudwatch.Metric.class);
        }

        /**
         * The number of messages deleted from the queue.
         * <p>
         * Sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumberOfMessagesDeleted(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return this.jsiiCall("metricNumberOfMessagesDeleted", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
        }

        /**
         * The number of messages deleted from the queue.
         * <p>
         * Sum over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumberOfMessagesDeleted() {
            return this.jsiiCall("metricNumberOfMessagesDeleted", software.amazon.awscdk.services.cloudwatch.Metric.class);
        }

        /**
         * The number of messages returned by calls to the ReceiveMessage action.
         * <p>
         * Sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumberOfMessagesReceived(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return this.jsiiCall("metricNumberOfMessagesReceived", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
        }

        /**
         * The number of messages returned by calls to the ReceiveMessage action.
         * <p>
         * Sum over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumberOfMessagesReceived() {
            return this.jsiiCall("metricNumberOfMessagesReceived", software.amazon.awscdk.services.cloudwatch.Metric.class);
        }

        /**
         * The number of messages added to a queue.
         * <p>
         * Sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumberOfMessagesSent(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return this.jsiiCall("metricNumberOfMessagesSent", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
        }

        /**
         * The number of messages added to a queue.
         * <p>
         * Sum over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumberOfMessagesSent() {
            return this.jsiiCall("metricNumberOfMessagesSent", software.amazon.awscdk.services.cloudwatch.Metric.class);
        }

        /**
         * The size of messages added to a queue.
         * <p>
         * Average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricSentMessageSize(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return this.jsiiCall("metricSentMessageSize", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
        }

        /**
         * The size of messages added to a queue.
         * <p>
         * Average over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricSentMessageSize() {
            return this.jsiiCall("metricSentMessageSize", software.amazon.awscdk.services.cloudwatch.Metric.class);
        }
    }
}
