package software.amazon.awscdk.services.sqs;

/**
 * Dead letter queue settings.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:12.336Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sqs.$Module.class, fqn = "@aws-cdk/aws-sqs.DeadLetterQueue")
@software.amazon.jsii.Jsii.Proxy(DeadLetterQueue.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DeadLetterQueue extends software.amazon.jsii.JsiiSerializable {

    /**
     * The number of times a message can be unsuccesfully dequeued before being moved to the dead-letter queue.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getMaxReceiveCount();

    /**
     * The dead-letter queue to which Amazon SQS moves messages after the value of maxReceiveCount is exceeded.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sqs.IQueue getQueue();

    /**
     * @return a {@link Builder} of {@link DeadLetterQueue}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DeadLetterQueue}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DeadLetterQueue> {
        private java.lang.Number maxReceiveCount;
        private software.amazon.awscdk.services.sqs.IQueue queue;

        /**
         * Sets the value of {@link DeadLetterQueue#getMaxReceiveCount}
         * @param maxReceiveCount The number of times a message can be unsuccesfully dequeued before being moved to the dead-letter queue. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxReceiveCount(java.lang.Number maxReceiveCount) {
            this.maxReceiveCount = maxReceiveCount;
            return this;
        }

        /**
         * Sets the value of {@link DeadLetterQueue#getQueue}
         * @param queue The dead-letter queue to which Amazon SQS moves messages after the value of maxReceiveCount is exceeded. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queue(software.amazon.awscdk.services.sqs.IQueue queue) {
            this.queue = queue;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DeadLetterQueue}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DeadLetterQueue build() {
            return new Jsii$Proxy(maxReceiveCount, queue);
        }
    }

    /**
     * An implementation for {@link DeadLetterQueue}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeadLetterQueue {
        private final java.lang.Number maxReceiveCount;
        private final software.amazon.awscdk.services.sqs.IQueue queue;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.maxReceiveCount = this.jsiiGet("maxReceiveCount", java.lang.Number.class);
            this.queue = this.jsiiGet("queue", software.amazon.awscdk.services.sqs.IQueue.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.Number maxReceiveCount, final software.amazon.awscdk.services.sqs.IQueue queue) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.maxReceiveCount = java.util.Objects.requireNonNull(maxReceiveCount, "maxReceiveCount is required");
            this.queue = java.util.Objects.requireNonNull(queue, "queue is required");
        }

        @Override
        public java.lang.Number getMaxReceiveCount() {
            return this.maxReceiveCount;
        }

        @Override
        public software.amazon.awscdk.services.sqs.IQueue getQueue() {
            return this.queue;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("maxReceiveCount", om.valueToTree(this.getMaxReceiveCount()));
            data.set("queue", om.valueToTree(this.getQueue()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-sqs.DeadLetterQueue"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DeadLetterQueue.Jsii$Proxy that = (DeadLetterQueue.Jsii$Proxy) o;

            if (!maxReceiveCount.equals(that.maxReceiveCount)) return false;
            return this.queue.equals(that.queue);
        }

        @Override
        public int hashCode() {
            int result = this.maxReceiveCount.hashCode();
            result = 31 * result + (this.queue.hashCode());
            return result;
        }
    }
}
