package software.amazon.awscdk.services.sqs;

/**
 * Properties for defining a `AWS::SQS::Queue`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:12.336Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sqs.$Module.class, fqn = "@aws-cdk/aws-sqs.CfnQueueProps")
@software.amazon.jsii.Jsii.Proxy(CfnQueueProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnQueueProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::SQS::Queue.ContentBasedDeduplication`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-contentbaseddeduplication
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getContentBasedDeduplication() {
        return null;
    }

    /**
     * `AWS::SQS::Queue.DelaySeconds`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-delayseconds
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getDelaySeconds() {
        return null;
    }

    /**
     * `AWS::SQS::Queue.FifoQueue`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-fifoqueue
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getFifoQueue() {
        return null;
    }

    /**
     * `AWS::SQS::Queue.KmsDataKeyReusePeriodSeconds`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-kmsdatakeyreuseperiodseconds
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getKmsDataKeyReusePeriodSeconds() {
        return null;
    }

    /**
     * `AWS::SQS::Queue.KmsMasterKeyId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-kmsmasterkeyid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsMasterKeyId() {
        return null;
    }

    /**
     * `AWS::SQS::Queue.MaximumMessageSize`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-maxmesgsize
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumMessageSize() {
        return null;
    }

    /**
     * `AWS::SQS::Queue.MessageRetentionPeriod`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-msgretentionperiod
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMessageRetentionPeriod() {
        return null;
    }

    /**
     * `AWS::SQS::Queue.QueueName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getQueueName() {
        return null;
    }

    /**
     * `AWS::SQS::Queue.ReceiveMessageWaitTimeSeconds`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-receivemsgwaittime
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getReceiveMessageWaitTimeSeconds() {
        return null;
    }

    /**
     * `AWS::SQS::Queue.RedrivePolicy`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-redrive
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRedrivePolicy() {
        return null;
    }

    /**
     * `AWS::SQS::Queue.Tags`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#cfn-sqs-queue-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * `AWS::SQS::Queue.VisibilityTimeout`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-visiblitytimeout
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getVisibilityTimeout() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnQueueProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnQueueProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnQueueProps> {
        private java.lang.Object contentBasedDeduplication;
        private java.lang.Number delaySeconds;
        private java.lang.Object fifoQueue;
        private java.lang.Number kmsDataKeyReusePeriodSeconds;
        private java.lang.String kmsMasterKeyId;
        private java.lang.Number maximumMessageSize;
        private java.lang.Number messageRetentionPeriod;
        private java.lang.String queueName;
        private java.lang.Number receiveMessageWaitTimeSeconds;
        private java.lang.Object redrivePolicy;
        private java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        private java.lang.Number visibilityTimeout;

        /**
         * Sets the value of {@link CfnQueueProps#getContentBasedDeduplication}
         * @param contentBasedDeduplication `AWS::SQS::Queue.ContentBasedDeduplication`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentBasedDeduplication(java.lang.Boolean contentBasedDeduplication) {
            this.contentBasedDeduplication = contentBasedDeduplication;
            return this;
        }

        /**
         * Sets the value of {@link CfnQueueProps#getContentBasedDeduplication}
         * @param contentBasedDeduplication `AWS::SQS::Queue.ContentBasedDeduplication`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentBasedDeduplication(software.amazon.awscdk.core.IResolvable contentBasedDeduplication) {
            this.contentBasedDeduplication = contentBasedDeduplication;
            return this;
        }

        /**
         * Sets the value of {@link CfnQueueProps#getDelaySeconds}
         * @param delaySeconds `AWS::SQS::Queue.DelaySeconds`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder delaySeconds(java.lang.Number delaySeconds) {
            this.delaySeconds = delaySeconds;
            return this;
        }

        /**
         * Sets the value of {@link CfnQueueProps#getFifoQueue}
         * @param fifoQueue `AWS::SQS::Queue.FifoQueue`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fifoQueue(java.lang.Boolean fifoQueue) {
            this.fifoQueue = fifoQueue;
            return this;
        }

        /**
         * Sets the value of {@link CfnQueueProps#getFifoQueue}
         * @param fifoQueue `AWS::SQS::Queue.FifoQueue`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fifoQueue(software.amazon.awscdk.core.IResolvable fifoQueue) {
            this.fifoQueue = fifoQueue;
            return this;
        }

        /**
         * Sets the value of {@link CfnQueueProps#getKmsDataKeyReusePeriodSeconds}
         * @param kmsDataKeyReusePeriodSeconds `AWS::SQS::Queue.KmsDataKeyReusePeriodSeconds`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsDataKeyReusePeriodSeconds(java.lang.Number kmsDataKeyReusePeriodSeconds) {
            this.kmsDataKeyReusePeriodSeconds = kmsDataKeyReusePeriodSeconds;
            return this;
        }

        /**
         * Sets the value of {@link CfnQueueProps#getKmsMasterKeyId}
         * @param kmsMasterKeyId `AWS::SQS::Queue.KmsMasterKeyId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsMasterKeyId(java.lang.String kmsMasterKeyId) {
            this.kmsMasterKeyId = kmsMasterKeyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnQueueProps#getMaximumMessageSize}
         * @param maximumMessageSize `AWS::SQS::Queue.MaximumMessageSize`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maximumMessageSize(java.lang.Number maximumMessageSize) {
            this.maximumMessageSize = maximumMessageSize;
            return this;
        }

        /**
         * Sets the value of {@link CfnQueueProps#getMessageRetentionPeriod}
         * @param messageRetentionPeriod `AWS::SQS::Queue.MessageRetentionPeriod`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder messageRetentionPeriod(java.lang.Number messageRetentionPeriod) {
            this.messageRetentionPeriod = messageRetentionPeriod;
            return this;
        }

        /**
         * Sets the value of {@link CfnQueueProps#getQueueName}
         * @param queueName `AWS::SQS::Queue.QueueName`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queueName(java.lang.String queueName) {
            this.queueName = queueName;
            return this;
        }

        /**
         * Sets the value of {@link CfnQueueProps#getReceiveMessageWaitTimeSeconds}
         * @param receiveMessageWaitTimeSeconds `AWS::SQS::Queue.ReceiveMessageWaitTimeSeconds`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder receiveMessageWaitTimeSeconds(java.lang.Number receiveMessageWaitTimeSeconds) {
            this.receiveMessageWaitTimeSeconds = receiveMessageWaitTimeSeconds;
            return this;
        }

        /**
         * Sets the value of {@link CfnQueueProps#getRedrivePolicy}
         * @param redrivePolicy `AWS::SQS::Queue.RedrivePolicy`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder redrivePolicy(java.lang.Object redrivePolicy) {
            this.redrivePolicy = redrivePolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnQueueProps#getTags}
         * @param tags `AWS::SQS::Queue.Tags`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnQueueProps#getVisibilityTimeout}
         * @param visibilityTimeout `AWS::SQS::Queue.VisibilityTimeout`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder visibilityTimeout(java.lang.Number visibilityTimeout) {
            this.visibilityTimeout = visibilityTimeout;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnQueueProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnQueueProps build() {
            return new Jsii$Proxy(contentBasedDeduplication, delaySeconds, fifoQueue, kmsDataKeyReusePeriodSeconds, kmsMasterKeyId, maximumMessageSize, messageRetentionPeriod, queueName, receiveMessageWaitTimeSeconds, redrivePolicy, tags, visibilityTimeout);
        }
    }

    /**
     * An implementation for {@link CfnQueueProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnQueueProps {
        private final java.lang.Object contentBasedDeduplication;
        private final java.lang.Number delaySeconds;
        private final java.lang.Object fifoQueue;
        private final java.lang.Number kmsDataKeyReusePeriodSeconds;
        private final java.lang.String kmsMasterKeyId;
        private final java.lang.Number maximumMessageSize;
        private final java.lang.Number messageRetentionPeriod;
        private final java.lang.String queueName;
        private final java.lang.Number receiveMessageWaitTimeSeconds;
        private final java.lang.Object redrivePolicy;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        private final java.lang.Number visibilityTimeout;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.contentBasedDeduplication = this.jsiiGet("contentBasedDeduplication", java.lang.Object.class);
            this.delaySeconds = this.jsiiGet("delaySeconds", java.lang.Number.class);
            this.fifoQueue = this.jsiiGet("fifoQueue", java.lang.Object.class);
            this.kmsDataKeyReusePeriodSeconds = this.jsiiGet("kmsDataKeyReusePeriodSeconds", java.lang.Number.class);
            this.kmsMasterKeyId = this.jsiiGet("kmsMasterKeyId", java.lang.String.class);
            this.maximumMessageSize = this.jsiiGet("maximumMessageSize", java.lang.Number.class);
            this.messageRetentionPeriod = this.jsiiGet("messageRetentionPeriod", java.lang.Number.class);
            this.queueName = this.jsiiGet("queueName", java.lang.String.class);
            this.receiveMessageWaitTimeSeconds = this.jsiiGet("receiveMessageWaitTimeSeconds", java.lang.Number.class);
            this.redrivePolicy = this.jsiiGet("redrivePolicy", java.lang.Object.class);
            this.tags = this.jsiiGet("tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
            this.visibilityTimeout = this.jsiiGet("visibilityTimeout", java.lang.Number.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.Object contentBasedDeduplication, final java.lang.Number delaySeconds, final java.lang.Object fifoQueue, final java.lang.Number kmsDataKeyReusePeriodSeconds, final java.lang.String kmsMasterKeyId, final java.lang.Number maximumMessageSize, final java.lang.Number messageRetentionPeriod, final java.lang.String queueName, final java.lang.Number receiveMessageWaitTimeSeconds, final java.lang.Object redrivePolicy, final java.util.List<software.amazon.awscdk.core.CfnTag> tags, final java.lang.Number visibilityTimeout) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.contentBasedDeduplication = contentBasedDeduplication;
            this.delaySeconds = delaySeconds;
            this.fifoQueue = fifoQueue;
            this.kmsDataKeyReusePeriodSeconds = kmsDataKeyReusePeriodSeconds;
            this.kmsMasterKeyId = kmsMasterKeyId;
            this.maximumMessageSize = maximumMessageSize;
            this.messageRetentionPeriod = messageRetentionPeriod;
            this.queueName = queueName;
            this.receiveMessageWaitTimeSeconds = receiveMessageWaitTimeSeconds;
            this.redrivePolicy = redrivePolicy;
            this.tags = tags;
            this.visibilityTimeout = visibilityTimeout;
        }

        @Override
        public java.lang.Object getContentBasedDeduplication() {
            return this.contentBasedDeduplication;
        }

        @Override
        public java.lang.Number getDelaySeconds() {
            return this.delaySeconds;
        }

        @Override
        public java.lang.Object getFifoQueue() {
            return this.fifoQueue;
        }

        @Override
        public java.lang.Number getKmsDataKeyReusePeriodSeconds() {
            return this.kmsDataKeyReusePeriodSeconds;
        }

        @Override
        public java.lang.String getKmsMasterKeyId() {
            return this.kmsMasterKeyId;
        }

        @Override
        public java.lang.Number getMaximumMessageSize() {
            return this.maximumMessageSize;
        }

        @Override
        public java.lang.Number getMessageRetentionPeriod() {
            return this.messageRetentionPeriod;
        }

        @Override
        public java.lang.String getQueueName() {
            return this.queueName;
        }

        @Override
        public java.lang.Number getReceiveMessageWaitTimeSeconds() {
            return this.receiveMessageWaitTimeSeconds;
        }

        @Override
        public java.lang.Object getRedrivePolicy() {
            return this.redrivePolicy;
        }

        @Override
        public java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public java.lang.Number getVisibilityTimeout() {
            return this.visibilityTimeout;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getContentBasedDeduplication() != null) {
                data.set("contentBasedDeduplication", om.valueToTree(this.getContentBasedDeduplication()));
            }
            if (this.getDelaySeconds() != null) {
                data.set("delaySeconds", om.valueToTree(this.getDelaySeconds()));
            }
            if (this.getFifoQueue() != null) {
                data.set("fifoQueue", om.valueToTree(this.getFifoQueue()));
            }
            if (this.getKmsDataKeyReusePeriodSeconds() != null) {
                data.set("kmsDataKeyReusePeriodSeconds", om.valueToTree(this.getKmsDataKeyReusePeriodSeconds()));
            }
            if (this.getKmsMasterKeyId() != null) {
                data.set("kmsMasterKeyId", om.valueToTree(this.getKmsMasterKeyId()));
            }
            if (this.getMaximumMessageSize() != null) {
                data.set("maximumMessageSize", om.valueToTree(this.getMaximumMessageSize()));
            }
            if (this.getMessageRetentionPeriod() != null) {
                data.set("messageRetentionPeriod", om.valueToTree(this.getMessageRetentionPeriod()));
            }
            if (this.getQueueName() != null) {
                data.set("queueName", om.valueToTree(this.getQueueName()));
            }
            if (this.getReceiveMessageWaitTimeSeconds() != null) {
                data.set("receiveMessageWaitTimeSeconds", om.valueToTree(this.getReceiveMessageWaitTimeSeconds()));
            }
            if (this.getRedrivePolicy() != null) {
                data.set("redrivePolicy", om.valueToTree(this.getRedrivePolicy()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getVisibilityTimeout() != null) {
                data.set("visibilityTimeout", om.valueToTree(this.getVisibilityTimeout()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-sqs.CfnQueueProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnQueueProps.Jsii$Proxy that = (CfnQueueProps.Jsii$Proxy) o;

            if (this.contentBasedDeduplication != null ? !this.contentBasedDeduplication.equals(that.contentBasedDeduplication) : that.contentBasedDeduplication != null) return false;
            if (this.delaySeconds != null ? !this.delaySeconds.equals(that.delaySeconds) : that.delaySeconds != null) return false;
            if (this.fifoQueue != null ? !this.fifoQueue.equals(that.fifoQueue) : that.fifoQueue != null) return false;
            if (this.kmsDataKeyReusePeriodSeconds != null ? !this.kmsDataKeyReusePeriodSeconds.equals(that.kmsDataKeyReusePeriodSeconds) : that.kmsDataKeyReusePeriodSeconds != null) return false;
            if (this.kmsMasterKeyId != null ? !this.kmsMasterKeyId.equals(that.kmsMasterKeyId) : that.kmsMasterKeyId != null) return false;
            if (this.maximumMessageSize != null ? !this.maximumMessageSize.equals(that.maximumMessageSize) : that.maximumMessageSize != null) return false;
            if (this.messageRetentionPeriod != null ? !this.messageRetentionPeriod.equals(that.messageRetentionPeriod) : that.messageRetentionPeriod != null) return false;
            if (this.queueName != null ? !this.queueName.equals(that.queueName) : that.queueName != null) return false;
            if (this.receiveMessageWaitTimeSeconds != null ? !this.receiveMessageWaitTimeSeconds.equals(that.receiveMessageWaitTimeSeconds) : that.receiveMessageWaitTimeSeconds != null) return false;
            if (this.redrivePolicy != null ? !this.redrivePolicy.equals(that.redrivePolicy) : that.redrivePolicy != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.visibilityTimeout != null ? this.visibilityTimeout.equals(that.visibilityTimeout) : that.visibilityTimeout == null;
        }

        @Override
        public int hashCode() {
            int result = this.contentBasedDeduplication != null ? this.contentBasedDeduplication.hashCode() : 0;
            result = 31 * result + (this.delaySeconds != null ? this.delaySeconds.hashCode() : 0);
            result = 31 * result + (this.fifoQueue != null ? this.fifoQueue.hashCode() : 0);
            result = 31 * result + (this.kmsDataKeyReusePeriodSeconds != null ? this.kmsDataKeyReusePeriodSeconds.hashCode() : 0);
            result = 31 * result + (this.kmsMasterKeyId != null ? this.kmsMasterKeyId.hashCode() : 0);
            result = 31 * result + (this.maximumMessageSize != null ? this.maximumMessageSize.hashCode() : 0);
            result = 31 * result + (this.messageRetentionPeriod != null ? this.messageRetentionPeriod.hashCode() : 0);
            result = 31 * result + (this.queueName != null ? this.queueName.hashCode() : 0);
            result = 31 * result + (this.receiveMessageWaitTimeSeconds != null ? this.receiveMessageWaitTimeSeconds.hashCode() : 0);
            result = 31 * result + (this.redrivePolicy != null ? this.redrivePolicy.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.visibilityTimeout != null ? this.visibilityTimeout.hashCode() : 0);
            return result;
        }
    }
}
