package software.amazon.awscdk.services.sqs;

/**
 * Properties for defining a `AWS::SQS::QueuePolicy`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-policy.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:12.335Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sqs.$Module.class, fqn = "@aws-cdk/aws-sqs.CfnQueuePolicyProps")
@software.amazon.jsii.Jsii.Proxy(CfnQueuePolicyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnQueuePolicyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::SQS::QueuePolicy.PolicyDocument`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-policy.html#cfn-sqs-queuepolicy-policydoc
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getPolicyDocument();

    /**
     * `AWS::SQS::QueuePolicy.Queues`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-policy.html#cfn-sqs-queuepolicy-queues
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getQueues();

    /**
     * @return a {@link Builder} of {@link CfnQueuePolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnQueuePolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnQueuePolicyProps> {
        private java.lang.Object policyDocument;
        private java.util.List<java.lang.String> queues;

        /**
         * Sets the value of {@link CfnQueuePolicyProps#getPolicyDocument}
         * @param policyDocument `AWS::SQS::QueuePolicy.PolicyDocument`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyDocument(java.lang.Object policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        /**
         * Sets the value of {@link CfnQueuePolicyProps#getQueues}
         * @param queues `AWS::SQS::QueuePolicy.Queues`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queues(java.util.List<java.lang.String> queues) {
            this.queues = queues;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnQueuePolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnQueuePolicyProps build() {
            return new Jsii$Proxy(policyDocument, queues);
        }
    }

    /**
     * An implementation for {@link CfnQueuePolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnQueuePolicyProps {
        private final java.lang.Object policyDocument;
        private final java.util.List<java.lang.String> queues;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.policyDocument = this.jsiiGet("policyDocument", java.lang.Object.class);
            this.queues = this.jsiiGet("queues", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.Object policyDocument, final java.util.List<java.lang.String> queues) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.policyDocument = java.util.Objects.requireNonNull(policyDocument, "policyDocument is required");
            this.queues = java.util.Objects.requireNonNull(queues, "queues is required");
        }

        @Override
        public java.lang.Object getPolicyDocument() {
            return this.policyDocument;
        }

        @Override
        public java.util.List<java.lang.String> getQueues() {
            return this.queues;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("policyDocument", om.valueToTree(this.getPolicyDocument()));
            data.set("queues", om.valueToTree(this.getQueues()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-sqs.CfnQueuePolicyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnQueuePolicyProps.Jsii$Proxy that = (CfnQueuePolicyProps.Jsii$Proxy) o;

            if (!policyDocument.equals(that.policyDocument)) return false;
            return this.queues.equals(that.queues);
        }

        @Override
        public int hashCode() {
            int result = this.policyDocument.hashCode();
            result = 31 * result + (this.queues.hashCode());
            return result;
        }
    }
}
