package software.amazon.awscdk.services.sqs;

/**
 * A CloudFormation `AWS::SQS::Queue`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:12.334Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sqs.$Module.class, fqn = "@aws-cdk/aws-sqs.CfnQueue")
public class CfnQueue extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnQueue(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnQueue(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.sqs.CfnQueue.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::SQS::Queue`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnQueue(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sqs.CfnQueueProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new `AWS::SQS::Queue`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnQueue(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        this.jsiiCall("inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return this.jsiiGet("attrArn", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrQueueName() {
        return this.jsiiGet("attrQueueName", java.lang.String.class);
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::SQS::Queue.Tags`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#cfn-sqs-queue-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return this.jsiiGet("tags", software.amazon.awscdk.core.TagManager.class);
    }

    /**
     * `AWS::SQS::Queue.RedrivePolicy`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-redrive
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getRedrivePolicy() {
        return this.jsiiGet("redrivePolicy", java.lang.Object.class);
    }

    /**
     * `AWS::SQS::Queue.RedrivePolicy`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-redrive
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRedrivePolicy(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        this.jsiiSet("redrivePolicy", java.util.Objects.requireNonNull(value, "redrivePolicy is required"));
    }

    /**
     * `AWS::SQS::Queue.ContentBasedDeduplication`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-contentbaseddeduplication
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getContentBasedDeduplication() {
        return this.jsiiGet("contentBasedDeduplication", java.lang.Object.class);
    }

    /**
     * `AWS::SQS::Queue.ContentBasedDeduplication`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-contentbaseddeduplication
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setContentBasedDeduplication(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        this.jsiiSet("contentBasedDeduplication", value);
    }

    /**
     * `AWS::SQS::Queue.ContentBasedDeduplication`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-contentbaseddeduplication
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setContentBasedDeduplication(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("contentBasedDeduplication", value);
    }

    /**
     * `AWS::SQS::Queue.DelaySeconds`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-delayseconds
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getDelaySeconds() {
        return this.jsiiGet("delaySeconds", java.lang.Number.class);
    }

    /**
     * `AWS::SQS::Queue.DelaySeconds`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-delayseconds
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDelaySeconds(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        this.jsiiSet("delaySeconds", value);
    }

    /**
     * `AWS::SQS::Queue.FifoQueue`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-fifoqueue
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getFifoQueue() {
        return this.jsiiGet("fifoQueue", java.lang.Object.class);
    }

    /**
     * `AWS::SQS::Queue.FifoQueue`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-fifoqueue
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFifoQueue(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        this.jsiiSet("fifoQueue", value);
    }

    /**
     * `AWS::SQS::Queue.FifoQueue`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-fifoqueue
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFifoQueue(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("fifoQueue", value);
    }

    /**
     * `AWS::SQS::Queue.KmsDataKeyReusePeriodSeconds`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-kmsdatakeyreuseperiodseconds
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getKmsDataKeyReusePeriodSeconds() {
        return this.jsiiGet("kmsDataKeyReusePeriodSeconds", java.lang.Number.class);
    }

    /**
     * `AWS::SQS::Queue.KmsDataKeyReusePeriodSeconds`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-kmsdatakeyreuseperiodseconds
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKmsDataKeyReusePeriodSeconds(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        this.jsiiSet("kmsDataKeyReusePeriodSeconds", value);
    }

    /**
     * `AWS::SQS::Queue.KmsMasterKeyId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-kmsmasterkeyid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKmsMasterKeyId() {
        return this.jsiiGet("kmsMasterKeyId", java.lang.String.class);
    }

    /**
     * `AWS::SQS::Queue.KmsMasterKeyId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-kmsmasterkeyid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKmsMasterKeyId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("kmsMasterKeyId", value);
    }

    /**
     * `AWS::SQS::Queue.MaximumMessageSize`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-maxmesgsize
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getMaximumMessageSize() {
        return this.jsiiGet("maximumMessageSize", java.lang.Number.class);
    }

    /**
     * `AWS::SQS::Queue.MaximumMessageSize`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-maxmesgsize
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaximumMessageSize(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        this.jsiiSet("maximumMessageSize", value);
    }

    /**
     * `AWS::SQS::Queue.MessageRetentionPeriod`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-msgretentionperiod
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getMessageRetentionPeriod() {
        return this.jsiiGet("messageRetentionPeriod", java.lang.Number.class);
    }

    /**
     * `AWS::SQS::Queue.MessageRetentionPeriod`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-msgretentionperiod
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMessageRetentionPeriod(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        this.jsiiSet("messageRetentionPeriod", value);
    }

    /**
     * `AWS::SQS::Queue.QueueName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getQueueName() {
        return this.jsiiGet("queueName", java.lang.String.class);
    }

    /**
     * `AWS::SQS::Queue.QueueName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setQueueName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("queueName", value);
    }

    /**
     * `AWS::SQS::Queue.ReceiveMessageWaitTimeSeconds`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-receivemsgwaittime
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getReceiveMessageWaitTimeSeconds() {
        return this.jsiiGet("receiveMessageWaitTimeSeconds", java.lang.Number.class);
    }

    /**
     * `AWS::SQS::Queue.ReceiveMessageWaitTimeSeconds`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-receivemsgwaittime
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReceiveMessageWaitTimeSeconds(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        this.jsiiSet("receiveMessageWaitTimeSeconds", value);
    }

    /**
     * `AWS::SQS::Queue.VisibilityTimeout`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-visiblitytimeout
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getVisibilityTimeout() {
        return this.jsiiGet("visibilityTimeout", java.lang.Number.class);
    }

    /**
     * `AWS::SQS::Queue.VisibilityTimeout`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-visiblitytimeout
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVisibilityTimeout(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        this.jsiiSet("visibilityTimeout", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.sqs.CfnQueue}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.sqs.CfnQueue> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.sqs.CfnQueueProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * `AWS::SQS::Queue.ContentBasedDeduplication`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-contentbaseddeduplication
         * @param contentBasedDeduplication `AWS::SQS::Queue.ContentBasedDeduplication`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentBasedDeduplication(final java.lang.Boolean contentBasedDeduplication) {
            this.props().contentBasedDeduplication(contentBasedDeduplication);
            return this;
        }
        /**
         * `AWS::SQS::Queue.ContentBasedDeduplication`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-contentbaseddeduplication
         * @param contentBasedDeduplication `AWS::SQS::Queue.ContentBasedDeduplication`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentBasedDeduplication(final software.amazon.awscdk.core.IResolvable contentBasedDeduplication) {
            this.props().contentBasedDeduplication(contentBasedDeduplication);
            return this;
        }

        /**
         * `AWS::SQS::Queue.DelaySeconds`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-delayseconds
         * @param delaySeconds `AWS::SQS::Queue.DelaySeconds`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder delaySeconds(final java.lang.Number delaySeconds) {
            this.props().delaySeconds(delaySeconds);
            return this;
        }

        /**
         * `AWS::SQS::Queue.FifoQueue`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-fifoqueue
         * @param fifoQueue `AWS::SQS::Queue.FifoQueue`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fifoQueue(final java.lang.Boolean fifoQueue) {
            this.props().fifoQueue(fifoQueue);
            return this;
        }
        /**
         * `AWS::SQS::Queue.FifoQueue`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-fifoqueue
         * @param fifoQueue `AWS::SQS::Queue.FifoQueue`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fifoQueue(final software.amazon.awscdk.core.IResolvable fifoQueue) {
            this.props().fifoQueue(fifoQueue);
            return this;
        }

        /**
         * `AWS::SQS::Queue.KmsDataKeyReusePeriodSeconds`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-kmsdatakeyreuseperiodseconds
         * @param kmsDataKeyReusePeriodSeconds `AWS::SQS::Queue.KmsDataKeyReusePeriodSeconds`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsDataKeyReusePeriodSeconds(final java.lang.Number kmsDataKeyReusePeriodSeconds) {
            this.props().kmsDataKeyReusePeriodSeconds(kmsDataKeyReusePeriodSeconds);
            return this;
        }

        /**
         * `AWS::SQS::Queue.KmsMasterKeyId`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-kmsmasterkeyid
         * @param kmsMasterKeyId `AWS::SQS::Queue.KmsMasterKeyId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsMasterKeyId(final java.lang.String kmsMasterKeyId) {
            this.props().kmsMasterKeyId(kmsMasterKeyId);
            return this;
        }

        /**
         * `AWS::SQS::Queue.MaximumMessageSize`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-maxmesgsize
         * @param maximumMessageSize `AWS::SQS::Queue.MaximumMessageSize`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maximumMessageSize(final java.lang.Number maximumMessageSize) {
            this.props().maximumMessageSize(maximumMessageSize);
            return this;
        }

        /**
         * `AWS::SQS::Queue.MessageRetentionPeriod`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-msgretentionperiod
         * @param messageRetentionPeriod `AWS::SQS::Queue.MessageRetentionPeriod`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder messageRetentionPeriod(final java.lang.Number messageRetentionPeriod) {
            this.props().messageRetentionPeriod(messageRetentionPeriod);
            return this;
        }

        /**
         * `AWS::SQS::Queue.QueueName`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-name
         * @param queueName `AWS::SQS::Queue.QueueName`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queueName(final java.lang.String queueName) {
            this.props().queueName(queueName);
            return this;
        }

        /**
         * `AWS::SQS::Queue.ReceiveMessageWaitTimeSeconds`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-receivemsgwaittime
         * @param receiveMessageWaitTimeSeconds `AWS::SQS::Queue.ReceiveMessageWaitTimeSeconds`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder receiveMessageWaitTimeSeconds(final java.lang.Number receiveMessageWaitTimeSeconds) {
            this.props().receiveMessageWaitTimeSeconds(receiveMessageWaitTimeSeconds);
            return this;
        }

        /**
         * `AWS::SQS::Queue.RedrivePolicy`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-redrive
         * @param redrivePolicy `AWS::SQS::Queue.RedrivePolicy`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder redrivePolicy(final java.lang.Object redrivePolicy) {
            this.props().redrivePolicy(redrivePolicy);
            return this;
        }

        /**
         * `AWS::SQS::Queue.Tags`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#cfn-sqs-queue-tags
         * @param tags `AWS::SQS::Queue.Tags`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * `AWS::SQS::Queue.VisibilityTimeout`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-visiblitytimeout
         * @param visibilityTimeout `AWS::SQS::Queue.VisibilityTimeout`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder visibilityTimeout(final java.lang.Number visibilityTimeout) {
            this.props().visibilityTimeout(visibilityTimeout);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.sqs.CfnQueue}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.sqs.CfnQueue build() {
            return new software.amazon.awscdk.services.sqs.CfnQueue(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.sqs.CfnQueueProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.sqs.CfnQueueProps.Builder();
            }
            return this.props;
        }
    }
}
