/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.sqs;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import javax.annotation.Nullable;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.sqs.DeadLetterQueue;
import software.amazon.awscdk.services.sqs.QueueEncryption;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface QueueProps
extends JsiiSerializable {
    public Boolean getContentBasedDeduplication();

    public Duration getDataKeyReuse();

    public DeadLetterQueue getDeadLetterQueue();

    public Duration getDeliveryDelay();

    public QueueEncryption getEncryption();

    public IKey getEncryptionMasterKey();

    public Boolean getFifo();

    public Number getMaxMessageSizeBytes();

    public String getQueueName();

    public Duration getReceiveMessageWaitTime();

    public Duration getRetentionPeriod();

    public Duration getVisibilityTimeout();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private Boolean _contentBasedDeduplication;
        @Nullable
        private Duration _dataKeyReuse;
        @Nullable
        private DeadLetterQueue _deadLetterQueue;
        @Nullable
        private Duration _deliveryDelay;
        @Nullable
        private QueueEncryption _encryption;
        @Nullable
        private IKey _encryptionMasterKey;
        @Nullable
        private Boolean _fifo;
        @Nullable
        private Number _maxMessageSizeBytes;
        @Nullable
        private String _queueName;
        @Nullable
        private Duration _receiveMessageWaitTime;
        @Nullable
        private Duration _retentionPeriod;
        @Nullable
        private Duration _visibilityTimeout;

        public Builder withContentBasedDeduplication(@Nullable Boolean value) {
            this._contentBasedDeduplication = value;
            return this;
        }

        public Builder withDataKeyReuse(@Nullable Duration value) {
            this._dataKeyReuse = value;
            return this;
        }

        public Builder withDeadLetterQueue(@Nullable DeadLetterQueue value) {
            this._deadLetterQueue = value;
            return this;
        }

        public Builder withDeliveryDelay(@Nullable Duration value) {
            this._deliveryDelay = value;
            return this;
        }

        public Builder withEncryption(@Nullable QueueEncryption value) {
            this._encryption = value;
            return this;
        }

        public Builder withEncryptionMasterKey(@Nullable IKey value) {
            this._encryptionMasterKey = value;
            return this;
        }

        public Builder withFifo(@Nullable Boolean value) {
            this._fifo = value;
            return this;
        }

        public Builder withMaxMessageSizeBytes(@Nullable Number value) {
            this._maxMessageSizeBytes = value;
            return this;
        }

        public Builder withQueueName(@Nullable String value) {
            this._queueName = value;
            return this;
        }

        public Builder withReceiveMessageWaitTime(@Nullable Duration value) {
            this._receiveMessageWaitTime = value;
            return this;
        }

        public Builder withRetentionPeriod(@Nullable Duration value) {
            this._retentionPeriod = value;
            return this;
        }

        public Builder withVisibilityTimeout(@Nullable Duration value) {
            this._visibilityTimeout = value;
            return this;
        }

        public QueueProps build() {
            return new QueueProps(){
                @Nullable
                private final Boolean $contentBasedDeduplication;
                @Nullable
                private final Duration $dataKeyReuse;
                @Nullable
                private final DeadLetterQueue $deadLetterQueue;
                @Nullable
                private final Duration $deliveryDelay;
                @Nullable
                private final QueueEncryption $encryption;
                @Nullable
                private final IKey $encryptionMasterKey;
                @Nullable
                private final Boolean $fifo;
                @Nullable
                private final Number $maxMessageSizeBytes;
                @Nullable
                private final String $queueName;
                @Nullable
                private final Duration $receiveMessageWaitTime;
                @Nullable
                private final Duration $retentionPeriod;
                @Nullable
                private final Duration $visibilityTimeout;
                {
                    this.$contentBasedDeduplication = _contentBasedDeduplication;
                    this.$dataKeyReuse = _dataKeyReuse;
                    this.$deadLetterQueue = _deadLetterQueue;
                    this.$deliveryDelay = _deliveryDelay;
                    this.$encryption = _encryption;
                    this.$encryptionMasterKey = _encryptionMasterKey;
                    this.$fifo = _fifo;
                    this.$maxMessageSizeBytes = _maxMessageSizeBytes;
                    this.$queueName = _queueName;
                    this.$receiveMessageWaitTime = _receiveMessageWaitTime;
                    this.$retentionPeriod = _retentionPeriod;
                    this.$visibilityTimeout = _visibilityTimeout;
                }

                @Override
                public Boolean getContentBasedDeduplication() {
                    return this.$contentBasedDeduplication;
                }

                @Override
                public Duration getDataKeyReuse() {
                    return this.$dataKeyReuse;
                }

                @Override
                public DeadLetterQueue getDeadLetterQueue() {
                    return this.$deadLetterQueue;
                }

                @Override
                public Duration getDeliveryDelay() {
                    return this.$deliveryDelay;
                }

                @Override
                public QueueEncryption getEncryption() {
                    return this.$encryption;
                }

                @Override
                public IKey getEncryptionMasterKey() {
                    return this.$encryptionMasterKey;
                }

                @Override
                public Boolean getFifo() {
                    return this.$fifo;
                }

                @Override
                public Number getMaxMessageSizeBytes() {
                    return this.$maxMessageSizeBytes;
                }

                @Override
                public String getQueueName() {
                    return this.$queueName;
                }

                @Override
                public Duration getReceiveMessageWaitTime() {
                    return this.$receiveMessageWaitTime;
                }

                @Override
                public Duration getRetentionPeriod() {
                    return this.$retentionPeriod;
                }

                @Override
                public Duration getVisibilityTimeout() {
                    return this.$visibilityTimeout;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    if (this.getContentBasedDeduplication() != null) {
                        obj.set("contentBasedDeduplication", om.valueToTree((Object)this.getContentBasedDeduplication()));
                    }
                    if (this.getDataKeyReuse() != null) {
                        obj.set("dataKeyReuse", om.valueToTree((Object)this.getDataKeyReuse()));
                    }
                    if (this.getDeadLetterQueue() != null) {
                        obj.set("deadLetterQueue", om.valueToTree((Object)this.getDeadLetterQueue()));
                    }
                    if (this.getDeliveryDelay() != null) {
                        obj.set("deliveryDelay", om.valueToTree((Object)this.getDeliveryDelay()));
                    }
                    if (this.getEncryption() != null) {
                        obj.set("encryption", om.valueToTree((Object)this.getEncryption()));
                    }
                    if (this.getEncryptionMasterKey() != null) {
                        obj.set("encryptionMasterKey", om.valueToTree((Object)this.getEncryptionMasterKey()));
                    }
                    if (this.getFifo() != null) {
                        obj.set("fifo", om.valueToTree((Object)this.getFifo()));
                    }
                    if (this.getMaxMessageSizeBytes() != null) {
                        obj.set("maxMessageSizeBytes", om.valueToTree((Object)this.getMaxMessageSizeBytes()));
                    }
                    if (this.getQueueName() != null) {
                        obj.set("queueName", om.valueToTree((Object)this.getQueueName()));
                    }
                    if (this.getReceiveMessageWaitTime() != null) {
                        obj.set("receiveMessageWaitTime", om.valueToTree((Object)this.getReceiveMessageWaitTime()));
                    }
                    if (this.getRetentionPeriod() != null) {
                        obj.set("retentionPeriod", om.valueToTree((Object)this.getRetentionPeriod()));
                    }
                    if (this.getVisibilityTimeout() != null) {
                        obj.set("visibilityTimeout", om.valueToTree((Object)this.getVisibilityTimeout()));
                    }
                    return obj;
                }
            };
        }
    }
}

