/**
 * <h2>Amazon Simple Notification Service Construct Library</h2>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cfn-resources: Stable" src="https://img.shields.io/badge/cfn--resources-stable-success.svg?style=for-the-badge">
 * <p>
 * <img alt="cdk-constructs: Stable" src="https://img.shields.io/badge/cdk--constructs-stable-success.svg?style=for-the-badge">
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * Add an SNS Topic to your stack:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.sns.*;
 * 
 * Topic topic = new Topic(this, "Topic", new TopicProps()
 *         .displayName("Customer subscription topic"));
 * </pre></blockquote>
 * <p>
 * <h3>Subscriptions</h3>
 * <p>
 * Various subscriptions can be added to the topic by calling the
 * <code>.addSubscription(...)</code> method on the topic. It accepts a <em>subscription</em> object,
 * default implementations of which can be found in the
 * <code>&#64;aws-cdk/aws-sns-subscriptions</code> package:
 * <p>
 * Add an HTTPS Subscription to your topic:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.sns.subscriptions.*;
 * 
 * var myTopic = new Topic(this, "MyTopic");
 * 
 * myTopic.addSubscription(new UrlSubscription("https://foobar.com/"));
 * </pre></blockquote>
 * <p>
 * Subscribe a queue to the topic:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * myTopic.addSubscription(new SqsSubscription(queue));
 * </pre></blockquote>
 * <p>
 * Note that subscriptions of queues in different accounts need to be manually confirmed by
 * reading the initial message from the queue and visiting the link found in it.
 * <p>
 * <h4>Filter policy</h4>
 * <p>
 * A filter policy can be specified when subscribing an endpoint to a topic.
 * <p>
 * Example with a Lambda subscription:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var myTopic = new Topic(this, "MyTopic");
 * var fn = new Function(this, "Function", ...);
 * 
 * // Lambda should receive only message matching the following conditions on attributes:
 * // color: 'red' or 'orange' or begins with 'bl'
 * // size: anything but 'small' or 'medium'
 * // price: between 100 and 200 or greater than 300
 * // store: attribute must be present
 * topic.addSubscription(LambdaSubscription.Builder.create(fn)
 *         .filterPolicy(Map.of(
 *                 "color", sns.SubscriptionFilter.stringFilter(Map.of(
 *                         "whitelist", asList("red", "orange"),
 *                         "matchPrefixes", asList("bl"))),
 *                 "size", sns.SubscriptionFilter.stringFilter(Map.of(
 *                         "blacklist", asList("small", "medium"))),
 *                 "price", sns.SubscriptionFilter.numericFilter(Map.of(
 *                         "between", Map.of("start", 100, "stop", 200),
 *                         "greaterThan", 300)),
 *                 "store", sns.SubscriptionFilter.existsFilter()))
 *         .build());
 * </pre></blockquote>
 * <p>
 * <h3>DLQ setup for SNS Subscription</h3>
 * <p>
 * CDK can attach provided Queue as DLQ for your SNS subscription.
 * See the <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-configure-dead-letter-queue.html">SNS DLQ configuration docs</a> for more information about this feature.
 * <p>
 * Example of usage with user provided DLQ.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var topic = new Topic(stack, "Topic");
 * var dlQueue = Queue.Builder.create(stack, "DeadLetterQueue")
 *         .queueName("MySubscription_DLQ")
 *         .retentionPeriod(cdk.Duration.days(14))
 *         .build();
 * 
 * Subscription.Builder.create(stack, "Subscription")
 *         .endpoint("endpoint")
 *         .protocol(sns.SubscriptionProtocol.getLAMBDA())
 *         .topic(topic)
 *         .deadLetterQueue(dlQueue)
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h3>CloudWatch Event Rule Target</h3>
 * <p>
 * SNS topics can be used as targets for CloudWatch event rules.
 * <p>
 * Use the <code>&#64;aws-cdk/aws-events-targets.SnsTopic</code>:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.events.targets.*;
 * 
 * codeCommitRepository.onCommit(new SnsTopic(myTopic));
 * </pre></blockquote>
 * <p>
 * This will result in adding a target to the event rule and will also modify the
 * topic resource policy to allow CloudWatch events to publish to the topic.
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
package software.amazon.awscdk.services.sns;
