package software.amazon.awscdk.services.sns;

/**
 * Subscription configuration.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:13.465Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sns.$Module.class, fqn = "@aws-cdk/aws-sns.TopicSubscriptionConfig")
@software.amazon.jsii.Jsii.Proxy(TopicSubscriptionConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TopicSubscriptionConfig extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.sns.SubscriptionOptions {

    /**
     * The id of the SNS subscription resource created under `scope`.
     * <p>
     * In most
     * cases, it is recommended to use the <code>uniqueId</code> of the topic you are
     * subscribing to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSubscriberId();

    /**
     * The scope in which to create the SNS subscription resource.
     * <p>
     * Normally you'd
     * want the subscription to be created on the consuming stack because the
     * topic is usually referenced by the consumer's resource policy (e.g. SQS
     * queue policy). Otherwise, it will cause a cyclic reference.
     * <p>
     * If this is undefined, the subscription will be created on the topic's stack.
     * <p>
     * Default: - use the topic as the scope of the subscription, in which case `subscriberId` must be defined.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Construct getSubscriberScope() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link TopicSubscriptionConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TopicSubscriptionConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<TopicSubscriptionConfig> {
        private java.lang.String subscriberId;
        private software.amazon.awscdk.core.Construct subscriberScope;
        private java.lang.String endpoint;
        private software.amazon.awscdk.services.sns.SubscriptionProtocol protocol;
        private software.amazon.awscdk.services.sqs.IQueue deadLetterQueue;
        private java.util.Map<java.lang.String, software.amazon.awscdk.services.sns.SubscriptionFilter> filterPolicy;
        private java.lang.Boolean rawMessageDelivery;
        private java.lang.String region;

        /**
         * Sets the value of {@link TopicSubscriptionConfig#getSubscriberId}
         * @param subscriberId The id of the SNS subscription resource created under `scope`. This parameter is required.
         *                     In most
         *                     cases, it is recommended to use the <code>uniqueId</code> of the topic you are
         *                     subscribing to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subscriberId(java.lang.String subscriberId) {
            this.subscriberId = subscriberId;
            return this;
        }

        /**
         * Sets the value of {@link TopicSubscriptionConfig#getSubscriberScope}
         * @param subscriberScope The scope in which to create the SNS subscription resource.
         *                        Normally you'd
         *                        want the subscription to be created on the consuming stack because the
         *                        topic is usually referenced by the consumer's resource policy (e.g. SQS
         *                        queue policy). Otherwise, it will cause a cyclic reference.
         *                        <p>
         *                        If this is undefined, the subscription will be created on the topic's stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subscriberScope(software.amazon.awscdk.core.Construct subscriberScope) {
            this.subscriberScope = subscriberScope;
            return this;
        }

        /**
         * Sets the value of {@link TopicSubscriptionConfig#getEndpoint}
         * @param endpoint The subscription endpoint. This parameter is required.
         *                 The meaning of this value depends on the value for 'protocol'.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpoint(java.lang.String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        /**
         * Sets the value of {@link TopicSubscriptionConfig#getProtocol}
         * @param protocol What type of subscription to add. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocol(software.amazon.awscdk.services.sns.SubscriptionProtocol protocol) {
            this.protocol = protocol;
            return this;
        }

        /**
         * Sets the value of {@link TopicSubscriptionConfig#getDeadLetterQueue}
         * @param deadLetterQueue Queue to be used as dead letter queue.
         *                        If not passed no dead letter queue is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterQueue(software.amazon.awscdk.services.sqs.IQueue deadLetterQueue) {
            this.deadLetterQueue = deadLetterQueue;
            return this;
        }

        /**
         * Sets the value of {@link TopicSubscriptionConfig#getFilterPolicy}
         * @param filterPolicy The filter policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filterPolicy(java.util.Map<java.lang.String, software.amazon.awscdk.services.sns.SubscriptionFilter> filterPolicy) {
            this.filterPolicy = filterPolicy;
            return this;
        }

        /**
         * Sets the value of {@link TopicSubscriptionConfig#getRawMessageDelivery}
         * @param rawMessageDelivery true if raw message delivery is enabled for the subscription.
         *                           Raw messages are free of JSON formatting and can be
         *                           sent to HTTP/S and Amazon SQS endpoints. For more information, see GetSubscriptionAttributes in the Amazon Simple
         *                           Notification Service API Reference.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rawMessageDelivery(java.lang.Boolean rawMessageDelivery) {
            this.rawMessageDelivery = rawMessageDelivery;
            return this;
        }

        /**
         * Sets the value of {@link TopicSubscriptionConfig#getRegion}
         * @param region The region where the topic resides, in the case of cross-region subscriptions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TopicSubscriptionConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public TopicSubscriptionConfig build() {
            return new Jsii$Proxy(subscriberId, subscriberScope, endpoint, protocol, deadLetterQueue, filterPolicy, rawMessageDelivery, region);
        }
    }

    /**
     * An implementation for {@link TopicSubscriptionConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TopicSubscriptionConfig {
        private final java.lang.String subscriberId;
        private final software.amazon.awscdk.core.Construct subscriberScope;
        private final java.lang.String endpoint;
        private final software.amazon.awscdk.services.sns.SubscriptionProtocol protocol;
        private final software.amazon.awscdk.services.sqs.IQueue deadLetterQueue;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.sns.SubscriptionFilter> filterPolicy;
        private final java.lang.Boolean rawMessageDelivery;
        private final java.lang.String region;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.subscriberId = this.jsiiGet("subscriberId", java.lang.String.class);
            this.subscriberScope = this.jsiiGet("subscriberScope", software.amazon.awscdk.core.Construct.class);
            this.endpoint = this.jsiiGet("endpoint", java.lang.String.class);
            this.protocol = this.jsiiGet("protocol", software.amazon.awscdk.services.sns.SubscriptionProtocol.class);
            this.deadLetterQueue = this.jsiiGet("deadLetterQueue", software.amazon.awscdk.services.sqs.IQueue.class);
            this.filterPolicy = this.jsiiGet("filterPolicy", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sns.SubscriptionFilter.class)));
            this.rawMessageDelivery = this.jsiiGet("rawMessageDelivery", java.lang.Boolean.class);
            this.region = this.jsiiGet("region", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String subscriberId, final software.amazon.awscdk.core.Construct subscriberScope, final java.lang.String endpoint, final software.amazon.awscdk.services.sns.SubscriptionProtocol protocol, final software.amazon.awscdk.services.sqs.IQueue deadLetterQueue, final java.util.Map<java.lang.String, software.amazon.awscdk.services.sns.SubscriptionFilter> filterPolicy, final java.lang.Boolean rawMessageDelivery, final java.lang.String region) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.subscriberId = java.util.Objects.requireNonNull(subscriberId, "subscriberId is required");
            this.subscriberScope = subscriberScope;
            this.endpoint = java.util.Objects.requireNonNull(endpoint, "endpoint is required");
            this.protocol = java.util.Objects.requireNonNull(protocol, "protocol is required");
            this.deadLetterQueue = deadLetterQueue;
            this.filterPolicy = filterPolicy;
            this.rawMessageDelivery = rawMessageDelivery;
            this.region = region;
        }

        @Override
        public java.lang.String getSubscriberId() {
            return this.subscriberId;
        }

        @Override
        public software.amazon.awscdk.core.Construct getSubscriberScope() {
            return this.subscriberScope;
        }

        @Override
        public java.lang.String getEndpoint() {
            return this.endpoint;
        }

        @Override
        public software.amazon.awscdk.services.sns.SubscriptionProtocol getProtocol() {
            return this.protocol;
        }

        @Override
        public software.amazon.awscdk.services.sqs.IQueue getDeadLetterQueue() {
            return this.deadLetterQueue;
        }

        @Override
        public java.util.Map<java.lang.String, software.amazon.awscdk.services.sns.SubscriptionFilter> getFilterPolicy() {
            return this.filterPolicy;
        }

        @Override
        public java.lang.Boolean getRawMessageDelivery() {
            return this.rawMessageDelivery;
        }

        @Override
        public java.lang.String getRegion() {
            return this.region;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("subscriberId", om.valueToTree(this.getSubscriberId()));
            if (this.getSubscriberScope() != null) {
                data.set("subscriberScope", om.valueToTree(this.getSubscriberScope()));
            }
            data.set("endpoint", om.valueToTree(this.getEndpoint()));
            data.set("protocol", om.valueToTree(this.getProtocol()));
            if (this.getDeadLetterQueue() != null) {
                data.set("deadLetterQueue", om.valueToTree(this.getDeadLetterQueue()));
            }
            if (this.getFilterPolicy() != null) {
                data.set("filterPolicy", om.valueToTree(this.getFilterPolicy()));
            }
            if (this.getRawMessageDelivery() != null) {
                data.set("rawMessageDelivery", om.valueToTree(this.getRawMessageDelivery()));
            }
            if (this.getRegion() != null) {
                data.set("region", om.valueToTree(this.getRegion()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-sns.TopicSubscriptionConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TopicSubscriptionConfig.Jsii$Proxy that = (TopicSubscriptionConfig.Jsii$Proxy) o;

            if (!subscriberId.equals(that.subscriberId)) return false;
            if (this.subscriberScope != null ? !this.subscriberScope.equals(that.subscriberScope) : that.subscriberScope != null) return false;
            if (!endpoint.equals(that.endpoint)) return false;
            if (!protocol.equals(that.protocol)) return false;
            if (this.deadLetterQueue != null ? !this.deadLetterQueue.equals(that.deadLetterQueue) : that.deadLetterQueue != null) return false;
            if (this.filterPolicy != null ? !this.filterPolicy.equals(that.filterPolicy) : that.filterPolicy != null) return false;
            if (this.rawMessageDelivery != null ? !this.rawMessageDelivery.equals(that.rawMessageDelivery) : that.rawMessageDelivery != null) return false;
            return this.region != null ? this.region.equals(that.region) : that.region == null;
        }

        @Override
        public int hashCode() {
            int result = this.subscriberId.hashCode();
            result = 31 * result + (this.subscriberScope != null ? this.subscriberScope.hashCode() : 0);
            result = 31 * result + (this.endpoint.hashCode());
            result = 31 * result + (this.protocol.hashCode());
            result = 31 * result + (this.deadLetterQueue != null ? this.deadLetterQueue.hashCode() : 0);
            result = 31 * result + (this.filterPolicy != null ? this.filterPolicy.hashCode() : 0);
            result = 31 * result + (this.rawMessageDelivery != null ? this.rawMessageDelivery.hashCode() : 0);
            result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
            return result;
        }
    }
}
