package software.amazon.awscdk.services.sns;

/**
 * Conditions that can be applied to numeric attributes.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:13.460Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sns.$Module.class, fqn = "@aws-cdk/aws-sns.NumericConditions")
@software.amazon.jsii.Jsii.Proxy(NumericConditions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface NumericConditions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Match values that are between the specified values.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sns.BetweenCondition getBetween() {
        return null;
    }

    /**
     * Match values that are strictly between the specified values.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sns.BetweenCondition getBetweenStrict() {
        return null;
    }

    /**
     * Match values that are greater than the specified value.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getGreaterThan() {
        return null;
    }

    /**
     * Match values that are greater than or equal to the specified value.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getGreaterThanOrEqualTo() {
        return null;
    }

    /**
     * Match values that are less than the specified value.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getLessThan() {
        return null;
    }

    /**
     * Match values that are less than or equal to the specified value.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getLessThanOrEqualTo() {
        return null;
    }

    /**
     * Match one or more values.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.Number> getWhitelist() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link NumericConditions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link NumericConditions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<NumericConditions> {
        private software.amazon.awscdk.services.sns.BetweenCondition between;
        private software.amazon.awscdk.services.sns.BetweenCondition betweenStrict;
        private java.lang.Number greaterThan;
        private java.lang.Number greaterThanOrEqualTo;
        private java.lang.Number lessThan;
        private java.lang.Number lessThanOrEqualTo;
        private java.util.List<java.lang.Number> whitelist;

        /**
         * Sets the value of {@link NumericConditions#getBetween}
         * @param between Match values that are between the specified values.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder between(software.amazon.awscdk.services.sns.BetweenCondition between) {
            this.between = between;
            return this;
        }

        /**
         * Sets the value of {@link NumericConditions#getBetweenStrict}
         * @param betweenStrict Match values that are strictly between the specified values.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder betweenStrict(software.amazon.awscdk.services.sns.BetweenCondition betweenStrict) {
            this.betweenStrict = betweenStrict;
            return this;
        }

        /**
         * Sets the value of {@link NumericConditions#getGreaterThan}
         * @param greaterThan Match values that are greater than the specified value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder greaterThan(java.lang.Number greaterThan) {
            this.greaterThan = greaterThan;
            return this;
        }

        /**
         * Sets the value of {@link NumericConditions#getGreaterThanOrEqualTo}
         * @param greaterThanOrEqualTo Match values that are greater than or equal to the specified value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder greaterThanOrEqualTo(java.lang.Number greaterThanOrEqualTo) {
            this.greaterThanOrEqualTo = greaterThanOrEqualTo;
            return this;
        }

        /**
         * Sets the value of {@link NumericConditions#getLessThan}
         * @param lessThan Match values that are less than the specified value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lessThan(java.lang.Number lessThan) {
            this.lessThan = lessThan;
            return this;
        }

        /**
         * Sets the value of {@link NumericConditions#getLessThanOrEqualTo}
         * @param lessThanOrEqualTo Match values that are less than or equal to the specified value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lessThanOrEqualTo(java.lang.Number lessThanOrEqualTo) {
            this.lessThanOrEqualTo = lessThanOrEqualTo;
            return this;
        }

        /**
         * Sets the value of {@link NumericConditions#getWhitelist}
         * @param whitelist Match one or more values.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder whitelist(java.util.List<java.lang.Number> whitelist) {
            this.whitelist = whitelist;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link NumericConditions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public NumericConditions build() {
            return new Jsii$Proxy(between, betweenStrict, greaterThan, greaterThanOrEqualTo, lessThan, lessThanOrEqualTo, whitelist);
        }
    }

    /**
     * An implementation for {@link NumericConditions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NumericConditions {
        private final software.amazon.awscdk.services.sns.BetweenCondition between;
        private final software.amazon.awscdk.services.sns.BetweenCondition betweenStrict;
        private final java.lang.Number greaterThan;
        private final java.lang.Number greaterThanOrEqualTo;
        private final java.lang.Number lessThan;
        private final java.lang.Number lessThanOrEqualTo;
        private final java.util.List<java.lang.Number> whitelist;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.between = this.jsiiGet("between", software.amazon.awscdk.services.sns.BetweenCondition.class);
            this.betweenStrict = this.jsiiGet("betweenStrict", software.amazon.awscdk.services.sns.BetweenCondition.class);
            this.greaterThan = this.jsiiGet("greaterThan", java.lang.Number.class);
            this.greaterThanOrEqualTo = this.jsiiGet("greaterThanOrEqualTo", java.lang.Number.class);
            this.lessThan = this.jsiiGet("lessThan", java.lang.Number.class);
            this.lessThanOrEqualTo = this.jsiiGet("lessThanOrEqualTo", java.lang.Number.class);
            this.whitelist = this.jsiiGet("whitelist", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.Number.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.sns.BetweenCondition between, final software.amazon.awscdk.services.sns.BetweenCondition betweenStrict, final java.lang.Number greaterThan, final java.lang.Number greaterThanOrEqualTo, final java.lang.Number lessThan, final java.lang.Number lessThanOrEqualTo, final java.util.List<java.lang.Number> whitelist) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.between = between;
            this.betweenStrict = betweenStrict;
            this.greaterThan = greaterThan;
            this.greaterThanOrEqualTo = greaterThanOrEqualTo;
            this.lessThan = lessThan;
            this.lessThanOrEqualTo = lessThanOrEqualTo;
            this.whitelist = whitelist;
        }

        @Override
        public software.amazon.awscdk.services.sns.BetweenCondition getBetween() {
            return this.between;
        }

        @Override
        public software.amazon.awscdk.services.sns.BetweenCondition getBetweenStrict() {
            return this.betweenStrict;
        }

        @Override
        public java.lang.Number getGreaterThan() {
            return this.greaterThan;
        }

        @Override
        public java.lang.Number getGreaterThanOrEqualTo() {
            return this.greaterThanOrEqualTo;
        }

        @Override
        public java.lang.Number getLessThan() {
            return this.lessThan;
        }

        @Override
        public java.lang.Number getLessThanOrEqualTo() {
            return this.lessThanOrEqualTo;
        }

        @Override
        public java.util.List<java.lang.Number> getWhitelist() {
            return this.whitelist;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getBetween() != null) {
                data.set("between", om.valueToTree(this.getBetween()));
            }
            if (this.getBetweenStrict() != null) {
                data.set("betweenStrict", om.valueToTree(this.getBetweenStrict()));
            }
            if (this.getGreaterThan() != null) {
                data.set("greaterThan", om.valueToTree(this.getGreaterThan()));
            }
            if (this.getGreaterThanOrEqualTo() != null) {
                data.set("greaterThanOrEqualTo", om.valueToTree(this.getGreaterThanOrEqualTo()));
            }
            if (this.getLessThan() != null) {
                data.set("lessThan", om.valueToTree(this.getLessThan()));
            }
            if (this.getLessThanOrEqualTo() != null) {
                data.set("lessThanOrEqualTo", om.valueToTree(this.getLessThanOrEqualTo()));
            }
            if (this.getWhitelist() != null) {
                data.set("whitelist", om.valueToTree(this.getWhitelist()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-sns.NumericConditions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            NumericConditions.Jsii$Proxy that = (NumericConditions.Jsii$Proxy) o;

            if (this.between != null ? !this.between.equals(that.between) : that.between != null) return false;
            if (this.betweenStrict != null ? !this.betweenStrict.equals(that.betweenStrict) : that.betweenStrict != null) return false;
            if (this.greaterThan != null ? !this.greaterThan.equals(that.greaterThan) : that.greaterThan != null) return false;
            if (this.greaterThanOrEqualTo != null ? !this.greaterThanOrEqualTo.equals(that.greaterThanOrEqualTo) : that.greaterThanOrEqualTo != null) return false;
            if (this.lessThan != null ? !this.lessThan.equals(that.lessThan) : that.lessThan != null) return false;
            if (this.lessThanOrEqualTo != null ? !this.lessThanOrEqualTo.equals(that.lessThanOrEqualTo) : that.lessThanOrEqualTo != null) return false;
            return this.whitelist != null ? this.whitelist.equals(that.whitelist) : that.whitelist == null;
        }

        @Override
        public int hashCode() {
            int result = this.between != null ? this.between.hashCode() : 0;
            result = 31 * result + (this.betweenStrict != null ? this.betweenStrict.hashCode() : 0);
            result = 31 * result + (this.greaterThan != null ? this.greaterThan.hashCode() : 0);
            result = 31 * result + (this.greaterThanOrEqualTo != null ? this.greaterThanOrEqualTo.hashCode() : 0);
            result = 31 * result + (this.lessThan != null ? this.lessThan.hashCode() : 0);
            result = 31 * result + (this.lessThanOrEqualTo != null ? this.lessThanOrEqualTo.hashCode() : 0);
            result = 31 * result + (this.whitelist != null ? this.whitelist.hashCode() : 0);
            return result;
        }
    }
}
