package software.amazon.awscdk.services.sns;

/**
 * Properties for defining a `AWS::SNS::Subscription`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-subscription.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:13.447Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sns.$Module.class, fqn = "@aws-cdk/aws-sns.CfnSubscriptionProps")
@software.amazon.jsii.Jsii.Proxy(CfnSubscriptionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnSubscriptionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::SNS::Subscription.Protocol`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-subscription.html#cfn-sns-protocol
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getProtocol();

    /**
     * `AWS::SNS::Subscription.TopicArn`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-subscription.html#topicarn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTopicArn();

    /**
     * `AWS::SNS::Subscription.DeliveryPolicy`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-subscription.html#cfn-sns-subscription-deliverypolicy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDeliveryPolicy() {
        return null;
    }

    /**
     * `AWS::SNS::Subscription.Endpoint`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-subscription.html#cfn-sns-endpoint
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEndpoint() {
        return null;
    }

    /**
     * `AWS::SNS::Subscription.FilterPolicy`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-subscription.html#cfn-sns-subscription-filterpolicy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getFilterPolicy() {
        return null;
    }

    /**
     * `AWS::SNS::Subscription.RawMessageDelivery`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-subscription.html#cfn-sns-subscription-rawmessagedelivery
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRawMessageDelivery() {
        return null;
    }

    /**
     * `AWS::SNS::Subscription.RedrivePolicy`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-subscription.html#cfn-sns-subscription-redrivepolicy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRedrivePolicy() {
        return null;
    }

    /**
     * `AWS::SNS::Subscription.Region`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-subscription.html#cfn-sns-subscription-region
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnSubscriptionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnSubscriptionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnSubscriptionProps> {
        private java.lang.String protocol;
        private java.lang.String topicArn;
        private java.lang.Object deliveryPolicy;
        private java.lang.String endpoint;
        private java.lang.Object filterPolicy;
        private java.lang.Object rawMessageDelivery;
        private java.lang.Object redrivePolicy;
        private java.lang.String region;

        /**
         * Sets the value of {@link CfnSubscriptionProps#getProtocol}
         * @param protocol `AWS::SNS::Subscription.Protocol`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocol(java.lang.String protocol) {
            this.protocol = protocol;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubscriptionProps#getTopicArn}
         * @param topicArn `AWS::SNS::Subscription.TopicArn`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder topicArn(java.lang.String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubscriptionProps#getDeliveryPolicy}
         * @param deliveryPolicy `AWS::SNS::Subscription.DeliveryPolicy`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deliveryPolicy(java.lang.Object deliveryPolicy) {
            this.deliveryPolicy = deliveryPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubscriptionProps#getEndpoint}
         * @param endpoint `AWS::SNS::Subscription.Endpoint`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpoint(java.lang.String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubscriptionProps#getFilterPolicy}
         * @param filterPolicy `AWS::SNS::Subscription.FilterPolicy`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filterPolicy(java.lang.Object filterPolicy) {
            this.filterPolicy = filterPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubscriptionProps#getRawMessageDelivery}
         * @param rawMessageDelivery `AWS::SNS::Subscription.RawMessageDelivery`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rawMessageDelivery(java.lang.Boolean rawMessageDelivery) {
            this.rawMessageDelivery = rawMessageDelivery;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubscriptionProps#getRawMessageDelivery}
         * @param rawMessageDelivery `AWS::SNS::Subscription.RawMessageDelivery`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rawMessageDelivery(software.amazon.awscdk.core.IResolvable rawMessageDelivery) {
            this.rawMessageDelivery = rawMessageDelivery;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubscriptionProps#getRedrivePolicy}
         * @param redrivePolicy `AWS::SNS::Subscription.RedrivePolicy`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder redrivePolicy(java.lang.Object redrivePolicy) {
            this.redrivePolicy = redrivePolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubscriptionProps#getRegion}
         * @param region `AWS::SNS::Subscription.Region`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnSubscriptionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnSubscriptionProps build() {
            return new Jsii$Proxy(protocol, topicArn, deliveryPolicy, endpoint, filterPolicy, rawMessageDelivery, redrivePolicy, region);
        }
    }

    /**
     * An implementation for {@link CfnSubscriptionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnSubscriptionProps {
        private final java.lang.String protocol;
        private final java.lang.String topicArn;
        private final java.lang.Object deliveryPolicy;
        private final java.lang.String endpoint;
        private final java.lang.Object filterPolicy;
        private final java.lang.Object rawMessageDelivery;
        private final java.lang.Object redrivePolicy;
        private final java.lang.String region;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.protocol = this.jsiiGet("protocol", java.lang.String.class);
            this.topicArn = this.jsiiGet("topicArn", java.lang.String.class);
            this.deliveryPolicy = this.jsiiGet("deliveryPolicy", java.lang.Object.class);
            this.endpoint = this.jsiiGet("endpoint", java.lang.String.class);
            this.filterPolicy = this.jsiiGet("filterPolicy", java.lang.Object.class);
            this.rawMessageDelivery = this.jsiiGet("rawMessageDelivery", java.lang.Object.class);
            this.redrivePolicy = this.jsiiGet("redrivePolicy", java.lang.Object.class);
            this.region = this.jsiiGet("region", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String protocol, final java.lang.String topicArn, final java.lang.Object deliveryPolicy, final java.lang.String endpoint, final java.lang.Object filterPolicy, final java.lang.Object rawMessageDelivery, final java.lang.Object redrivePolicy, final java.lang.String region) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.protocol = java.util.Objects.requireNonNull(protocol, "protocol is required");
            this.topicArn = java.util.Objects.requireNonNull(topicArn, "topicArn is required");
            this.deliveryPolicy = deliveryPolicy;
            this.endpoint = endpoint;
            this.filterPolicy = filterPolicy;
            this.rawMessageDelivery = rawMessageDelivery;
            this.redrivePolicy = redrivePolicy;
            this.region = region;
        }

        @Override
        public java.lang.String getProtocol() {
            return this.protocol;
        }

        @Override
        public java.lang.String getTopicArn() {
            return this.topicArn;
        }

        @Override
        public java.lang.Object getDeliveryPolicy() {
            return this.deliveryPolicy;
        }

        @Override
        public java.lang.String getEndpoint() {
            return this.endpoint;
        }

        @Override
        public java.lang.Object getFilterPolicy() {
            return this.filterPolicy;
        }

        @Override
        public java.lang.Object getRawMessageDelivery() {
            return this.rawMessageDelivery;
        }

        @Override
        public java.lang.Object getRedrivePolicy() {
            return this.redrivePolicy;
        }

        @Override
        public java.lang.String getRegion() {
            return this.region;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("protocol", om.valueToTree(this.getProtocol()));
            data.set("topicArn", om.valueToTree(this.getTopicArn()));
            if (this.getDeliveryPolicy() != null) {
                data.set("deliveryPolicy", om.valueToTree(this.getDeliveryPolicy()));
            }
            if (this.getEndpoint() != null) {
                data.set("endpoint", om.valueToTree(this.getEndpoint()));
            }
            if (this.getFilterPolicy() != null) {
                data.set("filterPolicy", om.valueToTree(this.getFilterPolicy()));
            }
            if (this.getRawMessageDelivery() != null) {
                data.set("rawMessageDelivery", om.valueToTree(this.getRawMessageDelivery()));
            }
            if (this.getRedrivePolicy() != null) {
                data.set("redrivePolicy", om.valueToTree(this.getRedrivePolicy()));
            }
            if (this.getRegion() != null) {
                data.set("region", om.valueToTree(this.getRegion()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-sns.CfnSubscriptionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnSubscriptionProps.Jsii$Proxy that = (CfnSubscriptionProps.Jsii$Proxy) o;

            if (!protocol.equals(that.protocol)) return false;
            if (!topicArn.equals(that.topicArn)) return false;
            if (this.deliveryPolicy != null ? !this.deliveryPolicy.equals(that.deliveryPolicy) : that.deliveryPolicy != null) return false;
            if (this.endpoint != null ? !this.endpoint.equals(that.endpoint) : that.endpoint != null) return false;
            if (this.filterPolicy != null ? !this.filterPolicy.equals(that.filterPolicy) : that.filterPolicy != null) return false;
            if (this.rawMessageDelivery != null ? !this.rawMessageDelivery.equals(that.rawMessageDelivery) : that.rawMessageDelivery != null) return false;
            if (this.redrivePolicy != null ? !this.redrivePolicy.equals(that.redrivePolicy) : that.redrivePolicy != null) return false;
            return this.region != null ? this.region.equals(that.region) : that.region == null;
        }

        @Override
        public int hashCode() {
            int result = this.protocol.hashCode();
            result = 31 * result + (this.topicArn.hashCode());
            result = 31 * result + (this.deliveryPolicy != null ? this.deliveryPolicy.hashCode() : 0);
            result = 31 * result + (this.endpoint != null ? this.endpoint.hashCode() : 0);
            result = 31 * result + (this.filterPolicy != null ? this.filterPolicy.hashCode() : 0);
            result = 31 * result + (this.rawMessageDelivery != null ? this.rawMessageDelivery.hashCode() : 0);
            result = 31 * result + (this.redrivePolicy != null ? this.redrivePolicy.hashCode() : 0);
            result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
            return result;
        }
    }
}
