/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.sns;

import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.sns.;
import software.amazon.awscdk.services.sns.ITopic;
import software.amazon.awscdk.services.sns.SubscriptionFilter;
import software.amazon.awscdk.services.sns.SubscriptionProps;
import software.amazon.awscdk.services.sns.SubscriptionProtocol;
import software.amazon.awscdk.services.sqs.IQueue;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-sns.Subscription")
public class Subscription
extends Resource {
    protected Subscription(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Subscription(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Subscription(@NotNull Construct scope, @NotNull String id, @NotNull SubscriptionProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Nullable
    public IQueue getDeadLetterQueue() {
        return (IQueue)this.jsiiGet("deadLetterQueue", IQueue.class);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Subscription> {
        private final Construct scope;
        private final String id;
        private final SubscriptionProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new SubscriptionProps.Builder();
        }

        public Builder endpoint(String endpoint) {
            this.props.endpoint(endpoint);
            return this;
        }

        public Builder protocol(SubscriptionProtocol protocol) {
            this.props.protocol(protocol);
            return this;
        }

        public Builder deadLetterQueue(IQueue deadLetterQueue) {
            this.props.deadLetterQueue(deadLetterQueue);
            return this;
        }

        public Builder filterPolicy(Map<String, SubscriptionFilter> filterPolicy) {
            this.props.filterPolicy(filterPolicy);
            return this;
        }

        public Builder rawMessageDelivery(Boolean rawMessageDelivery) {
            this.props.rawMessageDelivery(rawMessageDelivery);
            return this;
        }

        public Builder region(String region) {
            this.props.region(region);
            return this;
        }

        public Builder topic(ITopic topic) {
            this.props.topic(topic);
            return this;
        }

        public Subscription build() {
            return new Subscription(this.scope, this.id, this.props.build());
        }
    }
}

