package software.amazon.awscdk.services.sns;

/**
 * A subscription filter for an attribute.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.lambda.*;
 * Function fn;
 * Topic myTopic = new Topic(this, "MyTopic");
 * // Lambda should receive only message matching the following conditions on attributes:
 * // color: 'red' or 'orange' or begins with 'bl'
 * // size: anything but 'small' or 'medium'
 * // price: between 100 and 200 or greater than 300
 * // store: attribute must be present
 * myTopic.addSubscription(LambdaSubscription.Builder.create(fn)
 *         .filterPolicy(Map.of(
 *                 "color", SubscriptionFilter.stringFilter(StringConditions.builder()
 *                         .allowlist(List.of("red", "orange"))
 *                         .matchPrefixes(List.of("bl"))
 *                         .build()),
 *                 "size", SubscriptionFilter.stringFilter(StringConditions.builder()
 *                         .denylist(List.of("small", "medium"))
 *                         .build()),
 *                 "price", SubscriptionFilter.numericFilter(NumericConditions.builder()
 *                         .between(BetweenCondition.builder().start(100).stop(200).build())
 *                         .greaterThan(300)
 *                         .build()),
 *                 "store", SubscriptionFilter.existsFilter()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-28T18:14:37.554Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sns.$Module.class, fqn = "@aws-cdk/aws-sns.SubscriptionFilter")
public class SubscriptionFilter extends software.amazon.jsii.JsiiObject {

    protected SubscriptionFilter(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SubscriptionFilter(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param conditions conditions that specify the message attributes that should be included, excluded, matched, etc.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public SubscriptionFilter(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> conditions) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { conditions });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public SubscriptionFilter() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Returns a subscription filter for attribute key matching.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sns.SubscriptionFilter existsFilter() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.sns.SubscriptionFilter.class, "existsFilter", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sns.SubscriptionFilter.class));
    }

    /**
     * Returns a subscription filter for a numeric attribute.
     * <p>
     * @param numericConditions This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sns.SubscriptionFilter numericFilter(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sns.NumericConditions numericConditions) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.sns.SubscriptionFilter.class, "numericFilter", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sns.SubscriptionFilter.class), new Object[] { java.util.Objects.requireNonNull(numericConditions, "numericConditions is required") });
    }

    /**
     * Returns a subscription filter for a string attribute.
     * <p>
     * @param stringConditions This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sns.SubscriptionFilter stringFilter(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sns.StringConditions stringConditions) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.sns.SubscriptionFilter.class, "stringFilter", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sns.SubscriptionFilter.class), new Object[] { java.util.Objects.requireNonNull(stringConditions, "stringConditions is required") });
    }

    /**
     * conditions that specify the message attributes that should be included, excluded, matched, etc.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> getConditions() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "conditions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }
}
