/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.sns;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface CfnSubscriptionProps
extends JsiiSerializable {
    public String getProtocol();

    public String getTopicArn();

    public Object getDeliveryPolicy();

    public String getEndpoint();

    public Object getFilterPolicy();

    public Object getRawMessageDelivery();

    public String getRegion();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _protocol;
        private String _topicArn;
        @Nullable
        private Object _deliveryPolicy;
        @Nullable
        private String _endpoint;
        @Nullable
        private Object _filterPolicy;
        @Nullable
        private Object _rawMessageDelivery;
        @Nullable
        private String _region;

        public Builder withProtocol(String value) {
            this._protocol = Objects.requireNonNull(value, "protocol is required");
            return this;
        }

        public Builder withTopicArn(String value) {
            this._topicArn = Objects.requireNonNull(value, "topicArn is required");
            return this;
        }

        public Builder withDeliveryPolicy(@Nullable Object value) {
            this._deliveryPolicy = value;
            return this;
        }

        public Builder withEndpoint(@Nullable String value) {
            this._endpoint = value;
            return this;
        }

        public Builder withFilterPolicy(@Nullable Object value) {
            this._filterPolicy = value;
            return this;
        }

        public Builder withRawMessageDelivery(@Nullable Boolean value) {
            this._rawMessageDelivery = value;
            return this;
        }

        public Builder withRawMessageDelivery(@Nullable IResolvable value) {
            this._rawMessageDelivery = value;
            return this;
        }

        public Builder withRegion(@Nullable String value) {
            this._region = value;
            return this;
        }

        public CfnSubscriptionProps build() {
            return new CfnSubscriptionProps(){
                private final String $protocol;
                private final String $topicArn;
                @Nullable
                private final Object $deliveryPolicy;
                @Nullable
                private final String $endpoint;
                @Nullable
                private final Object $filterPolicy;
                @Nullable
                private final Object $rawMessageDelivery;
                @Nullable
                private final String $region;
                {
                    this.$protocol = Objects.requireNonNull(_protocol, "protocol is required");
                    this.$topicArn = Objects.requireNonNull(_topicArn, "topicArn is required");
                    this.$deliveryPolicy = _deliveryPolicy;
                    this.$endpoint = _endpoint;
                    this.$filterPolicy = _filterPolicy;
                    this.$rawMessageDelivery = _rawMessageDelivery;
                    this.$region = _region;
                }

                @Override
                public String getProtocol() {
                    return this.$protocol;
                }

                @Override
                public String getTopicArn() {
                    return this.$topicArn;
                }

                @Override
                public Object getDeliveryPolicy() {
                    return this.$deliveryPolicy;
                }

                @Override
                public String getEndpoint() {
                    return this.$endpoint;
                }

                @Override
                public Object getFilterPolicy() {
                    return this.$filterPolicy;
                }

                @Override
                public Object getRawMessageDelivery() {
                    return this.$rawMessageDelivery;
                }

                @Override
                public String getRegion() {
                    return this.$region;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("protocol", om.valueToTree((Object)this.getProtocol()));
                    obj.set("topicArn", om.valueToTree((Object)this.getTopicArn()));
                    if (this.getDeliveryPolicy() != null) {
                        obj.set("deliveryPolicy", om.valueToTree(this.getDeliveryPolicy()));
                    }
                    if (this.getEndpoint() != null) {
                        obj.set("endpoint", om.valueToTree((Object)this.getEndpoint()));
                    }
                    if (this.getFilterPolicy() != null) {
                        obj.set("filterPolicy", om.valueToTree(this.getFilterPolicy()));
                    }
                    if (this.getRawMessageDelivery() != null) {
                        obj.set("rawMessageDelivery", om.valueToTree(this.getRawMessageDelivery()));
                    }
                    if (this.getRegion() != null) {
                        obj.set("region", om.valueToTree((Object)this.getRegion()));
                    }
                    return obj;
                }
            };
        }
    }
}

