/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.sns.subscriptions;

import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.services.sns.ITopic;
import software.amazon.awscdk.services.sns.ITopicSubscription;
import software.amazon.awscdk.services.sns.SubscriptionFilter;
import software.amazon.awscdk.services.sns.TopicSubscriptionConfig;
import software.amazon.awscdk.services.sns.subscriptions.$Module;
import software.amazon.awscdk.services.sns.subscriptions.SqsSubscriptionProps;
import software.amazon.awscdk.services.sqs.IQueue;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-sns-subscriptions.SqsSubscription")
public class SqsSubscription
extends JsiiObject
implements ITopicSubscription {
    protected SqsSubscription(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SqsSubscription(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public SqsSubscription(@NotNull IQueue queue, @Nullable SqsSubscriptionProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(queue, "queue is required"), props});
    }

    public SqsSubscription(@NotNull IQueue queue) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(queue, "queue is required")});
    }

    @NotNull
    public TopicSubscriptionConfig bind(@NotNull ITopic topic) {
        return (TopicSubscriptionConfig)this.jsiiCall("bind", TopicSubscriptionConfig.class, new Object[]{Objects.requireNonNull(topic, "topic is required")});
    }

    public static final class Builder {
        private final IQueue queue;
        private SqsSubscriptionProps.Builder props;

        public static Builder create(IQueue queue) {
            return new Builder(queue);
        }

        private Builder(IQueue queue) {
            this.queue = queue;
        }

        public Builder filterPolicy(Map<String, SubscriptionFilter> filterPolicy) {
            this.props().filterPolicy(filterPolicy);
            return this;
        }

        public Builder rawMessageDelivery(Boolean rawMessageDelivery) {
            this.props().rawMessageDelivery(rawMessageDelivery);
            return this;
        }

        public SqsSubscription build() {
            return new SqsSubscription(this.queue, this.props != null ? this.props.build() : null);
        }

        private SqsSubscriptionProps.Builder props() {
            if (this.props == null) {
                this.props = new SqsSubscriptionProps.Builder();
            }
            return this.props;
        }
    }
}

