/**
 * <h2>Amazon Simple Email Service Construct Library</h2>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cfn-resources: Stable" src="https://img.shields.io/badge/cfn--resources-stable-success.svg?style=for-the-badge">
 * <p>
 * <blockquote>
 * <p>
 * All classes with the <code>Cfn</code> prefix in this module (<a href="https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_lib">CFN Resources</a>) are always stable and safe to use.
 * <p>
 * </blockquote>
 * <p>
 * <img alt="cdk-constructs: Experimental" src="https://img.shields.io/badge/cdk--constructs-experimental-important.svg?style=for-the-badge">
 * <p>
 * <blockquote>
 * <p>
 * The APIs of higher level constructs in this module are experimental and under active development. They are subject to non-backward compatible changes or removal in any future version. These are not subject to the <a href="https://semver.org/">Semantic Versioning</a> model and breaking changes will be announced in the release notes. This means that while you may use them, you may need to update your source code when upgrading to a newer version of this package.
 * <p>
 * </blockquote>
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * This module is part of the <a href="https://github.com/aws/aws-cdk">AWS Cloud Development Kit</a> project.
 * <p>
 * <h3>Email receiving</h3>
 * <p>
 * Create a receipt rule set with rules and actions (actions can be found in the
 * <code>&#64;aws-cdk/aws-ses-actions</code> package):
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.s3.*;
 * import software.amazon.awscdk.services.ses.*;
 * import software.amazon.awscdk.services.ses.actions.*;
 * import software.amazon.awscdk.services.sns.*;
 * 
 * Bucket bucket = new Bucket(stack, "Bucket");
 * Topic topic = new Topic(stack, "Topic");
 * 
 * new ReceiptRuleSet(stack, "RuleSet", new ReceiptRuleSetProps()
 *         .rules(asList(new ReceiptRuleOptions()
 *                 .recipients(asList("hello&#64;aws.com"))
 *                 .actions(asList(
 *                     new AddHeader(new AddHeaderProps()
 *                             .name("X-Special-Header")
 *                             .value("aws")),
 *                     new S3(new S3Props()
 *                             .bucket(bucket)
 *                             .objectKeyPrefix("emails/")
 *                             .topic(topic)))), new ReceiptRuleOptions()
 *                 .recipients(asList("aws.com"))
 *                 .actions(asList(
 *                     new Sns(new SnsProps()
 *                             .topic(topic)))))));
 * </pre></blockquote>
 * <p>
 * Alternatively, rules can be added to a rule set:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var ruleSet = new ReceiptRuleSet(this, "RuleSet");
 * 
 * var awsRule = ruleSet.addRule("Aws", Map.of(
 *         "recipients", asList("aws.com")));
 * </pre></blockquote>
 * <p>
 * And actions to rules:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * awsRule.addAction(Sns.Builder.create()
 *         .topic(topic)
 *         .build());
 * </pre></blockquote>
 * <p>
 * When using <code>addRule</code>, the new rule is added after the last added rule unless <code>after</code> is specified.
 * <p>
 * <h4>Drop spams</h4>
 * <p>
 * A rule to drop spam can be added by setting <code>dropSpam</code> to <code>true</code>:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * ReceiptRuleSet.Builder.create(this, "RuleSet")
 *         .dropSpam(true)
 *         .build();
 * </pre></blockquote>
 * <p>
 * This will add a rule at the top of the rule set with a Lambda action that stops processing messages that have at least one spam indicator. See <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-action-lambda-example-functions.html">Lambda Function Examples</a>.
 * <p>
 * <h3>Receipt filter</h3>
 * <p>
 * Create a receipt filter:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * ReceiptFilter.Builder.create(this, "Filter")
 *         .ip("1.2.3.4/16")
 *         .build();
 * </pre></blockquote>
 * <p>
 * A white list filter is also available:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * WhiteListReceiptFilter.Builder.create(this, "WhiteList")
 *         .ips(asList("10.0.0.0/16", "1.2.3.4/16"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * This will first create a block all filter and then create allow filters for the listed ip addresses.
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
package software.amazon.awscdk.services.ses;
