/**
 * <h1>Amazon Simple Email Service Construct Library</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cfn-resources: Stable" src="https://img.shields.io/badge/cfn--resources-stable-success.svg?style=for-the-badge">
 * <p>
 * <img alt="cdk-constructs: Stable" src="https://img.shields.io/badge/cdk--constructs-stable-success.svg?style=for-the-badge">
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * This module is part of the <a href="https://github.com/aws/aws-cdk">AWS Cloud Development Kit</a> project.
 * <p>
 * <h2>Email receiving</h2>
 * <p>
 * Create a receipt rule set with rules and actions (actions can be found in the
 * <code>&#64;aws-cdk/aws-ses-actions</code> package):
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.s3.*;
 * import software.amazon.awscdk.services.ses.actions.*;
 * 
 * 
 * Bucket bucket = new Bucket(this, "Bucket");
 * Topic topic = new Topic(this, "Topic");
 * 
 * ReceiptRuleSet.Builder.create(this, "RuleSet")
 *         .rules(List.of(ReceiptRuleOptions.builder()
 *                 .recipients(List.of("hello&#64;aws.com"))
 *                 .actions(List.of(
 *                     AddHeader.Builder.create()
 *                             .name("X-Special-Header")
 *                             .value("aws")
 *                             .build(),
 *                     S3.Builder.create()
 *                             .bucket(bucket)
 *                             .objectKeyPrefix("emails/")
 *                             .topic(topic)
 *                             .build()))
 *                 .build(), ReceiptRuleOptions.builder()
 *                 .recipients(List.of("aws.com"))
 *                 .actions(List.of(
 *                     Sns.Builder.create()
 *                             .topic(topic)
 *                             .build()))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * Alternatively, rules can be added to a rule set:
 * <p>
 * <blockquote><pre>
 * ReceiptRuleSet ruleSet = new ReceiptRuleSet(this, "RuleSet");
 * 
 * ReceiptRule awsRule = ruleSet.addRule("Aws", ReceiptRuleOptions.builder()
 *         .recipients(List.of("aws.com"))
 *         .build());
 * </pre></blockquote>
 * <p>
 * And actions to rules:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.ses.actions.*;
 * 
 * ReceiptRule awsRule;
 * Topic topic;
 * 
 * awsRule.addAction(Sns.Builder.create()
 *         .topic(topic)
 *         .build());
 * </pre></blockquote>
 * <p>
 * When using <code>addRule</code>, the new rule is added after the last added rule unless <code>after</code> is specified.
 * <p>
 * <h3>Drop spams</h3>
 * <p>
 * A rule to drop spam can be added by setting <code>dropSpam</code> to <code>true</code>:
 * <p>
 * <blockquote><pre>
 * ReceiptRuleSet.Builder.create(this, "RuleSet")
 *         .dropSpam(true)
 *         .build();
 * </pre></blockquote>
 * <p>
 * This will add a rule at the top of the rule set with a Lambda action that stops processing messages that have at least one spam indicator. See <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-action-lambda-example-functions.html">Lambda Function Examples</a>.
 * <p>
 * <h2>Receipt filter</h2>
 * <p>
 * Create a receipt filter:
 * <p>
 * <blockquote><pre>
 * ReceiptFilter.Builder.create(this, "Filter")
 *         .ip("1.2.3.4/16")
 *         .build();
 * </pre></blockquote>
 * <p>
 * An allow list filter is also available:
 * <p>
 * <blockquote><pre>
 * AllowListReceiptFilter.Builder.create(this, "AllowList")
 *         .ips(List.of("10.0.0.0/16", "1.2.3.4/16"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * This will first create a block all filter and then create allow filters for the listed ip addresses.
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
package software.amazon.awscdk.services.ses;
