package software.amazon.awscdk.services.ses;

/**
 * A receipt filter.
 * <p>
 * When instantiated without props, it creates a
 * block all receipt filter.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * ReceiptFilter.Builder.create(this, "Filter")
 *         .ip("1.2.3.4/16")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-16T18:50:30.641Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ses.$Module.class, fqn = "@aws-cdk/aws-ses.ReceiptFilter")
public class ReceiptFilter extends software.amazon.awscdk.core.Resource {

    protected ReceiptFilter(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ReceiptFilter(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ReceiptFilter(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ses.ReceiptFilterProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ReceiptFilter(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ses.ReceiptFilter}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ses.ReceiptFilter> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.ses.ReceiptFilterProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The ip address or range to filter.
         * <p>
         * Default: 0.0.0.0/0
         * <p>
         * @return {@code this}
         * @param ip The ip address or range to filter. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ip(final java.lang.String ip) {
            this.props().ip(ip);
            return this;
        }

        /**
         * The policy for the filter.
         * <p>
         * Default: Block
         * <p>
         * @return {@code this}
         * @param policy The policy for the filter. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policy(final software.amazon.awscdk.services.ses.ReceiptFilterPolicy policy) {
            this.props().policy(policy);
            return this;
        }

        /**
         * The name for the receipt filter.
         * <p>
         * Default: a CloudFormation generated name
         * <p>
         * @return {@code this}
         * @param receiptFilterName The name for the receipt filter. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder receiptFilterName(final java.lang.String receiptFilterName) {
            this.props().receiptFilterName(receiptFilterName);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ses.ReceiptFilter}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ses.ReceiptFilter build() {
            return new software.amazon.awscdk.services.ses.ReceiptFilter(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ses.ReceiptFilterProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ses.ReceiptFilterProps.Builder();
            }
            return this.props;
        }
    }
}
