package software.amazon.awscdk.services.ses;

/**
 * A CloudFormation `AWS::SES::ConfigurationSet`.
 * <p>
 * The name of the configuration set.
 * <p>
 * Configuration sets let you create groups of rules that you can apply to the emails you send using Amazon SES. For more information about using configuration sets, see <a href="https://docs.aws.amazon.com/ses/latest/dg/using-configuration-sets.html">Using Amazon SES Configuration Sets</a> in the <a href="https://docs.aws.amazon.com/ses/latest/dg/">Amazon SES Developer Guide</a> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ses.*;
 * CfnConfigurationSet cfnConfigurationSet = CfnConfigurationSet.Builder.create(this, "MyCfnConfigurationSet")
 *         .deliveryOptions(DeliveryOptionsProperty.builder()
 *                 .sendingPoolName("sendingPoolName")
 *                 .tlsPolicy("tlsPolicy")
 *                 .build())
 *         .name("name")
 *         .reputationOptions(ReputationOptionsProperty.builder()
 *                 .reputationMetricsEnabled(false)
 *                 .build())
 *         .sendingOptions(SendingOptionsProperty.builder()
 *                 .sendingEnabled(false)
 *                 .build())
 *         .suppressionOptions(SuppressionOptionsProperty.builder()
 *                 .suppressedReasons(List.of("suppressedReasons"))
 *                 .build())
 *         .trackingOptions(TrackingOptionsProperty.builder()
 *                 .customRedirectDomain("customRedirectDomain")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-16T18:50:30.580Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ses.$Module.class, fqn = "@aws-cdk/aws-ses.CfnConfigurationSet")
public class CfnConfigurationSet extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnConfigurationSet(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnConfigurationSet(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ses.CfnConfigurationSet.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::SES::ConfigurationSet`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnConfigurationSet(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ses.CfnConfigurationSetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new `AWS::SES::ConfigurationSet`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnConfigurationSet(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::SES::ConfigurationSet.DeliveryOptions`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDeliveryOptions() {
        return software.amazon.jsii.Kernel.get(this, "deliveryOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::SES::ConfigurationSet.DeliveryOptions`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeliveryOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ses.CfnConfigurationSet.DeliveryOptionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "deliveryOptions", value);
    }

    /**
     * `AWS::SES::ConfigurationSet.DeliveryOptions`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeliveryOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "deliveryOptions", value);
    }

    /**
     * The name of the configuration set. The name must meet the following requirements:.
     * <p>
     * <ul>
     * <li>Contain only letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-).</li>
     * <li>Contain 64 characters or fewer.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the configuration set. The name must meet the following requirements:.
     * <p>
     * <ul>
     * <li>Contain only letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-).</li>
     * <li>Contain 64 characters or fewer.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * `AWS::SES::ConfigurationSet.ReputationOptions`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getReputationOptions() {
        return software.amazon.jsii.Kernel.get(this, "reputationOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::SES::ConfigurationSet.ReputationOptions`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReputationOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "reputationOptions", value);
    }

    /**
     * `AWS::SES::ConfigurationSet.ReputationOptions`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReputationOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ses.CfnConfigurationSet.ReputationOptionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "reputationOptions", value);
    }

    /**
     * `AWS::SES::ConfigurationSet.SendingOptions`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSendingOptions() {
        return software.amazon.jsii.Kernel.get(this, "sendingOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::SES::ConfigurationSet.SendingOptions`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSendingOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "sendingOptions", value);
    }

    /**
     * `AWS::SES::ConfigurationSet.SendingOptions`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSendingOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ses.CfnConfigurationSet.SendingOptionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "sendingOptions", value);
    }

    /**
     * `AWS::SES::ConfigurationSet.SuppressionOptions`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSuppressionOptions() {
        return software.amazon.jsii.Kernel.get(this, "suppressionOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::SES::ConfigurationSet.SuppressionOptions`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSuppressionOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "suppressionOptions", value);
    }

    /**
     * `AWS::SES::ConfigurationSet.SuppressionOptions`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSuppressionOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ses.CfnConfigurationSet.SuppressionOptionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "suppressionOptions", value);
    }

    /**
     * `AWS::SES::ConfigurationSet.TrackingOptions`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTrackingOptions() {
        return software.amazon.jsii.Kernel.get(this, "trackingOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::SES::ConfigurationSet.TrackingOptions`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTrackingOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "trackingOptions", value);
    }

    /**
     * `AWS::SES::ConfigurationSet.TrackingOptions`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTrackingOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ses.CfnConfigurationSet.TrackingOptionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "trackingOptions", value);
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * DeliveryOptionsProperty deliveryOptionsProperty = DeliveryOptionsProperty.builder()
     *         .sendingPoolName("sendingPoolName")
     *         .tlsPolicy("tlsPolicy")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ses.$Module.class, fqn = "@aws-cdk/aws-ses.CfnConfigurationSet.DeliveryOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(DeliveryOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DeliveryOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnConfigurationSet.DeliveryOptionsProperty.SendingPoolName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSendingPoolName() {
            return null;
        }

        /**
         * `CfnConfigurationSet.DeliveryOptionsProperty.TlsPolicy`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTlsPolicy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DeliveryOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeliveryOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DeliveryOptionsProperty> {
            java.lang.String sendingPoolName;
            java.lang.String tlsPolicy;

            /**
             * Sets the value of {@link DeliveryOptionsProperty#getSendingPoolName}
             * @param sendingPoolName `CfnConfigurationSet.DeliveryOptionsProperty.SendingPoolName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sendingPoolName(java.lang.String sendingPoolName) {
                this.sendingPoolName = sendingPoolName;
                return this;
            }

            /**
             * Sets the value of {@link DeliveryOptionsProperty#getTlsPolicy}
             * @param tlsPolicy `CfnConfigurationSet.DeliveryOptionsProperty.TlsPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tlsPolicy(java.lang.String tlsPolicy) {
                this.tlsPolicy = tlsPolicy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeliveryOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DeliveryOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DeliveryOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeliveryOptionsProperty {
            private final java.lang.String sendingPoolName;
            private final java.lang.String tlsPolicy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sendingPoolName = software.amazon.jsii.Kernel.get(this, "sendingPoolName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tlsPolicy = software.amazon.jsii.Kernel.get(this, "tlsPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sendingPoolName = builder.sendingPoolName;
                this.tlsPolicy = builder.tlsPolicy;
            }

            @Override
            public final java.lang.String getSendingPoolName() {
                return this.sendingPoolName;
            }

            @Override
            public final java.lang.String getTlsPolicy() {
                return this.tlsPolicy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSendingPoolName() != null) {
                    data.set("sendingPoolName", om.valueToTree(this.getSendingPoolName()));
                }
                if (this.getTlsPolicy() != null) {
                    data.set("tlsPolicy", om.valueToTree(this.getTlsPolicy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ses.CfnConfigurationSet.DeliveryOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeliveryOptionsProperty.Jsii$Proxy that = (DeliveryOptionsProperty.Jsii$Proxy) o;

                if (this.sendingPoolName != null ? !this.sendingPoolName.equals(that.sendingPoolName) : that.sendingPoolName != null) return false;
                return this.tlsPolicy != null ? this.tlsPolicy.equals(that.tlsPolicy) : that.tlsPolicy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.sendingPoolName != null ? this.sendingPoolName.hashCode() : 0;
                result = 31 * result + (this.tlsPolicy != null ? this.tlsPolicy.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * ReputationOptionsProperty reputationOptionsProperty = ReputationOptionsProperty.builder()
     *         .reputationMetricsEnabled(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ses.$Module.class, fqn = "@aws-cdk/aws-ses.CfnConfigurationSet.ReputationOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(ReputationOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ReputationOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnConfigurationSet.ReputationOptionsProperty.ReputationMetricsEnabled`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReputationMetricsEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ReputationOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ReputationOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ReputationOptionsProperty> {
            java.lang.Object reputationMetricsEnabled;

            /**
             * Sets the value of {@link ReputationOptionsProperty#getReputationMetricsEnabled}
             * @param reputationMetricsEnabled `CfnConfigurationSet.ReputationOptionsProperty.ReputationMetricsEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder reputationMetricsEnabled(java.lang.Boolean reputationMetricsEnabled) {
                this.reputationMetricsEnabled = reputationMetricsEnabled;
                return this;
            }

            /**
             * Sets the value of {@link ReputationOptionsProperty#getReputationMetricsEnabled}
             * @param reputationMetricsEnabled `CfnConfigurationSet.ReputationOptionsProperty.ReputationMetricsEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder reputationMetricsEnabled(software.amazon.awscdk.core.IResolvable reputationMetricsEnabled) {
                this.reputationMetricsEnabled = reputationMetricsEnabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReputationOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ReputationOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ReputationOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReputationOptionsProperty {
            private final java.lang.Object reputationMetricsEnabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.reputationMetricsEnabled = software.amazon.jsii.Kernel.get(this, "reputationMetricsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.reputationMetricsEnabled = builder.reputationMetricsEnabled;
            }

            @Override
            public final java.lang.Object getReputationMetricsEnabled() {
                return this.reputationMetricsEnabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getReputationMetricsEnabled() != null) {
                    data.set("reputationMetricsEnabled", om.valueToTree(this.getReputationMetricsEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ses.CfnConfigurationSet.ReputationOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ReputationOptionsProperty.Jsii$Proxy that = (ReputationOptionsProperty.Jsii$Proxy) o;

                return this.reputationMetricsEnabled != null ? this.reputationMetricsEnabled.equals(that.reputationMetricsEnabled) : that.reputationMetricsEnabled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.reputationMetricsEnabled != null ? this.reputationMetricsEnabled.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * SendingOptionsProperty sendingOptionsProperty = SendingOptionsProperty.builder()
     *         .sendingEnabled(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ses.$Module.class, fqn = "@aws-cdk/aws-ses.CfnConfigurationSet.SendingOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(SendingOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SendingOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnConfigurationSet.SendingOptionsProperty.SendingEnabled`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSendingEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SendingOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SendingOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SendingOptionsProperty> {
            java.lang.Object sendingEnabled;

            /**
             * Sets the value of {@link SendingOptionsProperty#getSendingEnabled}
             * @param sendingEnabled `CfnConfigurationSet.SendingOptionsProperty.SendingEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sendingEnabled(java.lang.Boolean sendingEnabled) {
                this.sendingEnabled = sendingEnabled;
                return this;
            }

            /**
             * Sets the value of {@link SendingOptionsProperty#getSendingEnabled}
             * @param sendingEnabled `CfnConfigurationSet.SendingOptionsProperty.SendingEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sendingEnabled(software.amazon.awscdk.core.IResolvable sendingEnabled) {
                this.sendingEnabled = sendingEnabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SendingOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SendingOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SendingOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SendingOptionsProperty {
            private final java.lang.Object sendingEnabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sendingEnabled = software.amazon.jsii.Kernel.get(this, "sendingEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sendingEnabled = builder.sendingEnabled;
            }

            @Override
            public final java.lang.Object getSendingEnabled() {
                return this.sendingEnabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSendingEnabled() != null) {
                    data.set("sendingEnabled", om.valueToTree(this.getSendingEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ses.CfnConfigurationSet.SendingOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SendingOptionsProperty.Jsii$Proxy that = (SendingOptionsProperty.Jsii$Proxy) o;

                return this.sendingEnabled != null ? this.sendingEnabled.equals(that.sendingEnabled) : that.sendingEnabled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.sendingEnabled != null ? this.sendingEnabled.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * SuppressionOptionsProperty suppressionOptionsProperty = SuppressionOptionsProperty.builder()
     *         .suppressedReasons(List.of("suppressedReasons"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ses.$Module.class, fqn = "@aws-cdk/aws-ses.CfnConfigurationSet.SuppressionOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(SuppressionOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SuppressionOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnConfigurationSet.SuppressionOptionsProperty.SuppressedReasons`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSuppressedReasons() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SuppressionOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SuppressionOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SuppressionOptionsProperty> {
            java.util.List<java.lang.String> suppressedReasons;

            /**
             * Sets the value of {@link SuppressionOptionsProperty#getSuppressedReasons}
             * @param suppressedReasons `CfnConfigurationSet.SuppressionOptionsProperty.SuppressedReasons`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder suppressedReasons(java.util.List<java.lang.String> suppressedReasons) {
                this.suppressedReasons = suppressedReasons;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SuppressionOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SuppressionOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SuppressionOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SuppressionOptionsProperty {
            private final java.util.List<java.lang.String> suppressedReasons;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.suppressedReasons = software.amazon.jsii.Kernel.get(this, "suppressedReasons", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.suppressedReasons = builder.suppressedReasons;
            }

            @Override
            public final java.util.List<java.lang.String> getSuppressedReasons() {
                return this.suppressedReasons;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSuppressedReasons() != null) {
                    data.set("suppressedReasons", om.valueToTree(this.getSuppressedReasons()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ses.CfnConfigurationSet.SuppressionOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SuppressionOptionsProperty.Jsii$Proxy that = (SuppressionOptionsProperty.Jsii$Proxy) o;

                return this.suppressedReasons != null ? this.suppressedReasons.equals(that.suppressedReasons) : that.suppressedReasons == null;
            }

            @Override
            public final int hashCode() {
                int result = this.suppressedReasons != null ? this.suppressedReasons.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * TrackingOptionsProperty trackingOptionsProperty = TrackingOptionsProperty.builder()
     *         .customRedirectDomain("customRedirectDomain")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ses.$Module.class, fqn = "@aws-cdk/aws-ses.CfnConfigurationSet.TrackingOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(TrackingOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TrackingOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnConfigurationSet.TrackingOptionsProperty.CustomRedirectDomain`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCustomRedirectDomain() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TrackingOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TrackingOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TrackingOptionsProperty> {
            java.lang.String customRedirectDomain;

            /**
             * Sets the value of {@link TrackingOptionsProperty#getCustomRedirectDomain}
             * @param customRedirectDomain `CfnConfigurationSet.TrackingOptionsProperty.CustomRedirectDomain`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customRedirectDomain(java.lang.String customRedirectDomain) {
                this.customRedirectDomain = customRedirectDomain;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TrackingOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TrackingOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TrackingOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TrackingOptionsProperty {
            private final java.lang.String customRedirectDomain;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.customRedirectDomain = software.amazon.jsii.Kernel.get(this, "customRedirectDomain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.customRedirectDomain = builder.customRedirectDomain;
            }

            @Override
            public final java.lang.String getCustomRedirectDomain() {
                return this.customRedirectDomain;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCustomRedirectDomain() != null) {
                    data.set("customRedirectDomain", om.valueToTree(this.getCustomRedirectDomain()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ses.CfnConfigurationSet.TrackingOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TrackingOptionsProperty.Jsii$Proxy that = (TrackingOptionsProperty.Jsii$Proxy) o;

                return this.customRedirectDomain != null ? this.customRedirectDomain.equals(that.customRedirectDomain) : that.customRedirectDomain == null;
            }

            @Override
            public final int hashCode() {
                int result = this.customRedirectDomain != null ? this.customRedirectDomain.hashCode() : 0;
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ses.CfnConfigurationSet}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ses.CfnConfigurationSet> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.ses.CfnConfigurationSetProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * `AWS::SES::ConfigurationSet.DeliveryOptions`.
         * <p>
         * @return {@code this}
         * @param deliveryOptions `AWS::SES::ConfigurationSet.DeliveryOptions`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deliveryOptions(final software.amazon.awscdk.services.ses.CfnConfigurationSet.DeliveryOptionsProperty deliveryOptions) {
            this.props().deliveryOptions(deliveryOptions);
            return this;
        }
        /**
         * `AWS::SES::ConfigurationSet.DeliveryOptions`.
         * <p>
         * @return {@code this}
         * @param deliveryOptions `AWS::SES::ConfigurationSet.DeliveryOptions`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deliveryOptions(final software.amazon.awscdk.core.IResolvable deliveryOptions) {
            this.props().deliveryOptions(deliveryOptions);
            return this;
        }

        /**
         * The name of the configuration set. The name must meet the following requirements:.
         * <p>
         * <ul>
         * <li>Contain only letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-).</li>
         * <li>Contain 64 characters or fewer.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param name The name of the configuration set. The name must meet the following requirements:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props().name(name);
            return this;
        }

        /**
         * `AWS::SES::ConfigurationSet.ReputationOptions`.
         * <p>
         * @return {@code this}
         * @param reputationOptions `AWS::SES::ConfigurationSet.ReputationOptions`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reputationOptions(final software.amazon.awscdk.core.IResolvable reputationOptions) {
            this.props().reputationOptions(reputationOptions);
            return this;
        }
        /**
         * `AWS::SES::ConfigurationSet.ReputationOptions`.
         * <p>
         * @return {@code this}
         * @param reputationOptions `AWS::SES::ConfigurationSet.ReputationOptions`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reputationOptions(final software.amazon.awscdk.services.ses.CfnConfigurationSet.ReputationOptionsProperty reputationOptions) {
            this.props().reputationOptions(reputationOptions);
            return this;
        }

        /**
         * `AWS::SES::ConfigurationSet.SendingOptions`.
         * <p>
         * @return {@code this}
         * @param sendingOptions `AWS::SES::ConfigurationSet.SendingOptions`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sendingOptions(final software.amazon.awscdk.core.IResolvable sendingOptions) {
            this.props().sendingOptions(sendingOptions);
            return this;
        }
        /**
         * `AWS::SES::ConfigurationSet.SendingOptions`.
         * <p>
         * @return {@code this}
         * @param sendingOptions `AWS::SES::ConfigurationSet.SendingOptions`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sendingOptions(final software.amazon.awscdk.services.ses.CfnConfigurationSet.SendingOptionsProperty sendingOptions) {
            this.props().sendingOptions(sendingOptions);
            return this;
        }

        /**
         * `AWS::SES::ConfigurationSet.SuppressionOptions`.
         * <p>
         * @return {@code this}
         * @param suppressionOptions `AWS::SES::ConfigurationSet.SuppressionOptions`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder suppressionOptions(final software.amazon.awscdk.core.IResolvable suppressionOptions) {
            this.props().suppressionOptions(suppressionOptions);
            return this;
        }
        /**
         * `AWS::SES::ConfigurationSet.SuppressionOptions`.
         * <p>
         * @return {@code this}
         * @param suppressionOptions `AWS::SES::ConfigurationSet.SuppressionOptions`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder suppressionOptions(final software.amazon.awscdk.services.ses.CfnConfigurationSet.SuppressionOptionsProperty suppressionOptions) {
            this.props().suppressionOptions(suppressionOptions);
            return this;
        }

        /**
         * `AWS::SES::ConfigurationSet.TrackingOptions`.
         * <p>
         * @return {@code this}
         * @param trackingOptions `AWS::SES::ConfigurationSet.TrackingOptions`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trackingOptions(final software.amazon.awscdk.core.IResolvable trackingOptions) {
            this.props().trackingOptions(trackingOptions);
            return this;
        }
        /**
         * `AWS::SES::ConfigurationSet.TrackingOptions`.
         * <p>
         * @return {@code this}
         * @param trackingOptions `AWS::SES::ConfigurationSet.TrackingOptions`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trackingOptions(final software.amazon.awscdk.services.ses.CfnConfigurationSet.TrackingOptionsProperty trackingOptions) {
            this.props().trackingOptions(trackingOptions);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ses.CfnConfigurationSet}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ses.CfnConfigurationSet build() {
            return new software.amazon.awscdk.services.ses.CfnConfigurationSet(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ses.CfnConfigurationSetProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ses.CfnConfigurationSetProps.Builder();
            }
            return this.props;
        }
    }
}
