/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ses.actions;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.awscdk.services.ses.IReceiptRule;
import software.amazon.awscdk.services.ses.IReceiptRuleAction;
import software.amazon.awscdk.services.ses.ReceiptRuleActionConfig;
import software.amazon.awscdk.services.ses.actions.;
import software.amazon.awscdk.services.ses.actions.S3Props;
import software.amazon.awscdk.services.sns.ITopic;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-ses-actions.S3")
public class S3
extends JsiiObject
implements IReceiptRuleAction {
    protected S3(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected S3(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public S3(@NotNull S3Props props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public ReceiptRuleActionConfig bind(@NotNull IReceiptRule rule) {
        return (ReceiptRuleActionConfig)Kernel.call((Object)((Object)this), (String)"bind", (NativeType)NativeType.forClass(ReceiptRuleActionConfig.class), (Object[])new Object[]{Objects.requireNonNull(rule, "rule is required")});
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<S3> {
        private final S3Props.Builder props = new S3Props.Builder();

        public static Builder create() {
            return new Builder();
        }

        private Builder() {
        }

        public Builder bucket(IBucket bucket) {
            this.props.bucket(bucket);
            return this;
        }

        public Builder kmsKey(IKey kmsKey) {
            this.props.kmsKey(kmsKey);
            return this;
        }

        public Builder objectKeyPrefix(String objectKeyPrefix) {
            this.props.objectKeyPrefix(objectKeyPrefix);
            return this;
        }

        public Builder topic(ITopic topic) {
            this.props.topic(topic);
            return this;
        }

        public S3 build() {
            return new S3(this.props.build());
        }
    }
}

